/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.filter;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.regex.Pattern;
import org.bedework.base.exc.BedeworkBadRequest;
import org.bedework.base.exc.BedeworkException;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class SfpTokenizer
extends StreamTokenizer
implements Logged {
    private static final int WORD_CHAR_START = 32;
    private static final int WORD_CHAR_END = 255;
    private static final int WHITESPACE_CHAR_START = 0;
    private static final int WHITESPACE_CHAR_END = 32;
    private static final Pattern quotePattern = Pattern.compile("([\"'])");
    private BwLogger logger = new BwLogger();

    public SfpTokenizer(Reader rdr) {
        super(rdr);
        this.lowerCaseMode(false);
        this.wordChars(32, 255);
        this.whitespaceChars(0, 32);
        this.ordinaryChar(46);
        this.ordinaryChar(58);
        this.ordinaryChar(59);
        this.ordinaryChar(44);
        this.ordinaryChar(126);
        this.ordinaryChar(61);
        this.ordinaryChar(33);
        this.ordinaryChar(62);
        this.ordinaryChar(60);
        this.ordinaryChar(38);
        this.ordinaryChar(124);
        this.ordinaryChar(40);
        this.ordinaryChar(41);
        this.ordinaryChar(91);
        this.ordinaryChar(93);
        this.ordinaryChar(9);
        this.eolIsSignificant(false);
        this.whitespaceChars(0, 0);
        this.quoteChar(34);
        this.quoteChar(39);
    }

    public int next() {
        try {
            return this.nextToken();
        }
        catch (IOException e) {
            throw new BedeworkException((Throwable)e);
        }
    }

    public void assertToken(int token) {
        try {
            if (this.nextToken() != token) {
                throw new BedeworkBadRequest("Expected [" + token + "], read [" + this.ttype + "] at " + this.lineno());
            }
            if (this.debug()) {
                if (token > 0) {
                    this.debug("[" + (char)token + "]");
                } else {
                    this.debug("[" + token + "]");
                }
            }
        }
        catch (IOException e) {
            throw new BedeworkException((Throwable)e);
        }
    }

    public void assertWord() {
        this.assertToken(-3);
    }

    public void assertString() {
        if (this.testToken(34) || this.testToken(39)) {
            return;
        }
        throw new BedeworkBadRequest("Expected <quoted-string>, read [" + this.ttype + "] at " + this.lineno());
    }

    public boolean testString() {
        return this.testToken(34) || this.testToken(39);
    }

    public void assertToken(String token) {
        this.assertToken(token, false);
    }

    public void assertToken(String token, boolean ignoreCase) {
        this.assertWord();
        if (ignoreCase ? !token.equalsIgnoreCase(this.sval) : !token.equals(this.sval)) {
            throw new BedeworkBadRequest("Expected [" + token + "], read [" + this.sval + "] at " + this.lineno());
        }
        if (this.debug()) {
            this.debug("[" + token + "]");
        }
    }

    public boolean atEof() {
        return this.ttype == -1;
    }

    public boolean testToken(int token) {
        try {
            boolean res;
            boolean bl = res = this.nextToken() == token;
            if (!res) {
                this.pushBack();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new BedeworkException((Throwable)e);
        }
    }

    public boolean testToken(String token) {
        return this.testToken(token, true);
    }

    public boolean testToken(String token, boolean ignoreCase) {
        if (!this.testToken(-3)) {
            return false;
        }
        if (ignoreCase) {
            if (!token.equalsIgnoreCase(this.sval)) {
                this.pushBack();
                return false;
            }
        } else if (!token.equals(this.sval)) {
            this.pushBack();
            return false;
        }
        return true;
    }

    public void skipWhitespace() {
        while (true) {
            this.assertToken(10);
        }
    }

    public static String escapeQuotes(String s) {
        return quotePattern.matcher(s).replaceFirst("\\\\$1");
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

