/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.mail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.bedework.calfacade.mail.Attachment;

public class Message
implements Serializable {
    private String from;
    private String[] mailTo;
    private String[] ccTo;
    private String[] bccTo;
    private String subject;
    private long genDate;
    private String content;
    private Collection<Attachment> attachments;

    public void setFrom(String val) {
        this.from = val;
    }

    public String getFrom() {
        return this.from;
    }

    public void setMailTo(String[] val) {
        this.mailTo = val;
    }

    public String[] getMailTo() {
        return this.mailTo;
    }

    public void setCcTo(String[] val) {
        this.ccTo = val;
    }

    public String[] getCcTo() {
        return this.ccTo;
    }

    public void setBccTo(String[] val) {
        this.bccTo = val;
    }

    public String[] getBccTo() {
        return this.bccTo;
    }

    public void setSubject(String val) {
        this.subject = val;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setGenDate(long val) {
        this.genDate = val;
    }

    public long getGenDate() {
        return this.genDate;
    }

    public void setContent(String val) {
        this.content = val;
    }

    public String getContent() {
        return this.content;
    }

    public void setAttachments(Collection<Attachment> val) {
        this.attachments = val;
    }

    public Collection<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        return this.attachments;
    }

    public void addAttachment(Attachment val) {
        this.getAttachments().add(val);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Message[\n");
        this.appStr(sb, "from", this.getFrom());
        this.appStrs(sb, "to", this.getMailTo());
        this.appStrs(sb, "cc", this.getCcTo());
        this.appStrs(sb, "bcc", this.getBccTo());
        this.appStr(sb, "subject", this.getSubject());
        this.appStr(sb, "content", this.getContent());
        for (Attachment att : this.getAttachments()) {
            sb.append(att.toString());
            sb.append("\n");
        }
        sb.append("]endMessage\n");
        return sb.toString();
    }

    private void appStr(StringBuffer sb, String nm, String val) {
        sb.append(nm);
        sb.append(": ");
        sb.append(val);
        sb.append("\n");
    }

    private void appStrs(StringBuffer sb, String nm, String[] vals) {
        sb.append(nm);
        sb.append(": ");
        if (vals != null) {
            for (int i = 0; i < vals.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(vals[i]);
            }
        }
        sb.append("\n");
    }
}

