/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.svc;

import org.bedework.base.ToString;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.svc.prefs.BwAuthUserPrefs;

@Dump(elementName="authuser", keyFields={"user"})
public class BwAuthUser
extends BwDbentity<BwAuthUser> {
    protected String userHref;
    protected BwAuthUserPrefs prefs;
    private int usertype;

    public static BwAuthUser makeAuthUser(String user, int usertype) {
        BwAuthUser au = new BwAuthUser();
        au.setUserHref(user);
        au.setUsertype(usertype);
        au.setPrefs(BwAuthUserPrefs.makeAuthUserPrefs());
        return au;
    }

    public void setUserHref(String val) {
        this.userHref = val;
    }

    public String getUserHref() {
        return this.userHref;
    }

    public void setPrefs(BwAuthUserPrefs val) {
        this.prefs = val;
    }

    @Dump(compound=true)
    public BwAuthUserPrefs getPrefs() {
        return this.prefs;
    }

    public void setUsertype(int val) {
        this.usertype = val;
    }

    public int getUsertype() {
        return this.usertype;
    }

    public boolean isUnauthorized() {
        return this.getUsertype() == 0;
    }

    public boolean isPublicEventUser() {
        return (this.getUsertype() & 0x40) != 0;
    }

    public boolean isContentAdminUser() {
        return (this.getUsertype() & 0x80) != 0;
    }

    public boolean isApproverUser() {
        return (this.getUsertype() & 0x100) != 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BwAuthUser)) {
            return false;
        }
        BwAuthUser that = (BwAuthUser)obj;
        return this.getUserHref().equals(that.getUserHref());
    }

    @Override
    public int hashCode() {
        return 7 * this.getUserHref().hashCode();
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("user", (Object)this.getUserHref());
        ts.append("usertype", this.getUsertype());
        ts.append("publicEventUser", this.isPublicEventUser());
        ts.append("contentAdminUser", this.isContentAdminUser());
        ts.append("approverUser", this.isApproverUser());
        return ts.toString();
    }

    @Override
    public Object clone() {
        BwAuthUser au = new BwAuthUser();
        au.setUserHref(this.getUserHref());
        au.setUsertype(this.getUsertype());
        BwAuthUserPrefs aup = this.getPrefs();
        if (aup != null) {
            aup = (BwAuthUserPrefs)aup.clone();
            au.setPrefs(aup);
        }
        return au;
    }
}

