/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.svc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.base.ToString;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwProperty;
import org.bedework.calfacade.annotations.Dump;
import org.bedework.calfacade.annotations.NoDump;
import org.bedework.calfacade.base.BwOwnedDbentity;
import org.bedework.calfacade.base.PropertiesEntity;
import org.bedework.calfacade.svc.BwView;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.FromXmlCallback;

@Dump(elementName="preferences", keyFields={"ownerHref"}, firstFields={"ownerHref"})
public class BwPreferences
extends BwOwnedDbentity<BwPreferences>
implements PropertiesEntity {
    protected Collection<BwView> views;
    private String email;
    private String defaultCalendarPath;
    private String skinName;
    private String skinStyle;
    private String preferredView;
    private String preferredViewPeriod;
    private int pageSize = 10;
    private String workDays;
    private int workdayStart;
    private int workdayEnd;
    private String preferredEndType;
    public static final String preferredEndTypeDuration = "duration";
    public static final String preferredEndTypeDate = "date";
    public static final int basicMode = 0;
    public static final int simpleMode = 1;
    public static final int advancedMode = 2;
    public static final int maxMode = 2;
    private int userMode;
    private boolean hour24;
    private boolean scheduleAutoRespond;
    public static int scheduleAutoCancelSetStatus = 0;
    public static int scheduleAutoCancelDelete = 1;
    public static int scheduleMaxAutoCancel = 1;
    private int scheduleAutoCancelAction;
    private boolean scheduleDoubleBook;
    public static int scheduleAutoProcessResponsesNoAcceptNotify = 0;
    public static int scheduleAutoProcessResponsesNotifyAll = 1;
    public static int scheduleAutoProcessResponsesNoNotify = 2;
    public static int scheduleMaxAutoProcessResponses = 2;
    private int scheduleAutoProcessResponses;
    private Set<BwProperty> properties;
    public static final String propertyPreferredLocale = "userpref:preferrred-locale";
    public static final String propertyDefaultViewMode = "userpref:default-view-mode";
    public static final String propertyLastLocale = "userpref:last-locale";
    public static final String propertyCategoryMapping = "userpref:category-mapping";
    public static final String propertyCalsuiteApprovers = "userpref:calsuite-approvers";
    public static final String propertyAttachmentsFolder = "userpref:attachments-folder";
    public static final String propertyDefaultTzid = "userpref:default-tzid";
    public static final String propertyDefaultCategory = "userpref:default-category";
    public static final String propertyScheduleMaxinstances = "userpref:schedule-max-instances";
    public static final String propertyDefaultImageDirectory = "userpref:default-image-directory";
    public static final String propertyAdminResourcesDirectory = "userpref:admin-resources-directory";
    public static final String propertySuiteResourcesDirectory = "userpref:suite-resources-directory";
    public static final String propertyAdminClearFormsOnSubmit = "userpref:admin-clear-form-on-submit";
    public static final String propertyPreferredGroup = "userpref:preferrred-group";
    public static final String propertyNotificationToken = "userpref:notification-token";
    public static final String propertySuppressNotifications = "userpref:no-notifications";
    public static final String propertyMaxEntitySize = "NOTuserpref:max-entity-size";
    public static final String propertyQuotaUsed = "NOTuserpref:quota-used-bytes";
    private static FromXmlCallback fromXmlCb;

    public void setViews(Collection<BwView> val) {
        this.views = val;
    }

    @Dump(collectionElementName="view", compound=true)
    public Collection<BwView> getViews() {
        return this.views;
    }

    public void setEmail(String val) {
        this.email = val;
    }

    public String getEmail() {
        return this.email;
    }

    public void setDefaultCalendarPath(String val) {
        this.defaultCalendarPath = val;
    }

    public String getDefaultCalendarPath() {
        return this.defaultCalendarPath;
    }

    public void setSkinName(String val) {
        this.skinName = val;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinStyle(String val) {
        this.skinStyle = val;
    }

    public String getSkinStyle() {
        return this.skinStyle;
    }

    public void setPreferredView(String val) {
        this.preferredView = val;
    }

    public String getPreferredView() {
        return this.preferredView;
    }

    public void setPreferredViewPeriod(String val) {
        this.preferredViewPeriod = val;
    }

    public String getPreferredViewPeriod() {
        return this.preferredViewPeriod;
    }

    public void setPageSize(int val) {
        this.pageSize = val;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setWorkDays(String val) {
        this.workDays = val;
    }

    public String getWorkDays() {
        return this.workDays;
    }

    public void setWorkdayStart(int val) {
        this.workdayStart = val;
    }

    public int getWorkdayStart() {
        return this.workdayStart;
    }

    public void setWorkdayEnd(int val) {
        this.workdayEnd = val;
    }

    public int getWorkdayEnd() {
        return this.workdayEnd;
    }

    public void setPreferredEndType(String val) {
        this.preferredEndType = val;
    }

    public String getPreferredEndType() {
        return this.preferredEndType;
    }

    public void setUserMode(int val) {
        this.userMode = val;
    }

    public int getUserMode() {
        return this.userMode;
    }

    public void setHour24(boolean val) {
        this.hour24 = val;
    }

    public boolean getHour24() {
        return this.hour24;
    }

    public void setScheduleAutoRespond(boolean val) {
        this.scheduleAutoRespond = val;
    }

    public boolean getScheduleAutoRespond() {
        return this.scheduleAutoRespond;
    }

    public void setScheduleAutoCancelAction(int val) {
        this.scheduleAutoCancelAction = val;
    }

    public int getScheduleAutoCancelAction() {
        return this.scheduleAutoCancelAction;
    }

    public void setScheduleDoubleBook(boolean val) {
        this.scheduleDoubleBook = val;
    }

    public boolean getScheduleDoubleBook() {
        return this.scheduleDoubleBook;
    }

    public void setScheduleAutoProcessResponses(int val) {
        this.scheduleAutoProcessResponses = val;
    }

    public int getScheduleAutoProcessResponses() {
        return this.scheduleAutoProcessResponses;
    }

    @Override
    public void setProperties(Set<BwProperty> val) {
        this.properties = val;
    }

    @Override
    @Dump(collectionElementName="property", compound=true)
    public Set<BwProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Set<BwProperty> getProperties(String name) {
        TreeSet<BwProperty> ps = new TreeSet<BwProperty>();
        if (this.getNumProperties() == 0) {
            return null;
        }
        for (BwProperty p : this.getProperties()) {
            if (!p.getName().equals(name)) continue;
            ps.add(p);
        }
        return ps;
    }

    @Override
    public void removeProperties(String name) {
        Set<BwProperty> ps = this.getProperties(name);
        if (ps == null) {
            return;
        }
        for (BwProperty p : ps) {
            this.removeProperty(p);
        }
    }

    @Override
    @NoDump
    public int getNumProperties() {
        Set<BwProperty> p = this.getProperties();
        if (p == null) {
            return 0;
        }
        return p.size();
    }

    @Override
    public BwProperty findProperty(String name) {
        Set<BwProperty> props = this.getProperties();
        if (props == null) {
            return null;
        }
        for (BwProperty prop : props) {
            if (!name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    @Override
    public void addProperty(BwProperty val) {
        Set<BwProperty> c = this.getProperties();
        if (c == null) {
            c = new TreeSet<BwProperty>();
            this.setProperties(c);
        }
        c.add(val);
    }

    private boolean removeProperty(String name) {
        BwProperty p = this.findProperty(name);
        if (p == null) {
            return false;
        }
        return this.removeProperty(p);
    }

    @Override
    public boolean removeProperty(BwProperty val) {
        Set<BwProperty> c = this.getProperties();
        if (Util.isEmpty(c)) {
            return false;
        }
        return c.remove(val);
    }

    @Override
    public Set<BwProperty> copyProperties() {
        if (this.getNumProperties() == 0) {
            return null;
        }
        return new TreeSet<BwProperty>(this.getProperties());
    }

    @Override
    public Set<BwProperty> cloneProperties() {
        if (this.getNumProperties() == 0) {
            return null;
        }
        TreeSet<BwProperty> ts = new TreeSet<BwProperty>();
        for (BwProperty p : this.getProperties()) {
            ts.add((BwProperty)p.clone());
        }
        return ts;
    }

    public void setCategoryMapping(String val) {
        this.setProp(propertyCategoryMapping, val);
    }

    @NoDump
    public String getCategoryMapping() {
        return this.getProp(propertyCategoryMapping);
    }

    public GetEntityResponse<CategoryMappings> readCategoryMappings() {
        return this.checkCategoryMappings(this.getCategoryMapping());
    }

    public GetEntityResponse<CategoryMappings> checkCategoryMappings(String mappings) {
        GetEntityResponse ger = new GetEntityResponse();
        if (mappings == null) {
            return ger;
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            ger.setEntity((Object)((CategoryMappings)mapper.readValue(mappings, CategoryMappings.class)));
            return ger;
        }
        catch (Throwable t) {
            return (GetEntityResponse)Response.error((Response)ger, (Throwable)t);
        }
    }

    public void setCalsuiteApprovers(String val) {
        this.setProp(propertyCalsuiteApprovers, val);
    }

    @NoDump
    public String getCalsuiteApprovers() {
        return this.getProp(propertyCalsuiteApprovers);
    }

    @NoDump
    public List<String> getCalsuiteApproversList() {
        String[] split;
        ArrayList<String> approvers = new ArrayList<String>();
        String s = this.getProp(propertyCalsuiteApprovers);
        if (s == null) {
            return approvers;
        }
        for (String el : split = s.split(",")) {
            if (el == null) continue;
            approvers.add(el);
        }
        return approvers;
    }

    public void setAttachmentsPath(String val) {
        this.setProp(propertyAttachmentsFolder, val);
    }

    @NoDump
    public String getAttachmentsPath() {
        return this.getProp(propertyAttachmentsFolder);
    }

    public void setDefaultImageDirectory(String val) {
        this.setProp(propertyDefaultImageDirectory, val);
    }

    @NoDump
    public String getDefaultImageDirectory() {
        return this.getProp(propertyDefaultImageDirectory);
    }

    public void setAdminResourcesDirectory(String val) {
        this.setProp(propertyAdminResourcesDirectory, val);
    }

    @NoDump
    public String getAdminResourcesDirectory() {
        return this.getProp(propertyAdminResourcesDirectory);
    }

    public void setSuiteResourcesDirectory(String val) {
        this.setProp(propertySuiteResourcesDirectory, val);
    }

    @NoDump
    public String getSuiteResourcesDirectory() {
        return this.getProp(propertySuiteResourcesDirectory);
    }

    public void setClearFormsOnSubmit(String val) {
        this.setProp(propertyAdminClearFormsOnSubmit, val);
    }

    @NoDump
    public String getClearFormsOnSubmit() {
        return this.getProp(propertyAdminClearFormsOnSubmit);
    }

    public void setDefaultViewMode(String val) {
        this.setProp(propertyDefaultViewMode, val);
    }

    @NoDump
    public String getDefaultViewMode() {
        return this.getProp(propertyDefaultViewMode);
    }

    public void setDefaultTzid(String val) {
        this.setProp(propertyDefaultTzid, val);
    }

    @NoDump
    public String getDefaultTzid() {
        return this.getProp(propertyDefaultTzid);
    }

    public void setMaxEntitySize(long val) {
        this.setLongProp(propertyMaxEntitySize, val);
    }

    @NoDump
    public long getMaxEntitySize() {
        return this.getLongProp(propertyMaxEntitySize);
    }

    public void setQuotaUsed(long val) {
        this.setLongProp(propertyQuotaUsed, val);
    }

    @NoDump
    public long getQuotaUsed() {
        return this.getLongProp(propertyQuotaUsed);
    }

    public void setDefaultCategoryUids(Set<String> val) {
        Set<BwProperty> catuids = this.getProperties(propertyDefaultCategory);
        boolean noprops = Util.isEmpty(catuids);
        if (Util.isEmpty(val)) {
            if (noprops) {
                return;
            }
            for (BwProperty p : catuids) {
                this.removeProperty(p);
            }
            return;
        }
        for (String uid : val) {
            BwProperty p = new BwProperty(propertyDefaultCategory, uid);
            if (noprops) {
                this.addProperty(p);
                continue;
            }
            if (!catuids.contains(p)) {
                this.addProperty(p);
                continue;
            }
            catuids.remove(p);
        }
        if (Util.isEmpty(catuids)) {
            return;
        }
        for (BwProperty p : catuids) {
            this.removeProperty(p);
        }
    }

    @NoDump
    public Set<String> getDefaultCategoryUids() {
        return this.getProps(propertyDefaultCategory);
    }

    @NoDump
    public Set<String> getPreferredGroups() {
        return this.getProps(propertyPreferredGroup);
    }

    @NoDump
    public void addPreferredGroup(String href) {
        this.addProperty(new BwProperty(propertyPreferredGroup, href));
    }

    public void setNotificationToken(String val) {
        this.setProp(propertyNotificationToken, val);
    }

    @NoDump
    public String getNotificationToken() {
        return this.getProp(propertyNotificationToken);
    }

    public void setNoNotifications(boolean val) {
        if (!val) {
            this.removeProperty(propertySuppressNotifications);
            return;
        }
        this.setProp(propertySuppressNotifications, String.valueOf(val));
    }

    @NoDump
    public boolean getNoNotifications() {
        String s = this.getProp(propertySuppressNotifications);
        if (s == null) {
            return false;
        }
        return Boolean.parseBoolean(s);
    }

    @Override
    public void setHref(String val) {
    }

    @Override
    public String getHref() {
        return this.getOwnerHref();
    }

    public boolean addView(BwView val) {
        Collection<BwView> c = this.getViews();
        if (c == null) {
            c = new TreeSet<BwView>();
            this.setViews(c);
        }
        if (c.contains(val)) {
            return false;
        }
        c.add(val);
        return true;
    }

    public void setWorkdayStartTime(String val) {
        this.setWorkdayStart(this.makeMinutesFromTime(val));
    }

    @NoDump
    public String getWorkdayStartTime() {
        return CalFacadeUtil.getTimeFromMinutes(this.getWorkdayStart());
    }

    public void setWorkdayEndTime(String val) {
        this.setWorkdayEnd(this.makeMinutesFromTime(val));
    }

    @NoDump
    public String getWorkdayEndTime() {
        return CalFacadeUtil.getTimeFromMinutes(this.getWorkdayEnd());
    }

    @Override
    public int compareTo(BwPreferences that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        return this.getOwnerHref().compareTo(that.getOwnerHref());
    }

    @Override
    public int hashCode() {
        return this.getOwnerHref().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BwPreferences)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.compareTo((BwPreferences)obj) == 0;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        this.toStringSegment(ts);
        ts.append("email", (Object)this.getEmail());
        ts.append("defaultCalendarPath", (Object)this.getDefaultCalendarPath());
        ts.append("skinName", (Object)this.getSkinName());
        ts.append("skinStyle", (Object)this.getSkinStyle());
        ts.append("preferredView", (Object)this.getPreferredView());
        ts.append("preferredViewPeriod", (Object)this.getPreferredViewPeriod());
        ts.append("pageSize", this.getPageSize());
        ts.append("workDays", (Object)this.getWorkDays());
        ts.append("workdayStart", this.getWorkdayStart());
        ts.append("workdayEnd", this.getWorkdayEnd());
        ts.append("preferredEndType", (Object)this.getPreferredEndType());
        ts.append("userMode", this.getUserMode());
        ts.append("hour24", this.getHour24());
        ts.append("scheduleAutoRespond", this.getScheduleAutoRespond());
        ts.append("scheduleAutoCancelAction", this.getScheduleAutoCancelAction());
        ts.append("scheduleDoubleBook", this.getScheduleDoubleBook());
        ts.append("scheduleAutoProcessResponses", this.getScheduleAutoProcessResponses());
        ts.append("views", this.getViews());
        ts.append("properties", this.getProperties());
        if (this.getCategoryMapping() != null) {
            try {
                this.readCategoryMappings();
                ts.append("readCategoryMappings()", (Object)"ok");
            }
            catch (Throwable t) {
                t.printStackTrace();
                ts.append("readCategoryMappings()", (Object)t.getMessage());
            }
        }
        return ts.toString();
    }

    private int makeMinutesFromTime(String val) {
        boolean badval = false;
        int minutes = 0;
        try {
            int hours = Integer.parseInt(val.substring(0, 2));
            minutes = Integer.parseInt(val.substring(2, 4));
            if (hours < 0 || hours > 24) {
                badval = true;
            } else if (minutes < 0 || minutes > 59) {
                badval = true;
            } else {
                minutes *= hours * 60;
            }
        }
        catch (Throwable t) {
            badval = true;
        }
        if (badval) {
            throw new RuntimeException("org.bedework.prefs.badvalue: " + val);
        }
        return minutes;
    }

    private void setLongProp(String name, long val) {
        BwProperty prop = this.findProperty(name);
        if (prop == null) {
            prop = new BwProperty();
            prop.setName(name);
            prop.setValue(String.valueOf(val));
            this.addProperty(prop);
            return;
        }
        prop.setValue(String.valueOf(val));
    }

    @NoDump
    private long getLongProp(String name) {
        BwProperty prop = this.findProperty(name);
        if (prop == null) {
            return 0L;
        }
        return Long.parseLong(prop.getValue());
    }

    private void setProp(String name, String val) {
        BwProperty prop = this.findProperty(name);
        if (prop == null) {
            prop = new BwProperty();
            prop.setName(name);
            prop.setValue(val);
            this.addProperty(prop);
            return;
        }
        prop.setValue(val);
    }

    @NoDump
    private String getProp(String name) {
        BwProperty prop = this.findProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    @NoDump
    private Set<String> getProps(String name) {
        Set<BwProperty> props = this.getProperties(name);
        TreeSet<String> vals = new TreeSet<String>();
        if (props == null) {
            return vals;
        }
        for (BwProperty p : props) {
            vals.add(p.getValue());
        }
        return vals;
    }

    @NoDump
    public static FromXmlCallback getRestoreCallback() {
        if (fromXmlCb == null) {
            fromXmlCb = new FromXmlCallback();
            fromXmlCb.addClassForName("view", BwView.class);
            fromXmlCb.addClassForName("property", BwProperty.class);
            fromXmlCb.addSkips(new String[]{"byteSize", "id", "seq"});
        }
        return fromXmlCb;
    }

    public static class CategoryMappings {
        private List<CategoryMapping> mappings;

        public void setMappings(List<CategoryMapping> val) {
            this.mappings = val;
        }

        public List<CategoryMapping> getMappings() {
            return this.mappings;
        }
    }

    public static class CategoryMapping {
        private String from;
        private String to;
        private boolean topicalArea;

        public void setFrom(String val) {
            this.from = val;
        }

        public String getFrom() {
            return this.from;
        }

        public void setTo(String val) {
            this.to = val;
        }

        public String getTo() {
            return this.to;
        }

        public void setTopicalArea(boolean val) {
            this.topicalArea = val;
        }

        public boolean isTopicalArea() {
            return this.topicalArea;
        }
    }
}

