/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.svc;

import java.io.Serializable;
import java.util.Comparator;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.util.misc.Util;

class EventOverride
implements Comparable<EventOverride>,
Comparator<EventOverride>,
Serializable {
    private EventInfo ei;

    EventOverride(EventInfo ei) {
        this.ei = ei;
    }

    EventInfo getEventInfo() {
        return this.ei;
    }

    BwEvent getEvent() {
        return this.ei.getEvent();
    }

    @Override
    public int compareTo(EventOverride that) {
        return this.compare(this, that);
    }

    @Override
    public int compare(EventOverride o1, EventOverride o2) {
        if (o1 == o2) {
            return 0;
        }
        BwEvent ev1 = o1.getEvent();
        BwEvent ev2 = o2.getEvent();
        int res = ev1.getUid().compareTo(ev2.getUid());
        if (res != 0) {
            return res;
        }
        return Util.compareStrings((String)ev1.getRecurrenceId(), (String)ev2.getRecurrenceId());
    }

    public int hashCode() {
        return this.getEvent().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventOverride)) {
            return false;
        }
        return this.compareTo((EventOverride)obj) == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Override{eventid=");
        if (this.getEvent() == null) {
            sb.append("UNKNOWN");
        } else {
            sb.append(this.getEvent().getId());
        }
        sb.append(", recurrenceId=");
        sb.append(this.getEvent().getRecurrenceId());
        sb.append("}");
        return sb.toString();
    }
}

