/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import org.bedework.base.exc.BedeworkBadDateException;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.base.BwTimeRange;
import org.bedework.calfacade.locale.BwLocale;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.timezones.Timezones;

public class BwDateTimeUtil {
    private static final DateFormat isoDateTimeUTCFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final DateFormat rfcDateTimeUTCFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");
    private static final DateFormat rfc822GMTFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");

    private BwDateTimeUtil() {
    }

    public static Date getDate(BwDateTime val) throws BedeworkBadDateException {
        return BwDateTimeUtil.getDate(val, Timezones.getTzRegistry());
    }

    public static Date getDate(BwDateTime val, TimeZoneRegistry tzreg) throws BedeworkBadDateException {
        String dtval = val.getDtval();
        try {
            if (val.getDateType()) {
                return DateTimeUtil.fromISODate((String)dtval);
            }
            if (dtval.endsWith("Z")) {
                return DateTimeUtil.fromISODateTimeUTC((String)dtval);
            }
            String tzid = val.getTzid();
            if (tzid == null) {
                return DateTimeUtil.fromISODateTime((String)dtval);
            }
            return DateTimeUtil.fromISODateTime((String)dtval, (java.util.TimeZone)tzreg.getTimeZone(tzid));
        }
        catch (Throwable t) {
            throw new BedeworkBadDateException();
        }
    }

    public static BwDateTime getDateTime(Date date) {
        String dtval = DateTimeUtil.isoDateTime((Date)date);
        return BwDateTimeUtil.getDateTime(dtval, false, false, null);
    }

    public static BwDateTime getDateTime(String date, boolean dateOnly, boolean floating, String tzid) {
        try {
            TimeZone tz = null;
            if (dateOnly || floating) {
                tzid = null;
            }
            if (tzid != null) {
                tz = Timezones.getTz((String)tzid);
                if (tz == null) {
                    throw new BedeworkException("org.bedework.error.unknown.timezone", tzid);
                }
            } else if (!floating) {
                tzid = Timezones.getThreadDefaultTzid();
                tz = Timezones.getDefaultTz();
            }
            if (DateTimeUtil.isISODateTimeUTC((String)date)) {
                Date dt = DateTimeUtil.fromISODateTimeUTC((String)date);
                date = DateTimeUtil.isoDateTime((Date)dt, (java.util.TimeZone)tz);
            }
            return BwDateTime.makeBwDateTime(dateOnly, date, tzid);
        }
        catch (Throwable t) {
            throw new BedeworkBadDateException(t);
        }
    }

    public static BwDateTime getDateTimeUTC(String date) {
        return BwDateTime.fromUTC(false, date);
    }

    public static BwTimeRange getPeriod(String start, String end, int defaultField, int defaultVal, int maxField, int maxVal) {
        Locale loc = BwLocale.getLocale();
        Calendar startCal = Calendar.getInstance(loc);
        startCal.set(11, 0);
        startCal.set(12, 0);
        startCal.set(13, 0);
        Calendar endCal = Calendar.getInstance(loc);
        endCal.set(11, 0);
        endCal.set(12, 0);
        endCal.set(13, 0);
        if (start != null) {
            startCal.setTime(BwDateTimeUtil.fromDate(start));
        }
        if (end == null) {
            endCal.setTime(startCal.getTime());
            endCal.add(defaultField, defaultVal);
        } else {
            endCal.setTime(BwDateTimeUtil.fromDate(end));
        }
        if (maxVal > 0) {
            Calendar check = Calendar.getInstance(loc);
            check.setTime(startCal.getTime());
            check.add(maxField, maxVal);
            if (check.before(endCal)) {
                return null;
            }
        }
        return new BwTimeRange(BwDateTimeUtil.getDateTime(DateTimeUtil.isoDateTime((Date)startCal.getTime()), false, false, null), BwDateTimeUtil.getDateTime(DateTimeUtil.isoDateTime((Date)endCal.getTime()), false, false, null));
    }

    private static Date fromDate(String dt) {
        try {
            if (dt.contains("T")) {
                if (!dt.contains("-")) {
                    return DateTimeUtil.fromISODateTimeUTC((String)dt);
                }
                return DateTimeUtil.fromRfcDateTimeUTC((String)dt);
            }
            if (!dt.contains("-")) {
                return DateTimeUtil.fromISODate((String)dt);
            }
            return DateTimeUtil.fromRfcDate((String)dt);
        }
        catch (Throwable t) {
            throw new BedeworkBadDateException();
        }
    }

    static {
        isoDateTimeUTCFormat.setTimeZone(java.util.TimeZone.getTimeZone("Etc/UTC"));
        isoDateTimeUTCFormat.setLenient(false);
        rfcDateTimeUTCFormat.setTimeZone(java.util.TimeZone.getTimeZone("Etc/UTC"));
        rfcDateTimeUTCFormat.setLenient(false);
        rfc822GMTFormat.setTimeZone(java.util.TimeZone.getTimeZone("Etc/UTC"));
    }
}

