/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.util.Set;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.util.misc.Util;

public class CategoryMapInfo {
    private final BwPreferences.CategoryMappings catMaps;
    private final Set<BwCalendar> topicalAreas;

    public CategoryMapInfo(BwPreferences.CategoryMappings catMaps, Set<BwCalendar> topicalAreas) {
        this.catMaps = catMaps;
        this.topicalAreas = topicalAreas;
    }

    public BwPreferences.CategoryMappings getCatMaps() {
        return this.catMaps;
    }

    public Set<BwCalendar> getTopicalAreas() {
        return this.topicalAreas;
    }

    public boolean getNoMapping() {
        return this.getCatMaps() == null || this.getTopicalAreas() == null;
    }

    public BwPreferences.CategoryMapping findMapping(String val) {
        if (this.catMaps == null || Util.isEmpty(this.catMaps.getMappings())) {
            return null;
        }
        for (BwPreferences.CategoryMapping m : this.catMaps.getMappings()) {
            if (!m.getFrom().equals(val)) continue;
            return m;
        }
        return null;
    }

    public BwCalendar getTopicalArea(BwPreferences.CategoryMapping catMap) {
        Set<BwCalendar> topicalAreas = this.getTopicalAreas();
        if (Util.isEmpty(topicalAreas)) {
            return null;
        }
        for (BwCalendar col : topicalAreas) {
            if (!col.getSummary().equals(catMap.getTo())) continue;
            return col;
        }
        return null;
    }
}

