/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bedework.base.ToString;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttachment;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;

public class ChangeTable
implements Logged,
Serializable {
    private final HashMap<PropertyIndex.PropertyInfoIndex, ChangeTableEntry> map = new HashMap();
    private boolean collectionSetChanged;
    private boolean significantPropertyChanged;
    private final String userHref;
    private static final List<PropertyIndex.PropertyInfoIndex> schedulingInsignificantProperties = List.of(PropertyIndex.PropertyInfoIndex.CLASS, PropertyIndex.PropertyInfoIndex.CREATED, PropertyIndex.PropertyInfoIndex.DTSTAMP, PropertyIndex.PropertyInfoIndex.LAST_MODIFIED, PropertyIndex.PropertyInfoIndex.SEQUENCE, PropertyIndex.PropertyInfoIndex.REQUEST_STATUS, PropertyIndex.PropertyInfoIndex.CREATOR, PropertyIndex.PropertyInfoIndex.OWNER, PropertyIndex.PropertyInfoIndex.COST);
    private static final List<PropertyIndex.PropertyInfoIndex> schedulingSequenceChangeProperties = List.of(PropertyIndex.PropertyInfoIndex.DTSTART, PropertyIndex.PropertyInfoIndex.DTEND, PropertyIndex.PropertyInfoIndex.DURATION, PropertyIndex.PropertyInfoIndex.DUE, PropertyIndex.PropertyInfoIndex.RRULE, PropertyIndex.PropertyInfoIndex.RDATE, PropertyIndex.PropertyInfoIndex.EXDATE, PropertyIndex.PropertyInfoIndex.STATUS);
    private final BwLogger logger = new BwLogger();

    public ChangeTable(String userHref) {
        this.userHref = userHref;
    }

    public String getUserHref() {
        return this.userHref;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean getSignificantChange() {
        return this.collectionSetChanged || this.significantPropertyChanged;
    }

    public boolean getSequenceChangeNeeded() {
        for (ChangeTableEntry cte : this.getEntries()) {
            if (!cte.getChanged() || !schedulingSequenceChangeProperties.contains(cte.getIndex())) continue;
            return true;
        }
        return false;
    }

    public boolean present(PropertyIndex.PropertyInfoIndex index) {
        ChangeTableEntry ent = this.getEntry(index);
        if (ent != null) {
            ent.setPresent(true);
            return true;
        }
        return false;
    }

    public boolean changed(PropertyIndex.PropertyInfoIndex index, Object from, Object to) {
        return this.getEntry(index).setChanged(from, to);
    }

    public void addValue(PropertyIndex.PropertyInfoIndex index, Object val) {
        this.getEntry(index).addValue(val);
    }

    public void addValues(PropertyIndex.PropertyInfoIndex index, Collection<?> val) {
        this.getEntry(index).addValues(val);
    }

    public ChangeTableEntry getEntry(PropertyIndex.PropertyInfoIndex index) {
        ChangeTableEntry ent = this.map.get(index);
        if (ent != null) {
            return ent;
        }
        ent = new ChangeTableEntry(this, index);
        this.map.put(index, ent);
        return ent;
    }

    public Collection<ChangeTableEntry> getEntries() {
        return this.map.values();
    }

    public void processChanges(BwEvent ev, boolean update, boolean attendeeFromOrganizer) {
        HashMap<PropertyIndex.PropertyInfoIndex, ChangeTableEntry> fullmap = new HashMap<PropertyIndex.PropertyInfoIndex, ChangeTableEntry>(this.map);
        for (PropertyIndex.PropertyInfoIndex pii : PropertyIndex.PropertyInfoIndex.values()) {
            ChangeTableEntry ent = fullmap.get(pii);
            if (ent != null) continue;
            ent = new ChangeTableEntry(this, pii);
            fullmap.put(pii, ent);
        }
        block46: for (ChangeTableEntry ent : fullmap.values()) {
            if (ent.getPresent()) continue;
            switch (ev.getEntityType()) {
                case 0: {
                    if (ent.getEventProperty()) break;
                    continue block46;
                }
                case 2: {
                    if (ent.getTodoProperty()) break;
                    continue block46;
                }
                case 4: {
                    if (ent.getFreebusyProperty()) break;
                    continue block46;
                }
                case 5: {
                    if (ent.getEventProperty()) break;
                    continue block46;
                }
                case 6: {
                    if (ent.getEventProperty()) break;
                    continue block46;
                }
                case 7: {
                    if (ent.getVpollProperty()) break;
                    continue block46;
                }
                default: {
                    this.warn("Unsupported entity type: " + ev.getEntityType());
                    continue block46;
                }
            }
            switch (ent.getIndex()) {
                case ACCEPT_RESPONSE: {
                    if (ev.getPollAcceptResponse() == null) break;
                    ent.setDeleted(ev.getPollAcceptResponse());
                    if (!update) break;
                    ev.setPollAcceptResponse(null);
                    break;
                }
                case CLASS: {
                    if (ev.getClassification() == null) break;
                    ent.setDeleted(ev.getClassification());
                    if (!update) break;
                    ev.setClassification(null);
                    break;
                }
                case COMPLETED: {
                    if (ev.getCompleted() == null) break;
                    ent.setDeleted(ev.getCompleted());
                    if (!update) break;
                    ev.setCompleted(null);
                    break;
                }
                case DESCRIPTION: {
                    if (ev.getDescription() == null) break;
                    ent.setDeleted(ev.getDescription());
                    if (!update) break;
                    ev.setDescription(null);
                    break;
                }
                case GEO: {
                    if (ev.getGeo() == null) break;
                    ent.setDeleted(ev.getGeo());
                    if (!update) break;
                    ev.setGeo(null);
                    break;
                }
                case LOCATION: {
                    if (ev.getLocation() == null) break;
                    ent.setDeleted(ev.getLocation());
                    if (!update) break;
                    ev.setLocation(null);
                    break;
                }
                case ORGANIZER: {
                    if (ev.getOrganizer() == null) break;
                    ent.setDeleted(ev.getOrganizer());
                    if (!update) break;
                    ev.setOrganizer(null);
                    break;
                }
                case PERCENT_COMPLETE: {
                    if (ev.getPercentComplete() == null) break;
                    ent.setDeleted(ev.getPercentComplete());
                    if (!update) break;
                    ev.setPercentComplete(null);
                    break;
                }
                case POLL_ITEM_ID: {
                    if (ev.getPollItemId() == null) break;
                    ent.setDeleted(ev.getPollItemId());
                    if (!update) break;
                    ev.setPollItemId(null);
                    break;
                }
                case POLL_MODE: {
                    if (ev.getPollMode() == null) break;
                    ent.setDeleted(ev.getPollMode());
                    if (!update) break;
                    ev.setPollMode(null);
                    break;
                }
                case POLL_PROPERTIES: {
                    if (ev.getPollProperties() == null) break;
                    ent.setDeleted(ev.getPollProperties());
                    if (!update) break;
                    ev.setPollProperties(null);
                    break;
                }
                case PRIORITY: {
                    if (ev.getPriority() == null) break;
                    ent.setDeleted(ev.getPriority());
                    if (!update) break;
                    ev.setPriority(null);
                    break;
                }
                case RELATED_TO: {
                    if (ev.getRelatedTo() == null) break;
                    ent.setDeleted(ev.getRelatedTo());
                    if (!update) break;
                    ev.setRelatedTo(null);
                    break;
                }
                case SEQUENCE: {
                    break;
                }
                case STATUS: {
                    if (ev.getStatus() == null) break;
                    ent.setDeleted(ev.getStatus());
                    if (!update) break;
                    ev.setStatus(null);
                    break;
                }
                case SUMMARY: {
                    if (ev.getSummary() == null) break;
                    ent.setDeleted(ev.getSummary());
                    if (!update) break;
                    ev.setSummary(null);
                    break;
                }
                case URL: {
                    if (ev.getLink() == null) break;
                    ent.setDeleted(ev.getLink());
                    if (!update) break;
                    ev.setLink(null);
                    break;
                }
                case TRANSP: {
                    if (ev.getTransparency() == null) break;
                    ent.setDeleted(ev.getTransparency());
                    if (!update) break;
                    ev.setTransparency(null);
                    break;
                }
            }
        }
        for (ChangeTableEntry ent : fullmap.values()) {
            if (!ent.getEventProperty() && !ent.getVpollProperty()) continue;
            switch (ent.getIndex()) {
                case ATTACH: {
                    Set<BwAttachment> originalVals = ev.getAttachments();
                    if (!this.checkMulti(ent, originalVals, update)) break;
                    ev.setAttachments((Set)ent.getAddedValues());
                    break;
                }
                case ATTENDEE: {
                    Set<BwAttendee> originalVals = ev.getAttendees();
                    if (!this.checkMulti(ent, originalVals, update)) break;
                    ev.setAttendees((Set)ent.getAddedValues());
                    break;
                }
                case CATEGORIES: {
                    Set<BwCategory> originalVals = ev.getCategories();
                    if (!this.checkMulti(ent, originalVals, update)) break;
                    ev.setCategories((Set)ent.getAddedValues());
                    break;
                }
                case COMMENT: {
                    Set<BwString> originalVals = ev.getComments();
                    if (!this.checkMulti(ent, originalVals, update)) break;
                    ev.setComments((Set)ent.getAddedValues());
                    break;
                }
                case CONTACT: {
                    Set<BwContact> originalVals = ev.getContacts();
                    if (!this.checkMulti(ent, originalVals, update)) break;
                    ev.setContacts((Set)ent.getAddedValues());
                    break;
                }
                case PARTICIPANT: {
                    break;
                }
                case REQUEST_STATUS: {
                    Set<BwRequestStatus> originalVals = ev.getRequestStatuses();
                    if (!this.checkMulti(ent, originalVals, update)) break;
                    ev.setRequestStatuses((Set)ent.getAddedValues());
                    break;
                }
                case RELATED_TO: {
                    break;
                }
                case RESOURCES: {
                    Set<BwString> originalVals = ev.getResources();
                    if (!this.checkMulti(ent, originalVals, update)) break;
                    ev.setResources((Set)ent.getAddedValues());
                    break;
                }
                case VALARM: {
                    Set<BwAlarm> originalVals;
                    if (attendeeFromOrganizer || !this.checkMulti(ent, originalVals = ev.getAlarms(), update)) break;
                    ev.setAlarms((Set)ent.getAddedValues());
                    break;
                }
                case XPROP: {
                    List<BwXproperty> originalVals = ev.getXproperties();
                    if (!this.checkMulti(ent, originalVals, update)) break;
                    ev.setXproperties((List)ent.getAddedValues());
                    break;
                }
                case EXDATE: {
                    Set<BwDateTime> originalVals;
                    if (ev.getRecurrenceId() != null || !this.checkMulti(ent, originalVals = ev.getExdates(), update)) break;
                    ev.setExdates((Set)ent.getAddedValues());
                    break;
                }
                case EXRULE: {
                    Set<String> originalVals;
                    if (ev.getRecurrenceId() != null || !this.checkMulti(ent, originalVals = ev.getExrules(), update)) break;
                    ev.setExrules((Set)ent.getAddedValues());
                    break;
                }
                case RDATE: {
                    Set<BwDateTime> originalVals;
                    if (ev.getRecurrenceId() != null || !this.checkMulti(ent, originalVals = ev.getRdates(), update)) break;
                    ev.setRdates((Set)ent.getAddedValues());
                    break;
                }
                case RRULE: {
                    Set<String> originalVals;
                    if (ev.getRecurrenceId() != null || !this.checkMulti(ent, originalVals = ev.getRrules(), update)) break;
                    ev.setRrules((Set)ent.getAddedValues());
                    break;
                }
            }
        }
        for (ChangeTableEntry ent : fullmap.values()) {
            BwAlarm alarm;
            Object ov;
            if (ent.getDeleted()) {
                ev.getChangeset(null).changed(ent.getIndex(), ent.getOldVal(), null);
            }
            if (schedulingInsignificantProperties.contains(ent.getIndex()) || ent.getIndex().equals((Object)PropertyIndex.PropertyInfoIndex.VALARM) && (!((ov = ent.getOldVal()) instanceof BwAlarm) || (alarm = (BwAlarm)ov).getOwnerHref().equals(this.userHref)) || !ent.getAdded() && !ent.getChanged() && !ent.getDeleted()) continue;
            this.significantPropertyChanged = true;
        }
    }

    public void noteCollectionSetChanged() {
        this.collectionSetChanged = true;
    }

    public boolean recurrenceChanged() {
        return this.getEntry(PropertyIndex.PropertyInfoIndex.DTSTART).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.DTEND).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.DURATION).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.DUE).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.EXDATE).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.EXRULE).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.RDATE).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.RRULE).getChanged();
    }

    public boolean recurrenceRulesChanged() {
        return this.getEntry(PropertyIndex.PropertyInfoIndex.DTSTART).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.DTEND).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.DURATION).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.DUE).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.EXRULE).getChanged() || this.getEntry(PropertyIndex.PropertyInfoIndex.RRULE).getChanged();
    }

    public void dumpEntries() {
        this.debug("ChangeTable: ----------------------------");
        for (ChangeTableEntry cte : this.getEntries()) {
            this.debug(cte.toString());
        }
        this.debug("end ChangeTable -------------------------");
    }

    private boolean checkMulti(ChangeTableEntry ent, Collection originalVals, boolean update) {
        if (ent.diff(originalVals)) {
            this.collectionSetChanged = true;
        }
        if (ent.getChanged()) {
            this.map.put(ent.getIndex(), ent);
        }
        if (!ent.getChanged() || !update) {
            return false;
        }
        if (Util.isEmpty((Collection)originalVals)) {
            if (originalVals == null) {
                return !Util.isEmpty((Collection)ent.getAddedValues());
            }
            if (ent.getAddedValues() != null) {
                originalVals.addAll(ent.getAddedValues());
            }
            return false;
        }
        if (ent.getRemovedValues() != null) {
            for (Object o : ent.getRemovedValues()) {
                originalVals.remove(o);
            }
        }
        if (ent.getAddedValues() != null) {
            originalVals.addAll(ent.getAddedValues());
        }
        if (ent.getChangedValues() != null) {
            for (Object o : ent.getChangedValues()) {
                Boolean orig = originalVals.remove(o);
                if (orig instanceof BwAttendee) {
                    ((BwAttendee)o).setCn(((BwAttendee)((Object)orig)).getCn());
                }
                originalVals.add(o);
            }
        }
        return false;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        for (ChangeTableEntry ent : this.map.values()) {
            if (!ent.getPresent()) continue;
            ts.newLine();
            ts.append((Object)ent);
        }
        return ts.toString();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

