/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calfacade.util.xml;

import org.bedework.base.exc.BedeworkBadRequest;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.base.BwTimeRange;
import org.bedework.calfacade.util.BwDateTimeUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CalDavParseUtil {
    public static BwTimeRange parseBwTimeRange(Node nd, String tzid) {
        BwDateTime start = null;
        BwDateTime end = null;
        NamedNodeMap nnm = nd.getAttributes();
        if (nnm == null || nnm.getLength() == 0) {
            throw new BedeworkBadRequest("Infinite time range");
        }
        int attrCt = nnm.getLength();
        try {
            Node nmAttr = nnm.getNamedItem("start");
            if (nmAttr != null) {
                --attrCt;
                start = tzid == null ? BwDateTimeUtil.getDateTimeUTC(nmAttr.getNodeValue()) : BwDateTimeUtil.getDateTime(nmAttr.getNodeValue(), false, false, tzid);
            }
            if ((nmAttr = nnm.getNamedItem("end")) != null) {
                --attrCt;
                end = tzid == null ? BwDateTimeUtil.getDateTimeUTC(nmAttr.getNodeValue()) : BwDateTimeUtil.getDateTime(nmAttr.getNodeValue(), false, false, tzid);
            }
        }
        catch (Throwable t) {
            throw new BedeworkBadRequest(t);
        }
        if (attrCt != 0) {
            throw new BedeworkBadRequest();
        }
        return new BwTimeRange(start, end);
    }
}

