/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.sysevents.listeners;

import org.bedework.sysevents.listeners.BwSysevLoggerMBean;
import org.bedework.sysevents.listeners.LogListener;

public class BwSysevLogger
extends LogListener
implements BwSysevLoggerMBean {
    private ProcessorThread processor;

    public String getName() {
        return "org.bedework.bwengine:service=BwSysevLogger";
    }

    @Override
    public boolean isStarted() {
        return this.processor != null && this.processor.isAlive();
    }

    @Override
    public synchronized void start() {
        if (this.processor != null) {
            this.error("Already started");
            return;
        }
        this.info("************************************************************");
        this.info(" * Starting " + this.getName());
        this.info("************************************************************");
        this.processor = new ProcessorThread(this.getName());
        this.processor.start();
    }

    @Override
    public synchronized void stop() {
        if (this.processor == null) {
            this.error("Already stopped");
            return;
        }
        this.info("************************************************************");
        this.info(" * Stopping " + this.getName());
        this.info("************************************************************");
        this.processor.interrupt();
        try {
            this.processor.join();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable t) {
            this.error("Error waiting for processor termination");
            this.error(t);
        }
        this.processor = null;
        this.info("************************************************************");
        this.info(" * " + this.getName() + " terminated");
        this.info("************************************************************");
    }

    private class ProcessorThread
    extends Thread {
        public ProcessorThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                BwSysevLogger.this.listen();
            }
            catch (Throwable t) {
                BwSysevLogger.this.error(t.getMessage());
            }
        }
    }
}

