/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.sysevents;

import java.io.Serializable;
import javax.jms.CompletionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import org.bedework.sysevents.JmsConnectionHandler;
import org.bedework.sysevents.JmsDefs;
import org.bedework.sysevents.NotificationsHandler;
import org.bedework.sysevents.events.EntityQueuedEvent;
import org.bedework.sysevents.events.HttpEvent;
import org.bedework.sysevents.events.MillisecsEvent;
import org.bedework.sysevents.events.ScheduleUpdateEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.sysevents.events.TimedEvent;
import org.bedework.sysevents.listeners.SysEventListener;

class JmsNotificationsHandlerImpl
extends NotificationsHandler
implements JmsDefs,
CompletionListener {
    private final JmsConn syslog = new JmsConn("syseventslog", this);
    private final JmsConn monitor = new JmsConn("monitor", this);
    private final JmsConn changes = new JmsConn("changes", this);
    private final JmsConn indexer = new JmsConn("crawler", this);
    private final JmsConn scheduleIn = new JmsConn("schedulerIn", this);
    private final JmsConn scheduleOut = new JmsConn("schedulerOut", this);
    private static long sends = 0L;
    private static long sendTime = 0L;

    JmsNotificationsHandlerImpl() {
    }

    public void onCompletion(Message message) {
        if (this.debug()) {
            this.debug("Completion message ");
        }
    }

    public void onException(Message message, Exception e) {
        this.warn("Exception " + e.getMessage() + " for message: " + message);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void post(SysEventBase ev) {
        block9: {
            block8: {
                if (this.debug()) {
                    this.debug(ev.toString());
                }
                start = System.currentTimeMillis();
                if (!(ev instanceof MillisecsEvent)) break block8;
                this.monitor.post(ev);
                if (ev instanceof TimedEvent || ev instanceof HttpEvent) break block9;
            }
            this.syslog.post(ev);
            changeEvent = false;
            for (SysEventBase.Attribute attr : ev.getMessageAttributes()) {
                if (!"changeEvent".equals(attr.name)) continue;
                changeEvent = Boolean.parseBoolean(attr.value);
                break;
            }
            if (changeEvent) {
                this.changes.post(ev);
            }
            if (ev.getSysCode() == SysEventBase.SysCode.REINDEX_EVENT) {
                this.indexer.post(ev);
            }
            if (!(ev instanceof EntityQueuedEvent)) ** GOTO lbl23
            if (!((EntityQueuedEvent)ev).getInBox()) {
                this.scheduleOut.post(ev);
            } else {
                this.scheduleIn.post(ev);
lbl23:
                // 2 sources

                if (ev instanceof ScheduleUpdateEvent) {
                    this.scheduleIn.post(ev);
                }
            }
        }
        JmsNotificationsHandlerImpl.sendTime += System.currentTimeMillis() - start;
        if (++JmsNotificationsHandlerImpl.sends % 100L == 0L) {
            this.debug("Sends: " + JmsNotificationsHandlerImpl.sends + " avg: " + JmsNotificationsHandlerImpl.sendTime / JmsNotificationsHandlerImpl.sends);
        }
    }

    @Override
    public void registerListener(SysEventListener l, boolean persistent) {
    }

    @Override
    public void removeListener(SysEventListener l) {
    }

    @Override
    public void close() {
        if (this.syslog != null) {
            this.close(this.syslog);
        }
        if (this.monitor != null) {
            this.close(this.monitor);
        }
        if (this.changes != null) {
            this.close(this.changes);
        }
        if (this.indexer != null) {
            this.close(this.indexer);
        }
        if (this.scheduleIn != null) {
            this.close(this.scheduleIn);
        }
        if (this.scheduleOut != null) {
            this.close(this.scheduleOut);
        }
    }

    private void close(JmsConn conn) {
        conn.close();
    }

    static class JmsConn {
        private final JmsConnectionHandler conn;
        private final MessageProducer sender;
        private final CompletionListener cl;

        JmsConn(String queueName, CompletionListener cl) {
            try {
                this.cl = cl;
                this.conn = new JmsConnectionHandler();
                this.conn.open(queueName);
                this.sender = this.conn.getProducer();
                this.sender.setDisableMessageID(true);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public void post(SysEventBase ev) {
            try {
                ObjectMessage msg = this.conn.getSession().createObjectMessage();
                msg.setObject((Serializable)ev);
                for (SysEventBase.Attribute attr : ev.getMessageAttributes()) {
                    msg.setStringProperty(attr.name, attr.value);
                }
                long start = System.currentTimeMillis();
                this.sender.send((Message)msg, this.cl);
                ++sends;
                sendTime += System.currentTimeMillis() - start;
            }
            catch (JMSException je) {
                throw new RuntimeException(je);
            }
        }

        public void close() {
            this.conn.close();
        }
    }
}

