/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwcli;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bedework.bwcli.copiedCalFacade.BwAdminGroup;
import org.bedework.bwcli.copiedCalFacade.BwGroup;
import org.bedework.bwcli.copiedCalFacade.BwPrincipal;
import org.bedework.bwcli.copiedCalFacade.BwUser;

public class JsonMapper
extends ObjectMapper {
    public JsonMapper() {
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule("Bw(De)serializerModule", new Version(1, 0, 0, null));
        PrincipalDeserializer deserializer = new PrincipalDeserializer();
        deserializer.registerEntity(1, BwUser.class);
        deserializer.registerEntity(2, BwGroup.class);
        module.addDeserializer(BwPrincipal.class, (JsonDeserializer)deserializer);
        this.registerModule((Module)module);
    }

    private class PrincipalDeserializer
    extends StdDeserializer<BwPrincipal> {
        private final Map<Integer, Class<? extends BwPrincipal>> registry;

        PrincipalDeserializer() {
            super(BwPrincipal.class);
            this.registry = new HashMap<Integer, Class<? extends BwPrincipal>>();
        }

        void registerEntity(int kind, Class<? extends BwPrincipal> cl) {
            this.registry.put(kind, cl);
        }

        public BwPrincipal deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode gonode;
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            ObjectNode root = (ObjectNode)mapper.readTree(jp);
            JsonNode node = root.get("kind");
            if (node == null) {
                return null;
            }
            Number kind = node.numberValue();
            Class<? extends BwPrincipal> cl = this.registry.get(kind.intValue());
            if (cl == null) {
                return null;
            }
            System.out.println("Got class " + cl + " kind " + kind.intValue());
            if (kind.intValue() == 2 && (gonode = root.get("groupOwnerHref")) != null) {
                System.out.println("Class now " + cl);
                cl = BwAdminGroup.class;
            }
            return (BwPrincipal)mapper.treeToValue((TreeNode)root, cl);
        }
    }
}

