/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import org.bedework.bwlogs.AccessLogs;
import org.bedework.bwlogs.DisplaySessions;
import org.bedework.bwlogs.LogAnalysis;
import org.bedework.bwlogs.SummariseTests;
import org.bedework.util.args.Args;

public class BwLogs {
    public static void main(String[] args) {
        String requestDt = null;
        String taskId = null;
        String sessionId = null;
        String sessionUser = null;
        boolean skipAnon = false;
        boolean displayTotals = false;
        DisplaySessions.DisplayMode displayMode = DisplaySessions.DisplayMode.full;
        boolean logShowLong = false;
        boolean logShowMissingTaskIds = false;
        try {
            Args pargs = new Args(args);
            while (pargs.more()) {
                if (pargs.ifMatch("logshowlong")) {
                    logShowLong = true;
                    continue;
                }
                if (pargs.ifMatch("logshowmissingtaskids")) {
                    logShowMissingTaskIds = true;
                    continue;
                }
                if (pargs.ifMatch("logsummarisetests")) {
                    new SummariseTests().process(pargs.next(), logShowLong, logShowMissingTaskIds);
                    return;
                }
                if (pargs.ifMatch("loganalyse")) {
                    new LogAnalysis().process(pargs.next(), logShowLong, logShowMissingTaskIds);
                    return;
                }
                if (pargs.ifMatch("sessions")) {
                    new DisplaySessions(taskId, sessionId, sessionUser, requestDt, skipAnon, displayTotals, displayMode).process(pargs.next(), logShowLong, logShowMissingTaskIds);
                    return;
                }
                if (pargs.ifMatch("skipAnon")) {
                    skipAnon = true;
                    continue;
                }
                if (pargs.ifMatch("displayTotals")) {
                    displayTotals = true;
                    continue;
                }
                if (pargs.ifMatch("summary")) {
                    displayMode = DisplaySessions.DisplayMode.summary;
                    continue;
                }
                if (pargs.ifMatch("list")) {
                    displayMode = DisplaySessions.DisplayMode.list;
                    continue;
                }
                if (pargs.ifMatch("full")) {
                    displayMode = DisplaySessions.DisplayMode.full;
                    continue;
                }
                if (pargs.ifMatch("requestDt")) {
                    requestDt = pargs.next();
                    continue;
                }
                if (pargs.ifMatch("sessionId")) {
                    sessionId = pargs.next();
                    continue;
                }
                if (pargs.ifMatch("taskId")) {
                    taskId = pargs.next();
                    continue;
                }
                if (pargs.ifMatch("sessionUser")) {
                    sessionUser = pargs.next();
                    continue;
                }
                if (pargs.ifMatch("access")) {
                    new AccessLogs().analyze(pargs.next());
                    return;
                }
                BwLogs.usage("Illegal argument: " + pargs.current());
                return;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.err.println();
            System.err.println(msg);
        }
        System.err.println();
        System.err.println("Optional arguments:");
        System.err.println("   access             Analyze access log");
        System.err.println("   logshowlong        To enable display of long requests                      in loganalyse");
        System.err.println("   [logsummarisetests] loganalyse <path>                        Calculate and display information                      from referenced log file. If                      logsummarisetests is present then                       display a summary to help when                      running the tests");
    }
}

