/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.bedework.bwlogs.ContextInfo;
import org.bedework.bwlogs.LogEntry;
import org.bedework.bwlogs.ReqInOutLogEntry;

public abstract class LogReader {
    protected boolean dumpIndented;
    protected LogEntry lastReqline;
    protected long errorLines;
    boolean showLong;
    boolean showMissingTaskIds;
    protected long unterminatedTask;
    protected final Map<String, ReqInOutLogEntry> tasks = new HashMap<String, ReqInOutLogEntry>();
    protected final Map<String, ContextInfo> contexts = new HashMap<String, ContextInfo>();
    protected static Map<String, Integer> longreqIpMap = new HashMap<String, Integer>();
    final String wildflyStart = "[org.jboss.as] (Controller Boot Thread) WFLYSRV0025";

    public abstract void processRecord(String var1);

    public abstract void processInfo(ReqInOutLogEntry var1);

    public void requestOut(ReqInOutLogEntry rsin, ReqInOutLogEntry rsout) {
    }

    public abstract void results();

    public void process(String logPathName, boolean showLong, boolean showMissingTaskIds) {
        this.showLong = showLong;
        this.showMissingTaskIds = showMissingTaskIds;
        try {
            String s;
            Path logPath = Paths.get(logPathName, new String[0]);
            File logFile = logPath.toFile();
            LineNumberReader lnr = new LineNumberReader(new FileReader(logFile));
            while ((s = lnr.readLine()) != null) {
                if (this.dumpIndented) {
                    if (s.startsWith(" ")) {
                        this.out(s);
                        continue;
                    }
                    this.dumpIndented = false;
                }
                if (this.infoLine(s)) {
                    this.doInfo(s);
                    continue;
                }
                this.processRecord(s);
                this.checkErrorLine(s);
            }
            this.results();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void doInfo(String s) {
        if (this.wildflyStart(s)) {
            this.tasks.clear();
            return;
        }
        ReqInOutLogEntry rs = this.tryRequestLine(s);
        if (rs != null) {
            this.lastReqline = rs;
            ReqInOutLogEntry mapRs = this.tasks.get(rs.taskId);
            if (mapRs != null) {
                ++this.unterminatedTask;
            }
            this.tasks.put(rs.taskId, rs);
            return;
        }
        rs = this.tryRequestOut(s);
        if (rs != null) {
            this.processInfo(rs);
            ReqInOutLogEntry mapRs = this.tasks.get(rs.taskId);
            if (mapRs == null) {
                if (this.showMissingTaskIds) {
                    String dt = s.substring(0, s.indexOf(" INFO"));
                    this.outFmt("Missing taskid %s %s", rs.taskId, dt);
                }
                return;
            }
            if (mapRs.context == null) {
                this.outFmt("No context for %s %s", mapRs.dt, mapRs.request);
                return;
            }
            if (!mapRs.sameTask(rs)) {
                this.outFmt("Not same task %s\n %s", mapRs.toString(), rs.toString());
                return;
            }
            long reqMillis = rs.millis - mapRs.millis;
            ContextInfo ci = this.contexts.computeIfAbsent(mapRs.context, k -> new ContextInfo(mapRs.context, longreqIpMap));
            ci.reqOut(s, mapRs, reqMillis, this.showLong);
            if (rs.hasJsessionid()) {
                ++ci.sessions;
            }
            this.requestOut(mapRs, rs);
            this.tasks.remove(rs.taskId);
        }
    }

    protected boolean wildflyStart(String ln) {
        return ln.contains("[org.jboss.as] (Controller Boot Thread) WFLYSRV0025");
    }

    protected boolean infoLine(String ln) {
        return ln.indexOf(" INFO ") == 23;
    }

    protected boolean debugLine(String ln) {
        return ln.indexOf(" DEBUG ") == 23;
    }

    protected void checkErrorLine(String ln) {
        if (ln.indexOf(" ERROR ") != 23) {
            return;
        }
        ++this.errorLines;
    }

    private ReqInOutLogEntry tryRequestLine(String ln) {
        return this.tryRequestInOutLine(ln, true);
    }

    private ReqInOutLogEntry tryRequestOut(String ln) {
        return this.tryRequestInOutLine(ln, false);
    }

    private ReqInOutLogEntry tryRequestInOutLine(String ln, boolean in) {
        ReqInOutLogEntry rs = new ReqInOutLogEntry();
        Integer res = rs.parse(ln, in);
        if (res == null || res < 0) {
            return null;
        }
        return rs;
    }

    public void outSummary(LogEntry le) {
        if (le == null) {
            return;
        }
        this.outFmt("%s %-4s %-8s %s %s", le.dt, le.sinceLastMillis, le.sinceStartMillis, this.taskIdSummary(le), le.logText);
    }

    public String taskIdSummary(LogEntry le) {
        if (le.taskId.startsWith("default ")) {
            return le.taskId.substring(8);
        }
        if (le.taskId.startsWith("org.bedework.bwengine:service=")) {
            return le.taskId.substring(30);
        }
        return le.taskId;
    }

    protected void outFmt(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    protected void out(String val) {
        System.out.println(val);
    }

    protected void out() {
        System.out.println();
    }
}

