/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.bedework.bwlogs.LogEntry;
import org.bedework.util.misc.ToString;

public class ReqInOutLogEntry
extends LogEntry {
    public static final Map<String, Integer> ipMap = new HashMap<String, Integer>();
    public String ip;
    String url;
    boolean unparseable;
    public boolean placeHolder;
    List<NameValuePair> params;
    public String context;
    public String request;
    String sessionId;
    String logPrefix;
    String charset;
    String referer;
    String xForwardedFor;
    public boolean hadError;
    public boolean skipping;
    public boolean doingCalsuite;
    public boolean doingReqPars;
    public String user;
    public String calsuiteName;
    public String uri;
    public String sessid;
    public String exitTo;

    public static ReqInOutLogEntry forMissingEntry(LogEntry le) {
        ReqInOutLogEntry ri = new ReqInOutLogEntry();
        ri.placeHolder = true;
        ri.dt = le.dt;
        ri.logText = le.logText;
        ri.className = le.className;
        ri.taskId = le.taskId;
        return ri;
    }

    public Integer parse(String req, boolean in) {
        int endContextPos;
        int urlPos;
        String logName = in ? "REQUEST" : "REQUEST-OUT";
        if (!req.contains(" " + logName + ":") || super.parse(req, logName, "INFO") == null) {
            return null;
        }
        this.sessionId = this.field();
        if (this.sessionId == null) {
            this.error("No session end found for %s", req);
            return null;
        }
        this.logPrefix = this.field();
        this.charset = this.field();
        if (this.charset == null) {
            this.error("No charset found for %s", req);
            return null;
        }
        this.ip = this.field("http");
        if (this.ip == null) {
            this.error("No ip for %s", req);
            return null;
        }
        this.url = this.dashField();
        if (this.url == null) {
            this.error("No url for %s", req);
            return null;
        }
        String fname = this.field();
        if (!"Referer".equals(fname)) {
            this.error("Expected referer for %s", req);
            return null;
        }
        this.referer = this.dashField();
        fname = this.field();
        if (!"X-Forwarded-For".equals(fname)) {
            this.error("Expected X-Forwarded-For for %s", req);
            return null;
        }
        this.xForwardedFor = req.substring(this.curPos);
        if (!this.xForwardedFor.equals("NONE")) {
            this.ip = this.xForwardedFor;
        }
        if (in) {
            int ct = ipMap.computeIfAbsent(this.ip, k -> 0);
            ipMap.put(this.ip, ++ct);
        }
        int reqPos = urlPos = 10;
        if ((urlPos = this.url.indexOf("/", urlPos)) < 0) {
            return this.curPos;
        }
        if ((endContextPos = this.url.indexOf("/", ++urlPos)) < 0) {
            return this.curPos;
        }
        try {
            this.context = this.url.substring(urlPos, endContextPos);
            this.request = this.url.substring(reqPos);
            if (this.context.trim().length() == 0) {
                this.context = null;
            }
        }
        catch (Throwable t) {
            this.out("%s", req);
            this.out("%s: %s: %s ", urlPos, endContextPos, reqPos);
            return null;
        }
        try {
            this.params = URLEncodedUtils.parse((URI)new URI(this.url), (String)"UTF-8");
            this.unparseable = false;
        }
        catch (Throwable ignored) {
            this.unparseable = true;
        }
        return this.curPos;
    }

    public boolean sameTask(ReqInOutLogEntry otherEntry) {
        if (!super.sameTask(otherEntry)) {
            return false;
        }
        if (!this.sessionId.equals(otherEntry.sessionId)) {
            this.out("sessionId mismatch", new Object[0]);
            return false;
        }
        if (!this.ip.equals(otherEntry.ip)) {
            this.out("ip mismatch", new Object[0]);
            return false;
        }
        return true;
    }

    public boolean hasJsessionid() {
        return this.url != null && this.url.contains(";jsessionid=");
    }

    protected String field() {
        return this.field("");
    }

    protected String field(String nextFieldStart) {
        int start = this.curPos;
        int end = this.req.indexOf(":" + nextFieldStart, start);
        if (end < 0) {
            this.error("No end found for %s", this.req);
            return null;
        }
        String res = this.req.substring(start, end);
        this.curPos = end + 1;
        return res;
    }

    String dashField() {
        int start = this.curPos;
        int end = this.req.indexOf(" - ", start);
        if (end < 0) {
            this.error("No request found for %s", this.req);
            return null;
        }
        String res = this.req.substring(start, end);
        this.curPos = end + 3;
        return res;
    }

    @Override
    protected void toStringSegment(ToString ts) {
        super.toStringSegment(ts);
        ts.append("sessionId", (Object)this.sessionId);
        ts.append("logPrefix", (Object)this.logPrefix);
        ts.append("charset", (Object)this.charset);
        ts.append("ip", (Object)this.ip);
        ts.append("url", (Object)this.url);
    }
}

