/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.bedework.bwlogs.AccessDay;
import org.bedework.bwlogs.AccessLogEntry;
import org.bedework.bwlogs.AccessTracker;

public class AccessLogs {
    int numLegacy;
    int numWebcache;
    int req404;
    int req500;
    int feederUnknown;
    int webCacheUnknown;
    public static AccessTracker accessTracker = new AccessTracker();
    private static final FeedMatcher[] feedMatchers = new FeedMatcher[]{new FeedPattern1(), new FeedPattern2(), new FeedPattern3(), new FeedPattern4(), new FeedPattern5(), new FeedPattern6(), new FeedPattern7(), new FeedPattern8(), new FeedPattern9(), new FeedPattern10()};
    private static final WebcacheMatcher[] webcacheMatchers = new WebcacheMatcher[]{new WebcachePattern1(), new WebcachePattern2(), new WebcachePattern3(), new WebcachePattern4()};

    public boolean analyze(String logPathName) {
        try {
            String s;
            LineNumberReader lnr = this.getLnr(logPathName);
            while ((s = lnr.readLine()) != null) {
                AccessLogEntry ale;
                try {
                    ale = AccessLogEntry.fromString(s);
                }
                catch (Throwable t) {
                    this.out("Unable to parse line at %s\n%s", lnr.getLineNumber(), s);
                    return false;
                }
                if (ale == null) continue;
                accessTracker.updateFrom(ale);
                if (ale.is404()) {
                    ++this.req404;
                    continue;
                }
                if (ale.is500()) {
                    ++this.req500;
                    continue;
                }
                if (ale.legacyFeeder()) {
                    this.doLegacyFeeder(ale);
                    continue;
                }
                if (!ale.webCache()) continue;
                this.doWebCache(ale);
            }
            this.results();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private LineNumberReader getLnr(String logPathName) {
        try {
            Path logPath = Paths.get(logPathName, new String[0]);
            File logFile = logPath.toFile();
            return new LineNumberReader(new FileReader(logFile));
        }
        catch (FileNotFoundException fnfe) {
            String msg = "No such file: " + logPathName;
            this.out(msg, new Object[0]);
            throw new RuntimeException(msg);
        }
    }

    private void results() {
        this.out("Requests getting a 404: %d", this.req404);
        this.out("Requests getting a 500: %d", this.req500);
        this.out("Total feeder legacy requests: %d", this.numLegacy);
        int pattern = 1;
        for (FeedMatcher feedMatcher : feedMatchers) {
            this.out("Total feeder pattern%d requests: %d", pattern, feedMatcher.matched);
            ++pattern;
        }
        this.out("Total unknown feeder requests: %d", this.feederUnknown);
        this.out();
        this.out("Total webcache requests: %d", this.numWebcache);
        for (WebcacheMatcher webcacheMatcher : webcacheMatchers) {
            this.out("Total webcache pattern%d requests: %d", pattern, webcacheMatcher.matched);
            ++pattern;
        }
        this.out("Total unknown webcache requests: %d", this.webCacheUnknown);
        for (String day : accessTracker.getSortedKeys()) {
            AccessDay dayVal = accessTracker.getDay(day);
            this.out();
            this.out1day(day, dayVal);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void out1day(String day, AccessDay dayVal) {
        void var7_9;
        this.out("Ip counts for %s", day);
        this.out();
        List<Map.Entry<String, Integer>> longSorted = dayVal.getSortedIpCounts();
        long total = 0L;
        for (Map.Entry<String, Integer> entry : longSorted) {
            int n = entry.getValue();
            total += (long)n;
            this.outFmt("%-15s\t%d", entry.getKey(), n);
        }
        this.out();
        this.out("Total: %s", total);
        this.out("Ip domain counts for %s", day);
        this.out();
        List<Map.Entry<String, Integer>> long2Sorted = dayVal.getSortedIp2Counts();
        total = 0L;
        for (Map.Entry<String, Integer> entry : long2Sorted) {
            int ct = entry.getValue();
            total += (long)ct;
            this.outFmt("%-15s\t%d", entry.getKey(), ct);
        }
        this.out();
        this.out("Total: %s", total);
        this.out("Avg requests per minute for each hour:", new Object[0]);
        boolean bl = false;
        while (var7_9 <= 23) {
            this.out("%2s: %.2f", (int)var7_9, Float.valueOf(dayVal.getHour((int)var7_9).perSecond() * 60.0f));
            ++var7_9;
        }
        this.out("Avg requests per minute for day: %.2f", Float.valueOf(dayVal.perSecond() * 60.0f));
    }

    private void outFmt(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    private void doLegacyFeeder(AccessLogEntry ale) {
        URI uri;
        ++this.numLegacy;
        try {
            uri = new URI(ale.path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        List params = URLEncodedUtils.parse((URI)uri, (String)"UTF-8");
        HashMap<String, List<String>> paramsMap = new HashMap<String, List<String>>();
        for (NameValuePair param : params) {
            paramsMap.computeIfAbsent(param.getName(), k -> new ArrayList()).add(param.getValue());
        }
        for (FeedMatcher m : feedMatchers) {
            if (!m.match(ale.path, params, paramsMap)) continue;
            ++m.matched;
            return;
        }
        ++this.feederUnknown;
        this.out("Not matched %s", ale.path);
    }

    private void doWebCache(AccessLogEntry ale) {
        URI uri;
        ++this.numWebcache;
        try {
            uri = new URI(ale.path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        List<String> ruri = this.fixPath(uri.getPath());
        for (WebcacheMatcher m : webcacheMatchers) {
            if (!m.match(ale.path, ruri)) continue;
            ++m.matched;
            return;
        }
        ++this.webCacheUnknown;
        this.out("Not matched %s", ale.path);
    }

    private List<String> fixPath(String path) {
        Object decoded;
        if (path == null) {
            return null;
        }
        try {
            decoded = URLDecoder.decode(path, StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            throw new RuntimeException("bad path: " + path);
        }
        if (decoded == null) {
            return null;
        }
        if (((String)decoded).indexOf(92) >= 0) {
            decoded = ((String)decoded).replace('\\', '/');
        }
        if (!((String)decoded).startsWith("/")) {
            decoded = "/" + (String)decoded;
        }
        while (((String)decoded).contains("//")) {
            decoded = ((String)decoded).replaceAll("//", "/");
        }
        StringTokenizer st = new StringTokenizer((String)decoded, "/");
        ArrayList<String> al = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("..")) {
                if (al.size() == 0) {
                    return null;
                }
                al.remove(al.size() - 1);
                continue;
            }
            if (s.equals(".")) continue;
            al.add(s);
        }
        return al;
    }

    static boolean onlyCatUids(String fexpr) {
        String[] segs;
        String frep = fexpr.replace("(", "").replace(")", "").replace("!=", "=");
        for (String seg : segs = frep.split("&")) {
            if (seg.startsWith("catuid=")) continue;
            return false;
        }
        return true;
    }

    private void out(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    private void out() {
        System.out.println();
    }

    static abstract class FeedMatcher {
        int matched;

        FeedMatcher() {
        }

        abstract boolean match(String var1, List<NameValuePair> var2, Map<String, List<String>> var3);

        boolean check(String urlStr, String expectedUrlStr, List<NameValuePair> params, int paramsSize, Map<String, List<String>> paramsMap, int mapSize) {
            if (!urlStr.startsWith(expectedUrlStr)) {
                return false;
            }
            if (params.size() != paramsSize) {
                return false;
            }
            return paramsMap.size() == mapSize;
        }

        boolean checkParVal(String val, String ... vals) {
            if (val == null) {
                return false;
            }
            for (String possible : vals) {
                if (!val.equals(possible)) continue;
                return true;
            }
            return false;
        }

        boolean checkParam(Map<String, List<String>> paramsMap, String name, int num) {
            List<String> vals = paramsMap.get(name);
            return vals != null && vals.size() == num;
        }
    }

    static abstract class WebcacheMatcher {
        int matched;

        WebcacheMatcher() {
        }

        abstract boolean match(String var1, List<String> var2);

        boolean isInt(String s) {
            try {
                Integer.valueOf(s);
                return true;
            }
            catch (Throwable ignored) {
                return false;
            }
        }
    }

    private static class FeedPattern1
    extends FeedMatcher {
        private FeedPattern1() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/main/listEvents.do", params, 6, paramsMap, 5)) {
                return false;
            }
            if (!(this.checkParam(paramsMap, "calPath", 1) && this.checkParam(paramsMap, "skinName", 1) && this.checkParam(paramsMap, "setappvar", 2) && this.checkParam(paramsMap, "fexpr", 1) && this.checkParam(paramsMap, "days", 1))) {
                return false;
            }
            if (!this.checkParVal(paramsMap.get("skinName").get(0), "list-json")) {
                return false;
            }
            return AccessLogs.onlyCatUids(paramsMap.get("fexpr").get(0));
        }
    }

    private static class FeedPattern2
    extends FeedMatcher {
        private FeedPattern2() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/main/listEvents.do", params, 4, paramsMap, 4)) {
                return false;
            }
            if (!(this.checkParam(paramsMap, "calPath", 1) && this.checkParam(paramsMap, "skinName", 1) && this.checkParam(paramsMap, "setappvar", 1) && this.checkParam(paramsMap, "days", 1))) {
                return false;
            }
            return this.checkParVal(paramsMap.get("skinName").get(0), "list-rss", "list-json", "default");
        }
    }

    private static class FeedPattern3
    extends FeedMatcher {
        private FeedPattern3() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/main/listEvents.do", params, 5, paramsMap, 5)) {
                return false;
            }
            if (!(this.checkParam(paramsMap, "calPath", 1) && this.checkParam(paramsMap, "skinName", 1) && this.checkParam(paramsMap, "setappvar", 1) && this.checkParam(paramsMap, "fexpr", 1) && this.checkParam(paramsMap, "days", 1))) {
                return false;
            }
            if (!this.checkParVal(paramsMap.get("skinName").get(0), "list-rss", "list-json", "default")) {
                return false;
            }
            return AccessLogs.onlyCatUids(paramsMap.get("fexpr").get(0));
        }
    }

    private static class FeedPattern4
    extends FeedMatcher {
        private FeedPattern4() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/main/listEvents.do", params, 2, paramsMap, 2)) {
                return false;
            }
            if (!this.checkParam(paramsMap, "calPath", 1) || !this.checkParam(paramsMap, "skinName", 1)) {
                return false;
            }
            return this.checkParVal(paramsMap.get("skinName").get(0), "list-rss");
        }
    }

    private static class FeedPattern5
    extends FeedMatcher {
        private FeedPattern5() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/main/listEvents.do", params, 5, paramsMap, 4)) {
                return false;
            }
            if (!(this.checkParam(paramsMap, "calPath", 1) && this.checkParam(paramsMap, "skinName", 1) && this.checkParam(paramsMap, "setappvar", 2) && this.checkParam(paramsMap, "days", 1))) {
                return false;
            }
            return this.checkParVal(paramsMap.get("skinName").get(0), "list-json");
        }
    }

    private static class FeedPattern6
    extends FeedMatcher {
        private FeedPattern6() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/main/listEvents.do", params, 5, paramsMap, 5)) {
                return false;
            }
            if (!(this.checkParam(paramsMap, "calPath", 1) && this.checkParam(paramsMap, "format", 1) && this.checkParam(paramsMap, "setappvar", 1) && this.checkParam(paramsMap, "fexpr", 1) && this.checkParam(paramsMap, "days", 1))) {
                return false;
            }
            return AccessLogs.onlyCatUids(paramsMap.get("fexpr").get(0));
        }
    }

    private static class FeedPattern7
    extends FeedMatcher {
        private FeedPattern7() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/main/listEvents.do", params, 4, paramsMap, 4)) {
                return false;
            }
            return this.checkParam(paramsMap, "calPath", 1) && this.checkParam(paramsMap, "format", 1) && this.checkParam(paramsMap, "setappvar", 1) && this.checkParam(paramsMap, "days", 1);
        }
    }

    private static class FeedPattern8
    extends FeedMatcher {
        private FeedPattern8() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/widget/categories.do", params, 3, paramsMap, 3)) {
                return false;
            }
            if (!(this.checkParam(paramsMap, "calPath", 1) && this.checkParam(paramsMap, "setappvar", 1) && this.checkParam(paramsMap, "skinName", 1))) {
                return false;
            }
            return this.checkParVal(paramsMap.get("skinName").get(0), "widget-json-cats");
        }
    }

    private static class FeedPattern9
    extends FeedMatcher {
        private FeedPattern9() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/main/listEvents.do", params, 6, paramsMap, 6)) {
                return false;
            }
            if (!(this.checkParam(paramsMap, "calPath", 1) && this.checkParam(paramsMap, "skinName", 1) && this.checkParam(paramsMap, "setappvar", 1) && this.checkParam(paramsMap, "fexpr", 1) && this.checkParam(paramsMap, "start", 1) && this.checkParam(paramsMap, "end", 1))) {
                return false;
            }
            if (!this.checkParVal(paramsMap.get("skinName").get(0), "list-rss")) {
                return false;
            }
            return AccessLogs.onlyCatUids(paramsMap.get("fexpr").get(0));
        }
    }

    private static class FeedPattern10
    extends FeedMatcher {
        private FeedPattern10() {
        }

        @Override
        boolean match(String urlStr, List<NameValuePair> params, Map<String, List<String>> paramsMap) {
            if (!this.check(urlStr, "/feeder/main/listEvents.do", params, 5, paramsMap, 5)) {
                return false;
            }
            if (!(this.checkParam(paramsMap, "calPath", 1) && this.checkParam(paramsMap, "skinName", 1) && this.checkParam(paramsMap, "setappvar", 1) && this.checkParam(paramsMap, "start", 1) && this.checkParam(paramsMap, "end", 1))) {
                return false;
            }
            return this.checkParVal(paramsMap.get("skinName").get(0), "list-rss");
        }
    }

    private static class WebcachePattern1
    extends WebcacheMatcher {
        private WebcachePattern1() {
        }

        @Override
        boolean match(String urlStr, List<String> ruri) {
            if (ruri.size() != 7) {
                return false;
            }
            if (!"webcache".equals(ruri.get(0))) {
                return false;
            }
            if (!"v1.0".equals(ruri.get(1))) {
                return false;
            }
            if (!"jsonDays".equals(ruri.get(2)) && !"rssDays".equals(ruri.get(2))) {
                return false;
            }
            if (!this.isInt(ruri.get(3))) {
                return false;
            }
            if (!"list-rss".equals(ruri.get(4)) && !"list-json".equals(ruri.get(4))) {
                return false;
            }
            String fexpr = ruri.get(5);
            if (!"no--filter".equals(fexpr) && !AccessLogs.onlyCatUids(fexpr)) {
                return false;
            }
            return "bwObject.json".equals(ruri.get(6)) || "no--object.json".equals(ruri.get(6));
        }
    }

    private static class WebcachePattern2
    extends WebcacheMatcher {
        private WebcachePattern2() {
        }

        @Override
        boolean match(String urlStr, List<String> ruri) {
            if (ruri.size() != 6) {
                return false;
            }
            if (!"webcache".equals(ruri.get(0))) {
                return false;
            }
            if (!"v1.0".equals(ruri.get(1))) {
                return false;
            }
            if (!("jsonDays".equals(ruri.get(2)) || "rssDays".equals(ruri.get(2)) || "xmlDays".equals(ruri.get(2)))) {
                return false;
            }
            if (!this.isInt(ruri.get(3))) {
                return false;
            }
            if (!("list-rss".equals(ruri.get(4)) || "list-json".equals(ruri.get(4)) || "list-xml".equals(ruri.get(4)))) {
                return false;
            }
            String fexpr = ruri.get(5);
            return "no--filter.rss".equals(fexpr) || "no--filter.xml".equals(fexpr) || AccessLogs.onlyCatUids(fexpr);
        }
    }

    private static class WebcachePattern3
    extends WebcacheMatcher {
        private WebcachePattern3() {
        }

        @Override
        boolean match(String urlStr, List<String> ruri) {
            if (ruri.size() != 5) {
                return false;
            }
            if (!"webcache".equals(ruri.get(0))) {
                return false;
            }
            if (!"v1.0".equals(ruri.get(1))) {
                return false;
            }
            if (!"icsDays".equals(ruri.get(2))) {
                return false;
            }
            if (!this.isInt(ruri.get(3))) {
                return false;
            }
            String fexpr = ruri.get(4);
            return "no--filter.ics".equals(fexpr) || AccessLogs.onlyCatUids(fexpr);
        }
    }

    private static class WebcachePattern4
    extends WebcacheMatcher {
        private WebcachePattern4() {
        }

        @Override
        boolean match(String urlStr, List<String> ruri) {
            if (ruri.size() != 5) {
                return false;
            }
            if (!"webcache".equals(ruri.get(0))) {
                return false;
            }
            if (!"v1.0".equals(ruri.get(1))) {
                return false;
            }
            if (!"categories".equals(ruri.get(2))) {
                return false;
            }
            if (!"widget-json-cats".equals(ruri.get(3))) {
                return false;
            }
            return "catsObj.json".equals(ruri.get(4));
        }
    }

    private static class WebcachePattern5
    extends WebcacheMatcher {
        private WebcachePattern5() {
        }

        @Override
        boolean match(String urlStr, List<String> ruri) {
            if (ruri.size() != 9) {
                return false;
            }
            if (!"webcache".equals(ruri.get(0))) {
                return false;
            }
            if (!"v1.0".equals(ruri.get(1))) {
                return false;
            }
            if (!"jsonDays".equals(ruri.get(2))) {
                return false;
            }
            if (!this.isInt(ruri.get(3))) {
                return false;
            }
            if (!"list-json".equals(ruri.get(4))) {
                return false;
            }
            String fexpr = ruri.get(5);
            if (!"no--filter".equals(fexpr) && !AccessLogs.onlyCatUids(fexpr)) {
                return false;
            }
            if (!this.isInt(ruri.get(6))) {
                return false;
            }
            if (!this.isInt(ruri.get(7))) {
                return false;
            }
            return this.isInt(ruri.get(8));
        }
    }
}

