/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.util.Arrays;
import java.util.List;
import org.bedework.bwlogs.LogAnalysis;
import org.bedework.bwlogs.LogEntry;
import org.bedework.bwlogs.ReqInOutLogEntry;

public class DisplaySessions
extends LogAnalysis {
    private final String taskId;
    private final String sessionId;
    private final String user;
    private final String requestDt;
    private final boolean skipAnon;
    private final boolean displayTotals;
    private final DisplayMode displayMode;
    private ReqInOutLogEntry lastMapRs;
    private final List<String> skipClasses = Arrays.asList("org.apache.struts2", "org.bedework.timezones.server.", "org.bedework.util.servlet.HttpServletUtils");
    private final List<String> skipUnparsed = Arrays.asList("A soft-locked cache entry");
    private final List<String> skipContent = Arrays.asList("About to embed ", "About to flush", "About to get state", "About to prepare render", "After embed ", "Close for ", "contentlen=", "entry", "Found form in session", "getUserPrincipal.name", "getWriter called", "host=", "HttpUtils.getRequestURL(req) = ", "java.sql.Connection#beginRequest has been invoked", "java.sql.Connection#endRequest has been invoked", "No form in session", "Obtained state", "out Obtained BwCallback object", "request=org.apache.struts2", "Request out for module ", "Request parameters - global info and uris", "Set presentation state", "setAutoCommit", "Setting locale to ", "XSLTFilter: Converting", "==============", "parameters:", "actionType:", "conversation: ", "query=b=de", "query=null");
    private final List<String> skipForSummary = Arrays.asList("checkSvci", "About to claim", "Begin transaction for ", "ChangeTable", "Check access for ", "Client interface --", "close Obtained BwCallback object", "current change token", "Date=", "Emitted:", "end ChangeTable", "End transaction for", "Event duration=", "Fetch collection with", "fetchChildren for", "fetchEntities: ", "flush for ", "Get Calendar home for", "Get event ", "getState--", "getUserEntry for", "handleException called", "Indexing to index", "IndexResponse:", "New hibernate session", "No access", "No messages emitted", "Not found", "offset:", "Open session for", "Return ok - access ok", "Search:", "Set event with location", "The size was");
    final String sessionDelim = "----------------------------------\n";

    public DisplaySessions(String taskId, String sessionId, String user, String requestDt, boolean skipAnon, boolean displayTotals, DisplayMode displayMode) {
        this.taskId = taskId;
        this.sessionId = sessionId;
        this.user = user;
        this.requestDt = requestDt;
        this.skipAnon = skipAnon;
        this.displayTotals = displayTotals;
        this.displayMode = displayMode;
    }

    @Override
    public void processRecord(String s) {
        LogEntry le = new LogEntry();
        if (!s.startsWith("202")) {
            le.unparsed(s);
            if (this.lastMapRs != null) {
                if (this.lastMapRs.doingCalsuite) {
                    String nmstr = "  name=";
                    int spos = s.indexOf("  name=");
                    if (spos >= 0) {
                        int pos = s.indexOf(",", spos);
                        if (pos < 0) {
                            le.unparsed(s);
                        } else {
                            this.lastMapRs.calsuiteName = s.substring(spos + "  name=".length(), pos);
                        }
                    }
                } else if (this.lastMapRs.lastAdded != null) {
                    this.lastMapRs.lastAdded.addLogEntry(le);
                } else {
                    this.lastMapRs.addLogEntry(le);
                }
            }
            return;
        }
        if (le.parse(s, null, null) == null) {
            le.unparsed(s);
            if (this.lastMapRs != null) {
                this.lastMapRs.addLogEntry(le);
            }
            return;
        }
        if ("ERROR".equals(le.level)) {
            // empty if block
        }
        if ("ChangeNotifications".equals(le.taskId)) {
            return;
        }
        if (this.startMatches(le.className, this.skipClasses) || this.startMatches(le.logText, this.skipContent)) {
            return;
        }
        if (this.taskId != null && !this.taskId.equals(le.taskId)) {
            return;
        }
        ReqInOutLogEntry mapRs = (ReqInOutLogEntry)this.tasks.get(le.taskId);
        if (mapRs == null) {
            mapRs = ReqInOutLogEntry.forMissingEntry(le);
            this.tasks.put(le.taskId, mapRs);
        }
        mapRs.doingCalsuite = false;
        this.lastMapRs = mapRs;
        if (this.sessionId != null && mapRs.sessid != null && !mapRs.sessid.equals(this.sessionId)) {
            mapRs.skipping = true;
            return;
        }
        if (this.requestDt != null && mapRs.dt != null && !mapRs.dt.startsWith(this.requestDt)) {
            mapRs.skipping = true;
            return;
        }
        if (mapRs.skipping) {
            return;
        }
        if ("ERROR".equals(le.level)) {
            mapRs.hadError = true;
        }
        String lt = le.logText;
        if (mapRs.doingReqPars) {
            if (lt.startsWith("  ")) {
                if (lt.startsWith("  b = \"de\"")) {
                    return;
                }
                if (mapRs.lastAdded != null) {
                    mapRs.lastAdded.addLogEntry(le);
                    return;
                }
            }
            mapRs.doingReqPars = false;
        }
        String exitTo = "exit to ";
        String gru = "getRemoteUser = ";
        String gruri = "getRequestURI = ";
        String grsess = "getRequestedSessionId = ";
        String fcs = "Found calSuite BwCalSuiteWrapper";
        String rq = "Request parameters";
        if (lt.startsWith("getRemoteUser = ")) {
            String loguser = lt.substring("getRemoteUser = ".length());
            if (this.skipAnon && "null".equals(loguser)) {
                mapRs.skipping = true;
                return;
            }
            if (this.user != null && !this.user.equals(loguser)) {
                mapRs.skipping = true;
                return;
            }
            mapRs.user = loguser;
        } else if (lt.startsWith("getRequestURI = ")) {
            mapRs.uri = lt.substring("getRequestURI = ".length());
        } else if (lt.startsWith("getRequestedSessionId = ")) {
            mapRs.sessid = lt.substring("getRequestedSessionId = ".length());
        } else if (lt.startsWith("exit to ")) {
            mapRs.exitTo = lt.substring("exit to ".length());
        } else if (lt.startsWith("Found calSuite BwCalSuiteWrapper")) {
            mapRs.doingCalsuite = true;
        } else {
            if ("Request parameters".equals(lt)) {
                mapRs.doingReqPars = true;
                mapRs.addLogEntry(le);
                return;
            }
            mapRs.addLogEntry(le);
        }
    }

    @Override
    public void results() {
        if (this.displayTotals) {
            super.results();
        }
    }

    @Override
    public void requestOut(ReqInOutLogEntry rsin, ReqInOutLogEntry rsout) {
        if (rsin.skipping) {
            return;
        }
        if (this.taskId != null && !this.taskId.equals(rsin.taskId)) {
            return;
        }
        if (this.user != null && !this.user.equals(rsin.user)) {
            return;
        }
        this.outFmt("     uri: %s", rsin.uri);
        this.outFmt(" exit to: %s", rsin.exitTo);
        this.outFmt("Request in: %s out %s task %s", rsin.dt, rsout.dt, rsin.taskId);
        if (rsin.placeHolder) {
            this.out("   **** No REQUEST in found *****");
        }
        if (rsin.hadError) {
            this.out("***** An error occurred");
        }
        this.outFmt("  sessid: %s", rsin.sessid);
        this.outFmt("   class: %s", rsin.className);
        this.outFmt("    user: %s  calsuite %s", rsin.user, rsin.calsuiteName);
        boolean fetchEvent = rsin.className.endsWith("FetchEventAction");
        boolean updateEvent = rsin.className.endsWith("UpdateEventAction");
        if (this.displayMode == DisplayMode.list && !fetchEvent && !updateEvent) {
            this.out("----------------------------------\n");
            return;
        }
        for (LogEntry le : rsin.entries) {
            String lt = le.logText;
            if (lt == null) continue;
            boolean doingRpars = lt.equals("Request parameters");
            if (fetchEvent && doingRpars) {
                this.displayEventHref(le);
                continue;
            }
            if (doingRpars && updateEvent) {
                this.displayEventHref(le);
            }
            if (this.displayMode == DisplayMode.list || this.displayMode == DisplayMode.summary && this.startMatches(le.logText, this.skipForSummary)) continue;
            if (doingRpars) {
                if (!le.entries.isEmpty()) {
                    this.out("  Request parameters:");
                } else {
                    this.out("  Request parameters: none");
                }
            } else {
                this.outFmt("         %s", lt);
            }
            if (le.entries.isEmpty()) continue;
            for (LogEntry suble : le.entries) {
                this.outFmt("             %s", suble.logText);
            }
        }
        this.out("----------------------------------\n");
    }

    private void displayEventHref(LogEntry le) {
        String calPath = null;
        String guid = null;
        String rid = null;
        String href = null;
        if (!le.entries.isEmpty()) {
            for (LogEntry suble : le.entries) {
                String val = this.tryReqPar(suble, "calPath");
                if (val != null) {
                    calPath = val;
                    continue;
                }
                val = this.tryReqPar(suble, "guid");
                if (val != null) {
                    guid = val;
                    continue;
                }
                val = this.tryReqPar(suble, "recurrenceId");
                if (val != null) {
                    rid = val;
                    continue;
                }
                val = this.tryReqPar(suble, "href");
                if (val == null) continue;
                href = val;
            }
        }
        if (href != null) {
            this.outFmt("   event: %s", href);
            return;
        }
        if (rid == null) {
            this.outFmt("   event: %s %s", calPath, guid);
            return;
        }
        this.outFmt("   event: %s %s %s", calPath, guid, rid);
    }

    private String tryReqPar(LogEntry le, String parName) {
        String lt = le.logText;
        String test = parName + " = \"";
        int pos = lt.indexOf(test);
        if (pos < 0) {
            return null;
        }
        return lt.substring(pos + test.length()).replace("\"", "");
    }

    private boolean startMatches(String text, List<String> prefixes) {
        if (text == null) {
            return false;
        }
        for (String s : prefixes) {
            if (!text.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static enum DisplayMode {
        full,
        summary,
        list;

    }
}

