/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.bedework.bwlogs.ContextInfo;
import org.bedework.bwlogs.LogReader;
import org.bedework.bwlogs.ReqInOutLogEntry;
import org.bedework.util.misc.Util;

public class LogAnalysis
extends LogReader {
    long totalRequests;
    long totalForwardedRequests;

    @Override
    public void processRecord(String s) {
    }

    @Override
    public void processInfo(ReqInOutLogEntry rs) {
    }

    @Override
    public void results() {
        this.outFmt("Total requests: %d", this.totalRequests);
        if (this.totalForwardedRequests != this.totalRequests) {
            this.outFmt("Total forwarded requests: %d", this.totalForwardedRequests);
        }
        this.outFmt("Millis per request by context per 100 millis", new Object[0]);
        TreeSet contextNames = new TreeSet(this.contexts.keySet());
        String labelPattern = " %6s |";
        ContextInfo[] cis = new ContextInfo[contextNames.size()];
        String[] cellFormats = new String[contextNames.size()];
        String[] hdrFormats = new String[contextNames.size()];
        int cx = 0;
        StringBuilder header = new StringBuilder(String.format(" %6s |", ""));
        for (String context : contextNames) {
            ContextInfo ci;
            cis[cx] = ci = (ContextInfo)this.contexts.get(context);
            int fldLen = Math.max(context.length(), 5);
            cellFormats[cx] = " %" + fldLen + "s - %3s%% |";
            String hdrFmt = "        %" + fldLen + "s |";
            hdrFormats[cx] = hdrFmt;
            header.append(String.format(hdrFmt, context));
            ++cx;
        }
        this.outFmt("%s", header);
        for (int i = 0; i < 20; ++i) {
            StringBuilder l = new StringBuilder(String.format(" %6s |", "<" + (i + 1) * 100));
            for (int j = 0; j < cis.length; ++j) {
                ContextInfo ci = cis[j];
                l.append(String.format(cellFormats[j], ci.getBucket(i), (int)(100L * ci.rTotalReq / ci.getRequests())));
                ci.rTotalReq += ci.getBucket(i);
            }
            this.outFmt("%s", l);
        }
        StringBuilder sessReq = new StringBuilder(String.format(" %6s |", "Sess"));
        StringBuilder totReq = new StringBuilder(String.format(" %6s |", "Total"));
        StringBuilder avgMs = new StringBuilder(String.format(" %6s |", "Avg ms"));
        StringBuilder subTtotReq = new StringBuilder(String.format(" %6s |", "Total"));
        StringBuilder subTavgMs = new StringBuilder(String.format(" %6s |", "Avg ms"));
        for (int j = 0; j < cis.length; ++j) {
            ContextInfo ci = cis[j];
            sessReq.append(String.format(hdrFormats[j], ci.getSessions()));
            totReq.append(String.format(hdrFormats[j], ci.getRequests()));
            avgMs.append(String.format(hdrFormats[j], (int)(ci.getTotalMillis() / ci.getRequests())));
            subTtotReq.append(String.format(hdrFormats[j], ci.getSubTrequests()));
            subTavgMs.append(String.format(hdrFormats[j], (int)(ci.getSubTtotalMillis() / ci.getSubTrequests())));
        }
        this.outFmt("%s", sessReq);
        this.outFmt("%s", totReq);
        this.outFmt("%s", avgMs);
        this.outFmt("%s", "Figures ignoring highest bucket:");
        this.outFmt("%s", subTtotReq);
        this.outFmt("%s", subTavgMs);
        this.out();
        this.outFmt("Total error lines: %d", this.errorLines);
        this.out();
        int numIps = 20;
        this.outFmt("List of top %d ips", 20);
        List sorted = Util.sortMap(ReqInOutLogEntry.ipMap);
        int ct = 0;
        for (Map.Entry ent : sorted) {
            this.outFmt("%s\t%d", ent.getKey(), ent.getValue());
            if (++ct <= 20) continue;
            break;
        }
        this.out();
        this.outFmt("List of top %d long request ips", 20);
        List longSorted = Util.sortMap((Map)longreqIpMap);
        ct = 0;
        for (Map.Entry ent : longSorted) {
            this.outFmt("%s\t%d", ent.getKey(), ent.getValue());
            if (++ct <= 20) continue;
            break;
        }
    }
}

