/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.bwlogs;

import org.bedework.bwlogs.LogAnalysis;
import org.bedework.bwlogs.LogEntry;
import org.bedework.bwlogs.ReqInOutLogEntry;

public class SummariseTests
extends LogAnalysis {
    int waitcountCount;
    LogEntry lastEntry;

    @Override
    public void processRecord(String s) {
        boolean isWaitcount;
        LogEntry le = new LogEntry();
        if (le.parse(s, null, "DEBUG") == null) {
            this.out(s + " ******************** Unparseable");
            return;
        }
        if (s.contains(" entry: ")) {
            this.lastEntry = le;
            return;
        }
        String testUserAgentLabel = "User-Agent = \"Cal-Tester: ";
        boolean isUserAgent = s.contains("User-Agent = \"");
        boolean isCalTest = s.contains("User-Agent = \"Cal-Tester: ");
        boolean bl = isWaitcount = isCalTest && s.contains("WAITCOUNT ");
        if (isWaitcount) {
            if (this.waitcountCount > 0) {
                ++this.waitcountCount;
                return;
            }
            this.lastEntry = null;
            this.waitcountCount = 1;
        } else if (isUserAgent && this.waitcountCount > 0) {
            this.out(">---------------------------- WAITCOUNT = " + this.waitcountCount);
            this.waitcountCount = 0;
        }
        if (this.waitcountCount > 1) {
            return;
        }
        if (s.contains(" User-Agent = \"")) {
            this.outSummary(this.lastReqline);
            this.outSummary(this.lastEntry);
            int pos = le.logText.indexOf("User-Agent = \"Cal-Tester: ");
            if (pos >= 0) {
                le.logText = "------------- Test ---> " + le.logText.substring(0, pos) + le.logText.substring(pos + "User-Agent = \"Cal-Tester: ".length(), le.logText.length() - 1) + "<------------------";
                this.outSummary(le);
            }
            return;
        }
        if (s.contains(" getRequestURI =")) {
            this.outSummary(le);
            return;
        }
        if (s.contains(" getRemoteUser =")) {
            this.outSummary(le);
            return;
        }
        if (s.contains("=BwInoutSched")) {
            this.outSchedSummary(le);
            return;
        }
    }

    @Override
    public void processInfo(ReqInOutLogEntry rs) {
        if (this.waitcountCount <= 1) {
            this.outSummary(rs);
        }
    }

    @Override
    public void results() {
    }

    private void outSchedSummary(LogEntry le) {
        String s = le.logText;
        if (s.contains("set event to")) {
            this.outSummary(le);
            return;
        }
        if (s.contains("Indexing to")) {
            this.outSummary(le);
        }
        if (s.contains("Add event with name")) {
            this.outSummary(le);
        }
        if (s.contains("Received messageEntityQueuedEvent")) {
            this.outSummary(le);
            this.dumpIndented = true;
        }
    }
}

