/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.calendar;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.TreeSet;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import org.bedework.util.calendar.ScheduleMethods;
import org.bedework.util.timezones.Timezones;

public class IcalendarUtil {
    public static Calendar newIcal(int methodType, String prodId) {
        Calendar cal = new Calendar();
        PropertyList pl = cal.getProperties();
        pl.add((Property)new ProdId(prodId));
        pl.add((Property)Version.VERSION_2_0);
        if (methodType > 0 && methodType < 99) {
            pl.add((Property)new Method(ScheduleMethods.methods[methodType]));
        }
        return cal;
    }

    public static Calendar getTzCalendar(String tzid, String prodId) {
        Calendar cal = IcalendarUtil.newIcal(0, prodId);
        IcalendarUtil.addIcalTimezone(cal, tzid, null, Timezones.getTzRegistry());
        return cal;
    }

    public static void addIcalTimezone(Calendar cal, String tzid, TreeSet<String> added, TimeZoneRegistry tzreg) {
        VTimeZone vtz = null;
        if (tzid == null || added != null && added.contains(tzid)) {
            return;
        }
        TimeZone tz = tzreg.getTimeZone(tzid);
        if (tz != null) {
            vtz = tz.getVTimeZone();
        }
        if (vtz != null) {
            cal.getComponents().add((Object)vtz);
        }
        if (added != null) {
            added.add(tzid);
        }
    }

    public static String toStringTzCalendar(String tzid, String prodId) {
        Calendar ical = IcalendarUtil.getTzCalendar(tzid, prodId);
        CalendarOutputter calOut = new CalendarOutputter(true);
        StringWriter sw = new StringWriter();
        try {
            calOut.output(ical, (Writer)sw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public static String toIcalString(Calendar cal) {
        StringWriter wtr = new StringWriter();
        IcalendarUtil.writeCalendar(cal, wtr);
        return ((Object)wtr).toString();
    }

    public static void writeCalendar(Calendar cal, Writer wtr) {
        CalendarOutputter co = new CalendarOutputter(false, 74);
        try {
            co.output(cal, wtr);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

