/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.calendar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import org.bedework.util.calendar.XcalUtil;

public class JcalCalendarParser
implements CalendarParser {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private String lastComponent;
    private String lastProperty;

    public void parse(InputStream in, ContentHandler handler) throws ParserException {
        this.parse(new InputStreamReader(in, DEFAULT_CHARSET), handler);
    }

    public void parse(Reader in, ContentHandler handler) throws ParserException {
        try {
            JsonParser parser = jsonFactory.createParser(in);
            this.process(parser, handler);
        }
        catch (Throwable t) {
            throw new ParserException(t.getMessage(), 0, t);
        }
    }

    private void process(JsonParser parser, ContentHandler handler) throws ParserException {
        try {
            this.arrayStart(parser);
            String ctype = this.textField(parser);
            if (!ctype.equals("vcalendar")) {
                this.throwException("Expected vcalendar: found " + ctype, parser);
            }
            this.lastComponent = "vcalendar";
            this.processVcalendar(parser, handler);
            this.arrayEnd(parser);
        }
        catch (Throwable t) {
            this.handleException(t, parser);
        }
    }

    private void processVcalendar(JsonParser parser, ContentHandler handler) throws ParserException {
        handler.startCalendar();
        this.processProperties(parser, handler);
        this.processCalcomps(parser, handler);
    }

    private void processProperties(JsonParser parser, ContentHandler handler) throws ParserException {
        this.arrayStart(parser);
        while (!this.testArrayEnd(parser)) {
            this.processProperty(parser, handler);
        }
    }

    private void processCalcomps(JsonParser parser, ContentHandler handler) throws ParserException {
        this.arrayStart(parser);
        while (!this.testArrayEnd(parser)) {
            this.processComponent(parser, handler);
        }
    }

    private void processComponent(JsonParser parser, ContentHandler handler) throws ParserException {
        String cname;
        this.currentArrayStart(parser);
        this.lastComponent = cname = this.textField(parser).toUpperCase();
        handler.startComponent(cname);
        this.processProperties(parser, handler);
        this.processCalcomps(parser, handler);
        handler.endComponent(cname);
        this.arrayEnd(parser);
    }

    private void processProperty(JsonParser parser, ContentHandler handler) throws ParserException {
        String name;
        this.currentArrayStart(parser);
        this.lastProperty = name = this.textField(parser);
        handler.startProperty(name);
        this.processParameters(parser, handler);
        boolean parseArrayEnd = this.processValue(parser, handler, this.textField(parser));
        try {
            handler.endProperty(name);
        }
        catch (Throwable t) {
            this.handleException(t, parser);
        }
        if (parseArrayEnd) {
            this.arrayEnd(parser);
        }
    }

    private void processParameters(JsonParser parser, ContentHandler handler) throws ParserException {
        this.objectStart(parser);
        while (!this.testObjectEnd(parser)) {
            this.processParameter(parser, handler);
        }
    }

    private void processParameter(JsonParser parser, ContentHandler handler) throws ParserException {
        try {
            handler.parameter(this.currentFieldName(parser), this.textField(parser));
        }
        catch (Throwable t) {
            this.handleException(t, parser);
        }
    }

    private boolean processValue(JsonParser parser, ContentHandler handler, String type) throws ParserException {
        boolean parseArrayEnd = true;
        try {
            if (this.lastProperty.equals("geo")) {
                this.arrayStart(parser);
                StringBuilder sb = new StringBuilder();
                sb.append(this.floatField(parser));
                sb.append(",");
                sb.append(this.floatField(parser));
                this.arrayEnd(parser);
                handler.propertyValue(sb.toString());
                return true;
            }
            if (this.lastProperty.equals("request-status")) {
                this.arrayStart(parser);
                StringBuilder sb = new StringBuilder();
                sb.append(this.textField(parser));
                sb.append(",");
                sb.append(this.textField(parser));
                if (!this.testArrayEnd(parser)) {
                    sb.append(",");
                    sb.append(this.currentTextField(parser));
                    this.arrayEnd(parser);
                }
                handler.propertyValue(sb.toString());
                return true;
            }
            switch (type) {
                case "recur": {
                    StringBuilder sb = new StringBuilder();
                    String delim = "";
                    this.objectStart(parser);
                    while (!this.testObjectEnd(parser)) {
                        sb.append(delim);
                        delim = ";";
                        String recurEl = this.currentFieldName(parser);
                        sb.append(recurEl.toUpperCase());
                        sb.append("=");
                        sb.append(this.recurElVal(parser, recurEl));
                    }
                    handler.propertyValue(sb.toString());
                    break;
                }
                case "boolean": {
                    handler.propertyValue(String.valueOf(this.booleanField(parser)));
                    break;
                }
                case "utc-offset": {
                    handler.propertyValue(XcalUtil.getIcalUtcOffset(this.textField(parser)));
                    break;
                }
                case "binary": 
                case "cal-address": 
                case "duration": 
                case "text": 
                case "uri": {
                    StringBuilder sb = new StringBuilder();
                    String delim = "";
                    while (!this.testArrayEnd(parser)) {
                        sb.append(delim);
                        delim = ",";
                        sb.append(this.currentTextField(parser));
                    }
                    handler.propertyValue(sb.toString());
                    parseArrayEnd = false;
                    break;
                }
                case "integer": {
                    handler.propertyValue(String.valueOf(this.intField(parser)));
                    break;
                }
                case "float": {
                    handler.propertyValue(String.valueOf(this.intField(parser)));
                    break;
                }
                case "date": 
                case "date-time": {
                    handler.propertyValue(XcalUtil.getIcalFormatDateTime(this.textField(parser)));
                    break;
                }
                case "time": {
                    handler.propertyValue(XcalUtil.getIcalFormatTime(this.textField(parser)));
                    break;
                }
                case "period": {
                    String[] parts = this.textField(parser).split("/");
                    StringBuilder sb = new StringBuilder();
                    sb.append(XcalUtil.getIcalFormatDateTime(parts[0]));
                    if (parts[1].toUpperCase().startsWith("P")) {
                        sb.append(parts[1]);
                    } else {
                        sb.append(XcalUtil.getIcalFormatDateTime(parts[1]));
                    }
                    handler.propertyValue(sb.toString());
                    break;
                }
                default: {
                    this.throwException("Bad property", parser);
                    return false;
                }
            }
        }
        catch (IOException | URISyntaxException | ParseException e) {
            throw new ParserException(e.getMessage(), 0, (Throwable)e);
        }
        return parseArrayEnd;
    }

    private String recurElVal(JsonParser parser, String el) throws ParserException {
        if (el.equals("freq")) {
            return this.textField(parser);
        }
        if (el.equals("wkst")) {
            return this.textField(parser);
        }
        if (el.equals("until")) {
            return this.textField(parser);
        }
        if (el.equals("count")) {
            return String.valueOf(this.intField(parser));
        }
        if (el.equals("interval")) {
            return String.valueOf(this.intField(parser));
        }
        if (el.equals("bymonth")) {
            return this.intList(parser);
        }
        if (el.equals("byweekno")) {
            return this.intList(parser);
        }
        if (el.equals("byyearday")) {
            return this.intList(parser);
        }
        if (el.equals("bymonthday")) {
            return this.intList(parser);
        }
        if (el.equals("byday")) {
            return this.textList(parser);
        }
        if (el.equals("byhour")) {
            return this.intList(parser);
        }
        if (el.equals("byminute")) {
            return this.intList(parser);
        }
        if (el.equals("bysecond")) {
            return this.intList(parser);
        }
        if (el.equals("bysetpos")) {
            return this.intList(parser);
        }
        this.throwException("Unexpected recur field " + el, parser);
        return null;
    }

    private void throwException(String msg, JsonParser parser) throws ParserException {
        StringBuilder augmented = new StringBuilder(msg);
        if (this.lastComponent != null) {
            augmented.append("; last component=");
            augmented.append(this.lastComponent);
        }
        if (this.lastProperty != null) {
            augmented.append("; last property=");
            augmented.append(this.lastProperty);
        }
        this.handleException(new Throwable(augmented.toString()), parser);
    }

    private Object handleException(Throwable t, JsonParser parser) throws ParserException {
        if (t instanceof ParserException) {
            throw (ParserException)t;
        }
        try {
            int lnr = parser.getCurrentLocation().getLineNr();
            throw new ParserException(t.getLocalizedMessage(), lnr);
        }
        catch (ParserException pe) {
            throw pe;
        }
        catch (Throwable t1) {
            throw new ParserException(t.getLocalizedMessage(), -1);
        }
    }

    private void arrayStart(JsonParser parser) throws ParserException {
        this.expectToken(parser, JsonToken.START_ARRAY, "Expected array start");
    }

    private void arrayEnd(JsonParser parser) throws ParserException {
        this.expectToken(parser, JsonToken.END_ARRAY, "Expected array end");
    }

    private void currentArrayStart(JsonParser parser) throws ParserException {
        this.expectCurrentToken(parser, JsonToken.START_ARRAY, "Expected array start");
    }

    private boolean testNextArrayStart(JsonParser parser) throws ParserException {
        return this.testToken(parser, JsonToken.START_ARRAY);
    }

    private boolean testArrayEnd(JsonParser parser) throws ParserException {
        return this.testToken(parser, JsonToken.END_ARRAY);
    }

    private void objectStart(JsonParser parser) throws ParserException {
        this.expectToken(parser, JsonToken.START_OBJECT, "Expected object start");
    }

    private boolean testObjectEnd(JsonParser parser) throws ParserException {
        return this.testToken(parser, JsonToken.END_OBJECT);
    }

    private void expectToken(JsonParser parser, JsonToken expected, String message) throws ParserException {
        try {
            JsonToken t = parser.nextToken();
            if (t != expected) {
                this.throwException(message, parser);
            }
        }
        catch (ParserException pe) {
            throw pe;
        }
        catch (Throwable t) {
            this.handleException(t, parser);
        }
    }

    private void expectCurrentToken(JsonParser parser, JsonToken expected, String message) throws ParserException {
        try {
            JsonToken t = parser.getCurrentToken();
            if (t != expected) {
                this.throwException(message, parser);
            }
        }
        catch (ParserException pe) {
            throw pe;
        }
        catch (Throwable t) {
            this.handleException(t, parser);
        }
    }

    private boolean testCurrentToken(JsonParser parser, JsonToken expected) throws ParserException {
        try {
            JsonToken t = parser.getCurrentToken();
            return t == expected;
        }
        catch (Throwable t) {
            this.handleException(t, parser);
            return false;
        }
    }

    private boolean testToken(JsonParser parser, JsonToken expected) throws ParserException {
        try {
            JsonToken t = parser.nextToken();
            return t == expected;
        }
        catch (Throwable t) {
            return (Boolean)this.handleException(t, parser);
        }
    }

    private String textField(JsonParser parser) throws ParserException {
        this.expectToken(parser, JsonToken.VALUE_STRING, "Expected string field");
        try {
            return parser.getText();
        }
        catch (Throwable t) {
            return (String)this.handleException(t, parser);
        }
    }

    private String currentTextField(JsonParser parser) throws ParserException {
        try {
            return parser.getText();
        }
        catch (Throwable t) {
            return (String)this.handleException(t, parser);
        }
    }

    private int currentIntField(JsonParser parser) throws ParserException {
        try {
            return parser.getIntValue();
        }
        catch (Throwable t) {
            return (Integer)this.handleException(t, parser);
        }
    }

    private int intField(JsonParser parser) throws ParserException {
        this.expectToken(parser, JsonToken.VALUE_NUMBER_INT, "Expected integer field");
        try {
            return parser.getIntValue();
        }
        catch (Throwable t) {
            return (Integer)this.handleException(t, parser);
        }
    }

    private float floatField(JsonParser parser) throws ParserException {
        this.expectToken(parser, JsonToken.VALUE_NUMBER_FLOAT, "Expected float field");
        try {
            return parser.getFloatValue();
        }
        catch (Throwable t) {
            return ((Float)this.handleException(t, parser)).floatValue();
        }
    }

    private boolean booleanField(JsonParser parser) throws ParserException {
        try {
            if (parser.getCurrentToken() == JsonToken.VALUE_FALSE) {
                return false;
            }
            if (parser.getCurrentToken() == JsonToken.VALUE_TRUE) {
                return true;
            }
            this.throwException("expected boolean constant", parser);
            return false;
        }
        catch (Throwable t) {
            return (Boolean)this.handleException(t, parser);
        }
    }

    private String currentFieldName(JsonParser parser) throws ParserException {
        this.expectCurrentToken(parser, JsonToken.FIELD_NAME, "Expected field name");
        try {
            return parser.getText();
        }
        catch (Throwable t) {
            return (String)this.handleException(t, parser);
        }
    }

    private String textList(JsonParser parser) throws ParserException {
        if (!this.testNextArrayStart(parser)) {
            return this.currentTextField(parser);
        }
        StringBuilder sb = new StringBuilder();
        String delim = "";
        while (!this.testArrayEnd(parser)) {
            sb.append(delim);
            delim = ",";
            sb.append(this.currentTextField(parser));
        }
        return sb.toString();
    }

    private String intList(JsonParser parser) throws ParserException {
        if (!this.testNextArrayStart(parser)) {
            return String.valueOf(this.currentIntField(parser));
        }
        StringBuilder sb = new StringBuilder();
        String delim = "";
        while (!this.testArrayEnd(parser)) {
            sb.append(delim);
            delim = ",";
            sb.append(this.currentIntField(parser));
        }
        return sb.toString();
    }

    static {
        jsonFactory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

