/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.calendar;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import org.bedework.util.xml.XmlUtil;
import org.bedework.util.xml.tagdefs.XcalTags;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XcalCalendarParser
implements CalendarParser {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public void parse(InputStream in, ContentHandler handler) throws ParserException {
        this.parse(new InputStreamReader(in, DEFAULT_CHARSET), handler);
    }

    public void parse(Reader in, ContentHandler handler) throws ParserException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(in));
            this.process(doc, handler);
        }
        catch (Throwable t) {
            throw new ParserException(t.getMessage(), 0, t);
        }
    }

    private void process(Document doc, ContentHandler handler) throws ParserException {
        Element root = doc.getDocumentElement();
        if (!XmlUtil.nodeMatches((Node)root, (QName)XcalTags.icalendar)) {
            throw new ParserException("Expected " + XcalTags.icalendar + " found " + root, 0);
        }
        for (Element el : this.getChildren(root)) {
            if (!XmlUtil.nodeMatches((Node)el, (QName)XcalTags.vcalendar)) {
                throw new ParserException("Expected " + XcalTags.vcalendar + " found " + el, 0);
            }
            this.processVcalendar(el, handler);
        }
    }

    private void processVcalendar(Element el, ContentHandler handler) throws ParserException {
        handler.startCalendar();
        try {
            List els = XmlUtil.getElements((Node)el);
            Iterator elit = els.iterator();
            Element vcel = null;
            if (elit.hasNext()) {
                vcel = (Element)elit.next();
            }
            if (XmlUtil.nodeMatches(vcel, (QName)XcalTags.properties)) {
                this.processProperties(vcel, handler);
                vcel = elit.hasNext() ? (Element)elit.next() : null;
            }
            if (XmlUtil.nodeMatches((Node)vcel, (QName)XcalTags.components)) {
                this.processCalcomps(vcel, handler);
                vcel = elit.hasNext() ? (Element)elit.next() : null;
            }
            if (vcel != null) {
                throw new ParserException("Unexpected element: found " + vcel, 0);
            }
        }
        catch (RuntimeException e) {
            throw new ParserException(e.getMessage(), 0, (Throwable)e);
        }
    }

    private void processProperties(Element el, ContentHandler handler) throws ParserException {
        try {
            for (Element e : XmlUtil.getElements((Node)el)) {
                this.processProperty(e, handler);
            }
        }
        catch (RuntimeException e) {
            throw new ParserException(e.getMessage(), 0, (Throwable)e);
        }
    }

    private void processCalcomps(Element el, ContentHandler handler) throws ParserException {
        try {
            for (Element e : XmlUtil.getElements((Node)el)) {
                this.processComponent(e, handler);
            }
        }
        catch (RuntimeException e) {
            throw new ParserException(e.getMessage(), 0, (Throwable)e);
        }
    }

    private void processComponent(Element el, ContentHandler handler) throws ParserException {
        try {
            handler.startComponent(el.getLocalName().toUpperCase());
            for (Element e : XmlUtil.getElements((Node)el)) {
                if (XmlUtil.nodeMatches((Node)e, (QName)XcalTags.properties)) {
                    this.processProperties(e, handler);
                    continue;
                }
                if (XmlUtil.nodeMatches((Node)e, (QName)XcalTags.components)) {
                    for (Element ce : XmlUtil.getElements((Node)e)) {
                        this.processComponent(ce, handler);
                    }
                    continue;
                }
                throw new ParserException("Unexpected element: found " + e, 0);
            }
            handler.endComponent(el.getLocalName().toUpperCase());
        }
        catch (RuntimeException e) {
            throw new ParserException(e.getMessage(), 0, (Throwable)e);
        }
    }

    private void processProperty(Element el, ContentHandler handler) throws ParserException {
        try {
            handler.startProperty(el.getLocalName());
            for (Element e : XmlUtil.getElements((Node)el)) {
                if (XmlUtil.nodeMatches((Node)e, (QName)XcalTags.parameters)) {
                    for (Element par : XmlUtil.getElements((Node)e)) {
                        handler.parameter(par.getLocalName(), XmlUtil.getElementContent((Node)par));
                    }
                }
                if (this.processValue(e, handler)) continue;
                throw new ParserException("Bad property " + el, 0);
            }
            handler.endProperty(el.getLocalName());
        }
        catch (Throwable t) {
            throw new ParserException(t.getMessage(), 0, t);
        }
    }

    private boolean processValue(Element el, ContentHandler handler) throws ParserException {
        try {
            if (XmlUtil.nodeMatches((Node)el, (QName)XcalTags.recurVal)) {
                StringBuilder sb = new StringBuilder();
                String delim = "";
                for (Element re : XmlUtil.getElements((Node)el)) {
                    sb.append(delim);
                    delim = ";";
                    sb.append(re.getLocalName().toUpperCase());
                    sb.append("=");
                    sb.append(XmlUtil.getElementContent((Node)re));
                }
                handler.propertyValue(sb.toString());
                return true;
            }
            if (XmlUtil.nodeMatches((Node)el, (QName)XcalTags.binaryVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.booleanVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.calAddressVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.dateVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.dateTimeVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.durationVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.floatVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.integerVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.periodVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.textVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.timeVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.uriVal) || XmlUtil.nodeMatches((Node)el, (QName)XcalTags.utcOffsetVal)) {
                handler.propertyValue(XmlUtil.getElementContent((Node)el));
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw new ParserException(t.getMessage(), 0, t);
        }
    }

    boolean icalElement(Element el) {
        if (el == null) {
            return false;
        }
        String ns = el.getNamespaceURI();
        return ns != null && ns.equals("urn:ietf:params:xml:ns:icalendar-2.0");
    }

    boolean icalElement(Element el, String name) {
        if (!this.icalElement(el)) {
            return false;
        }
        String ln = el.getLocalName();
        if (ln == null) {
            return false;
        }
        return ln.equals(name);
    }

    protected Collection<Element> getChildren(Node nd) throws ParserException {
        try {
            return XmlUtil.getElements((Node)nd);
        }
        catch (Throwable t) {
            throw new ParserException(t.getMessage(), 0);
        }
    }

    protected Element[] getChildrenArray(Node nd) throws ParserException {
        try {
            return XmlUtil.getElementsArray((Node)nd);
        }
        catch (Throwable t) {
            throw new ParserException(t.getMessage(), 0);
        }
    }

    protected Element getOnlyChild(Node nd) throws ParserException {
        try {
            return XmlUtil.getOnlyElement((Node)nd);
        }
        catch (Throwable t) {
            throw new ParserException(t.getMessage(), 0);
        }
    }

    protected String getElementContent(Element el) throws ParserException {
        try {
            return XmlUtil.getElementContent((Node)el);
        }
        catch (Throwable t) {
            throw new ParserException(t.getMessage(), 0);
        }
    }

    protected boolean isEmpty(Element el) throws ParserException {
        try {
            return XmlUtil.isEmpty((Element)el);
        }
        catch (Throwable t) {
            throw new ParserException(t.getMessage(), 0);
        }
    }
}

