/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.calendar;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Consumer;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.DefaultContentHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import org.bedework.util.calendar.XcalCalendarParser;

public class XmlCalendarBuilder
implements Consumer<Calendar> {
    private final CalendarParser parser = new XcalCalendarParser();
    private final ContentHandler contentHandler;
    private final TimeZoneRegistry tzRegistry;
    private Calendar calendar;

    public XmlCalendarBuilder() {
        this(TimeZoneRegistryFactory.getInstance().createRegistry());
    }

    public XmlCalendarBuilder(TimeZoneRegistry tzRegistry) {
        this.tzRegistry = tzRegistry;
        this.contentHandler = new DefaultContentHandler((Consumer)this, tzRegistry);
    }

    @Override
    public void accept(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar build(InputStream in) throws IOException, ParserException {
        this.parser.parse(in, this.contentHandler);
        return this.calendar;
    }

    public Calendar build(Reader in) throws IOException, ParserException {
        this.parser.parse(in, this.contentHandler);
        return this.calendar;
    }

    public final TimeZoneRegistry getRegistry() {
        return this.tzRegistry;
    }
}

