/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.http;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicStatusLine;
import org.bedework.util.http.Headers;
import org.bedework.util.http.HttpMkcalendar;
import org.bedework.util.http.HttpMkcol;
import org.bedework.util.http.HttpPropPatch;
import org.bedework.util.http.HttpPropfind;
import org.bedework.util.http.HttpReport;

public class HttpUtil
implements Serializable {
    private HttpUtil() {
    }

    public static CloseableHttpClient getClient(boolean disableRedirects) {
        HttpClientBuilder bldr = HttpClientBuilder.create();
        if (disableRedirects) {
            bldr.disableRedirectHandling();
        }
        return bldr.build();
    }

    public static CloseableHttpResponse doDelete(CloseableHttpClient cl, URI uri, HeadersFetcher hdrs, String acceptContentType) throws IOException {
        Headers headers = HttpUtil.ensureHeaders(hdrs);
        if (acceptContentType != null) {
            headers.add("Accept", acceptContentType);
        }
        HttpDelete method = new HttpDelete(uri);
        method.setHeaders(headers.asArray());
        return cl.execute((HttpUriRequest)method);
    }

    public static CloseableHttpResponse doGet(CloseableHttpClient cl, URI uri, HeadersFetcher hdrs, String acceptContentType) throws IOException {
        Headers headers = HttpUtil.ensureHeaders(hdrs);
        if (acceptContentType != null) {
            headers.add("Accept", acceptContentType);
        }
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeaders(headers.asArray());
        return cl.execute((HttpUriRequest)httpGet);
    }

    public static CloseableHttpResponse doHead(CloseableHttpClient cl, URI uri, HeadersFetcher hdrs, String acceptContentType) throws IOException {
        Headers headers = HttpUtil.ensureHeaders(hdrs);
        if (acceptContentType != null) {
            headers.add("Accept", acceptContentType);
        }
        HttpHead httphead = new HttpHead(uri);
        httphead.setHeaders(headers.asArray());
        return cl.execute((HttpUriRequest)httphead);
    }

    public static CloseableHttpResponse doPost(CloseableHttpClient cl, URI uri, HeadersFetcher hdrs, String contentType, String content) throws IOException {
        StringEntity entity = content != null ? new StringEntity(content) : null;
        return HttpUtil.doPost(cl, uri, hdrs, (HttpEntity)entity);
    }

    public static CloseableHttpResponse doPost(CloseableHttpClient cl, URI uri, HeadersFetcher hdrs, HttpEntity entity) throws IOException {
        Headers headers = HttpUtil.ensureHeaders(hdrs);
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeaders(headers.asArray());
        if (entity != null) {
            httpPost.setEntity(entity);
        }
        return cl.execute((HttpUriRequest)httpPost);
    }

    public static CloseableHttpResponse doPut(CloseableHttpClient cl, URI uri, HeadersFetcher hdrs, String contentType, String content) throws IOException {
        Headers headers = HttpUtil.ensureHeaders(hdrs);
        if (contentType != null) {
            headers.add("Content-type", contentType);
        }
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeaders(headers.asArray());
        if (content != null) {
            StringEntity entity = new StringEntity(content);
            httpPut.setEntity((HttpEntity)entity);
        }
        return cl.execute((HttpUriRequest)httpPut);
    }

    public static CloseableHttpResponse doReport(CloseableHttpClient cl, URI uri, HeadersFetcher hdrs, String depth, String contentType, String content) throws IOException {
        Headers headers = HttpUtil.ensureHeaders(hdrs);
        if (depth != null) {
            headers.add("depth", depth);
        }
        if (contentType != null) {
            headers.add("Content-type", contentType);
        }
        HttpReport httpReport = new HttpReport(uri);
        httpReport.setHeaders(headers.asArray());
        if (content != null) {
            StringEntity entity = new StringEntity(content);
            httpReport.setEntity((HttpEntity)entity);
        }
        return cl.execute((HttpUriRequest)httpReport);
    }

    public static CloseableHttpResponse doPropfind(CloseableHttpClient cl, URI uri, HeadersFetcher hdrs, String depth, String contentType, String content) throws IOException {
        Headers headers = HttpUtil.ensureHeaders(hdrs);
        if (depth != null) {
            headers.add("depth", depth);
        }
        if (contentType != null) {
            headers.add("Content-type", contentType);
        }
        HttpPropfind httpPropfind = new HttpPropfind(uri);
        httpPropfind.setHeaders(headers.asArray());
        if (content != null) {
            StringEntity entity = new StringEntity(content);
            httpPropfind.setEntity((HttpEntity)entity);
        }
        return cl.execute((HttpUriRequest)httpPropfind);
    }

    private static Headers ensureHeaders(HeadersFetcher hdrs) {
        if (hdrs == null) {
            return new Headers();
        }
        Headers headers = hdrs.get();
        if (headers == null) {
            return new Headers();
        }
        Headers nheaders = new Headers();
        nheaders.addAll(headers);
        return nheaders;
    }

    public static String getFirstHeaderValue(HttpResponse resp, String name) {
        Header h = resp.getFirstHeader(name);
        if (h == null) {
            return null;
        }
        return h.getValue();
    }

    public static HttpRequestBase findMethod(String name, URI uri) {
        String nm = name.toUpperCase();
        if ("PUT".equals(nm)) {
            return new HttpPut(uri);
        }
        if ("GET".equals(nm)) {
            return new HttpGet(uri);
        }
        if ("DELETE".equals(nm)) {
            return new HttpDelete(uri);
        }
        if ("POST".equals(nm)) {
            return new HttpPost(uri);
        }
        if ("PROPFIND".equals(nm)) {
            return new HttpPropfind(uri);
        }
        if ("PROPPATCH".equals(nm)) {
            return new HttpPropPatch(uri);
        }
        if ("MKCALENDAR".equals(nm)) {
            return new HttpMkcalendar(uri);
        }
        if ("MKCOL".equals(nm)) {
            return new HttpMkcol(uri);
        }
        if ("OPTIONS".equals(nm)) {
            return new HttpOptions(uri);
        }
        if ("REPORT".equals(nm)) {
            return new HttpReport(uri);
        }
        if ("HEAD".equals(nm)) {
            return new HttpHead(uri);
        }
        return null;
    }

    public static void setContent(HttpRequestBase req, byte[] content, String contentType) throws HttpException {
        if (content == null) {
            return;
        }
        if (!(req instanceof HttpEntityEnclosingRequestBase)) {
            throw new HttpException("Invalid operation for method " + req.getMethod());
        }
        HttpEntityEnclosingRequestBase eem = (HttpEntityEnclosingRequestBase)req;
        ByteArrayEntity entity = new ByteArrayEntity(content);
        entity.setContentType(contentType);
        eem.setEntity((HttpEntity)entity);
    }

    public static int getStatus(HttpResponse resp) {
        return resp.getStatusLine().getStatusCode();
    }

    public static StatusLine getHttpStatus(String statusLine) throws HttpException {
        String[] splits = statusLine.split("\\s+");
        if (splits.length < 2 || !splits[0].startsWith("HTTP/")) {
            throw new HttpException("Bad status line: " + statusLine);
        }
        String[] version = splits[0].substring(5).split(".");
        if (version.length != 2) {
            throw new HttpException("Bad status line: " + statusLine);
        }
        HttpVersion hv = new HttpVersion(Integer.valueOf(version[0]).intValue(), Integer.valueOf(version[1]).intValue());
        int status = Integer.valueOf(splits[1]);
        String reason = splits.length < 3 ? null : splits[2];
        return new BasicStatusLine((ProtocolVersion)hv, status, reason);
    }

    public static String makeHttpStatus(int status, String reason) {
        return "HTTP/1.1 " + status + reason;
    }

    public static String makeOKHttpStatus() {
        return HttpUtil.makeHttpStatus(200, "OK");
    }

    public static String getUrl(HttpServletRequest request) {
        try {
            StringBuffer sb = request.getRequestURL();
            if (sb != null) {
                return sb.toString();
            }
            return request.getRequestURI();
        }
        catch (Throwable t) {
            return "BogusURL.this.is.probably.a.portal";
        }
    }

    public static interface HeadersFetcher {
        public Headers get();
    }
}

