/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.bedework.util.http.Headers;
import org.bedework.util.http.HttpUtil;
import org.bedework.util.misc.Util;

public class PooledHttpClient {
    private static final PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
    private static final IdleConnectionMonitorThread idleConnectionMonitor;
    private final CloseableHttpClient http;
    private final ObjectMapper om;
    private final URI baseUri;
    private HttpUtil.HeadersFetcher headersFetcher;

    public PooledHttpClient(URI uri) {
        this(uri, null);
    }

    public PooledHttpClient(URI uri, ObjectMapper om) {
        this.om = om;
        this.baseUri = uri;
        this.http = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setConnectionManagerShared(true).build();
    }

    public PooledHttpClient(URI uri, ObjectMapper om, CredentialsProvider credsProvider) {
        this.om = om;
        this.baseUri = uri;
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setConnectionManagerShared(true);
        if (credsProvider != null) {
            builder.setDefaultCredentialsProvider(credsProvider);
        }
        this.http = builder.build();
    }

    public void setHeadersFetcher(HttpUtil.HeadersFetcher headersFetcher) {
        this.headersFetcher = headersFetcher;
    }

    public static PoolStats getConnStats() {
        return connManager.getTotalStats();
    }

    public static void setDefaultMaxPerRoute(int val) {
        connManager.setDefaultMaxPerRoute(val);
    }

    public static int getDefaultMaxPerRoute() {
        return connManager.getDefaultMaxPerRoute();
    }

    public static void setMaxConnections(int val) {
        connManager.setMaxTotal(val);
    }

    public static int getMaxConnections() {
        return connManager.getMaxTotal();
    }

    public static void setHostLimit(String host, int port, int max) {
        HttpHost hostPort = new HttpHost(host, port);
        connManager.setMaxPerRoute(new HttpRoute(hostPort), max);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getJson(String request, TypeReference<T> valueTypeRef) throws HttpException {
        try (CloseableHttpResponse hresp = HttpUtil.doGet(this.http, this.resolve(request), this.headersFetcher, "application/json");){
            InputStream is = hresp.getEntity().getContent();
            if (is == null) {
                T t = null;
                return t;
            }
            Object object = this.om.readValue(is, valueTypeRef);
            return (T)object;
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getJson(String request, Class<T> valueType) throws HttpException {
        try (CloseableHttpResponse hresp = HttpUtil.doGet(this.http, this.resolve(request), this.headersFetcher, "application/json");){
            InputStream is = hresp.getEntity().getContent();
            if (is == null) {
                T t = null;
                return t;
            }
            Object object = this.om.readValue(is, valueType);
            return (T)object;
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getLong(String request) throws HttpException {
        try (CloseableHttpResponse hresp = HttpUtil.doGet(this.http, this.resolve(request), this.headersFetcher, "text/text");){
            int len;
            InputStream is = hresp.getEntity().getContent();
            if (is == null) {
                Long l = null;
                return l;
            }
            int bufSize = 2048;
            byte[] buf = new byte[2048];
            int pos = 0;
            do {
                if ((len = is.read(buf, pos, 2048 - pos)) != -1) continue;
                Long l = Long.valueOf(new String(buf, 0, pos));
                return l;
            } while ((pos += len) < 2048);
            Long l = null;
            return l;
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getBinary(String request, OutputStream out) throws HttpException {
        try (CloseableHttpResponse hresp = HttpUtil.doGet(this.http, this.resolve(request), this.headersFetcher, "application/binary");){
            InputStream is = hresp.getEntity().getContent();
            if (is == null) {
                boolean bl2 = false;
                return bl2;
            }
            int bufSize = 2048;
            byte[] buf = new byte[2048];
            while (true) {
                int len;
                if ((len = is.read(buf, 0, 2048)) == -1) {
                    boolean bl = true;
                    return bl;
                }
                out.write(buf, 0, len);
            }
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(String request, String acceptContentType) throws HttpException {
        try (CloseableHttpResponse hresp = HttpUtil.doGet(this.http, this.resolve(request), this.headersFetcher, acceptContentType);){
            InputStream is = hresp.getEntity().getContent();
            if (is == null) {
                String string2 = null;
                return string2;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bufSize = 2048;
            byte[] buf = new byte[2048];
            while (true) {
                int len;
                if ((len = is.read(buf, 0, 2048)) == -1) {
                    String string = baos.toString(StandardCharsets.UTF_8);
                    return string;
                }
                baos.write(buf, 0, len);
            }
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseHolder get(String request, String acceptContentType, ProcessResponse responseProcessor) throws HttpException {
        try (CloseableHttpResponse hresp = HttpUtil.doGet(this.http, this.resolve(request), this.headersFetcher, acceptContentType);){
            int status = HttpUtil.getStatus((HttpResponse)hresp);
            if (status != 200) {
                ResponseHolder responseHolder = new ResponseHolder(status, "Failed response from server");
                return responseHolder;
            }
            if (responseProcessor == null) {
                ResponseHolder responseHolder = new ResponseHolder(null);
                return responseHolder;
            }
            ResponseHolder responseHolder = responseProcessor.process(request, hresp);
            return responseHolder;
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> ResponseHolder<T> postJson(String path, String content, Class<T> resultType) throws HttpException {
        try (CloseableHttpResponse hresp = HttpUtil.doPost(this.http, this.resolve(path), this.headersFetcher, "application/json", content);){
            int status = HttpUtil.getStatus((HttpResponse)hresp);
            if (status != 200) {
                ResponseHolder responseHolder = new ResponseHolder(status, "Failed response from server");
                return responseHolder;
            }
            InputStream is = hresp.getEntity().getContent();
            if (is == null) {
                ResponseHolder responseHolder = new ResponseHolder(status, "No content");
                return responseHolder;
            }
            ResponseHolder<Object> responseHolder = new ResponseHolder<Object>(this.om.readValue(is, resultType));
            return responseHolder;
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseHolder postXml(String path, String xml) throws HttpException {
        try (CloseableHttpResponse hresp = HttpUtil.doPost(this.http, this.resolve(path), this.headersFetcher, "application/xml", xml);){
            int status = HttpUtil.getStatus((HttpResponse)hresp);
            if (status != 200) {
                ResponseHolder responseHolder2 = new ResponseHolder(status, "Failed response from server");
                return responseHolder2;
            }
            ResponseHolder responseHolder = new ResponseHolder(null);
            return responseHolder;
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseHolder post(String path, HttpEntity entity, ProcessResponse responseProcessor) throws HttpException {
        try (CloseableHttpResponse hresp = HttpUtil.doPost(this.http, this.resolve(path), this.headersFetcher, entity);){
            if (responseProcessor == null) {
                ResponseHolder responseHolder2 = new ResponseHolder(null);
                return responseHolder2;
            }
            ResponseHolder responseHolder = responseProcessor.process(path, hresp);
            return responseHolder;
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    public <T> ResponseHolder<T> postJson(String path, Object content, Class<T> resultType) throws HttpException {
        String scontent;
        if (content == null) {
            scontent = null;
        } else {
            StringWriter sw = new StringWriter();
            try {
                this.om.writeValue((Writer)sw, content);
            }
            catch (Throwable t) {
                throw new HttpException(t.getMessage(), t);
            }
            scontent = sw.toString();
        }
        return this.postJson(path, scontent, resultType);
    }

    public int postJson(String path, String content) throws HttpException {
        int n;
        block8: {
            CloseableHttpResponse hresp = HttpUtil.doPost(this.http, this.resolve(path), this.headersFetcher, "application/json", content);
            try {
                n = HttpUtil.getStatus((HttpResponse)hresp);
                if (hresp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hresp != null) {
                        try {
                            hresp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new HttpException(t.getMessage(), t);
                }
            }
            hresp.close();
        }
        return n;
    }

    public int put(String path, String content, String contentType) throws HttpException {
        int n;
        block8: {
            CloseableHttpResponse hresp = HttpUtil.doPut(this.http, this.resolve(path), this.headersFetcher, contentType, content);
            try {
                n = HttpUtil.getStatus((HttpResponse)hresp);
                if (hresp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hresp != null) {
                        try {
                            hresp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new HttpException(t.getMessage(), t);
                }
            }
            hresp.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> ResponseHolder<T> postForm(String path, List<NameValuePair> nvps, Class<T> resultType) throws HttpException {
        String scontent;
        try {
            String delim = "";
            if (!Util.isEmpty(nvps)) {
                StringBuilder content = new StringBuilder();
                for (NameValuePair nvp : nvps) {
                    content.append(delim);
                    delim = "&";
                    content.append(nvp.getName());
                    content.append("=");
                    content.append(this.encode(nvp.getValue()));
                }
                scontent = content.toString();
            } else {
                scontent = null;
            }
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
        try (CloseableHttpResponse hresp = HttpUtil.doPost(this.http, this.resolve(path), this.headersFetcher, "application/x-www-form-urlencoded", scontent);){
            ResponseHolder<Object> responseHolder;
            int status = HttpUtil.getStatus((HttpResponse)hresp);
            if (status != 200) {
                ResponseHolder responseHolder2 = new ResponseHolder(status, "Failed response from server");
                return responseHolder2;
            }
            InputStream is = hresp.getEntity().getContent();
            if (is == null) {
                responseHolder = new ResponseHolder(status, "No content");
                return responseHolder;
            }
            responseHolder = new ResponseHolder<Object>(this.om.readValue(is, resultType));
            return responseHolder;
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    public ResponseHolder report(String path, String depth, String content, ProcessResponse responseProcessor) throws HttpException {
        ResponseHolder responseHolder;
        block8: {
            CloseableHttpResponse hresp = HttpUtil.doReport(this.http, this.resolve(path), this.headersFetcher, depth, "text/xml", content);
            try {
                responseHolder = responseProcessor.process(path, hresp);
                if (hresp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hresp != null) {
                        try {
                            hresp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new HttpException(t.getMessage(), t);
                }
            }
            hresp.close();
        }
        return responseHolder;
    }

    public ResponseHolder propfind(String path, String depth, String content, ProcessResponse responseProcessor) throws HttpException {
        ResponseHolder responseHolder;
        block8: {
            CloseableHttpResponse hresp = HttpUtil.doPropfind(this.http, this.resolve(path), this.headersFetcher, depth, "text/xml", content);
            try {
                responseHolder = responseProcessor.process(path, hresp);
                if (hresp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hresp != null) {
                        try {
                            hresp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new HttpException(t.getMessage(), t);
                }
            }
            hresp.close();
        }
        return responseHolder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseHolder delete(String path) throws HttpException {
        if (path == null) {
            return null;
        }
        try (CloseableHttpResponse hresp = HttpUtil.doDelete(this.http, this.resolve(path), this.headersFetcher, "application/json");){
            int status = HttpUtil.getStatus((HttpResponse)hresp);
            if (status != 200) {
                ResponseHolder responseHolder2 = new ResponseHolder(status, "Failed response from server");
                return responseHolder2;
            }
            ResponseHolder responseHolder = new ResponseHolder(null);
            return responseHolder;
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    public void release() {
        try {
            this.http.close();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    private String encode(String val) throws HttpException {
        try {
            return URLEncoder.encode(val, StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            throw new HttpException(t.getMessage(), t);
        }
    }

    private URI resolve(String request) {
        return URIUtils.resolve((URI)this.baseUri, (String)request);
    }

    private static Headers ensureHeaders(Headers hdrs) {
        if (hdrs == null) {
            return new Headers();
        }
        return hdrs;
    }

    static {
        connManager.setMaxTotal(200);
        connManager.setDefaultMaxPerRoute(20);
        HttpHost localhost = new HttpHost("localhost", 80);
        connManager.setMaxPerRoute(new HttpRoute(localhost), 50);
        HttpHost localhost8080 = new HttpHost("localhost", 8080);
        connManager.setMaxPerRoute(new HttpRoute(localhost8080), 50);
        idleConnectionMonitor = new IdleConnectionMonitorThread(connManager);
        idleConnectionMonitor.start();
    }

    public static class ResponseHolder<T> {
        public boolean failed;
        public int status;
        public String message;
        public Throwable exception;
        public T response;

        public ResponseHolder(int status, String message) {
            this.status = status;
            this.message = message;
            this.failed = true;
        }

        public ResponseHolder(T response) {
            this.response = response;
            this.failed = false;
        }

        public ResponseHolder(Throwable exception) {
            this.exception = exception;
            this.failed = true;
        }
    }

    public static interface ProcessResponse<T> {
        public ResponseHolder<T> process(String var1, CloseableHttpResponse var2);
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final PoolingHttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(PoolingHttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

