/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.http.service;

import org.apache.http.pool.PoolStats;
import org.bedework.util.http.PooledHttpClient;
import org.bedework.util.http.service.HttpConfigImpl;
import org.bedework.util.http.service.HttpOutMBean;
import org.bedework.util.jmx.ConfBase;
import org.bedework.util.logging.BwLogger;

public class HttpOut
extends ConfBase<HttpConfigImpl>
implements HttpOutMBean {
    private BwLogger logger = new BwLogger();

    public HttpOut(String confuriPname, String domain, String serviceName) {
        this.setConfigName(serviceName);
        this.setConfigPname(confuriPname);
        this.setServiceName(domain + ":service=" + serviceName);
    }

    @Override
    public void setMaxConnections(int val) {
        ((HttpConfigImpl)this.getConfig()).setMaxConnections(val);
        PooledHttpClient.setMaxConnections(val);
    }

    @Override
    public int getMaxConnections() {
        return PooledHttpClient.getMaxConnections();
    }

    @Override
    public void setDefaultMaxPerRoute(int val) {
        ((HttpConfigImpl)this.getConfig()).setDefaultMaxPerRoute(val);
        PooledHttpClient.setDefaultMaxPerRoute(val);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return PooledHttpClient.getDefaultMaxPerRoute();
    }

    @Override
    public void disableSSL() {
    }

    @Override
    public PoolStats getConnStats() {
        return PooledHttpClient.getConnStats();
    }

    @Override
    public String loadConfig() {
        String res = this.loadConfig(HttpConfigImpl.class);
        this.refresh();
        return res;
    }

    private void refresh() {
        PooledHttpClient.setMaxConnections(((HttpConfigImpl)this.getConfig()).getMaxConnections());
        PooledHttpClient.setDefaultMaxPerRoute(((HttpConfigImpl)this.getConfig()).getDefaultMaxPerRoute());
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

