/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.bedework.util.xml.XmlEmitNamespaces;

public class XmlEmit {
    private Writer wtr;
    private boolean forHtml = false;
    private final boolean noHeaders;
    private String dtd;
    private boolean started;
    private final XmlEmitNamespaces nameSpaces = new XmlEmitNamespaces();
    private Notifier notifier;
    private Properties props;
    int indent;
    private final String blank = "                                                                              ";
    private final int blankLen = "                                                                              ".length();
    private static final int bufferSize = 4096;

    public XmlEmit() {
        this(false);
    }

    public XmlEmit(boolean noHeaders) {
        this.noHeaders = noHeaders;
    }

    public static XmlEmit getHtmlEmitter() {
        XmlEmit xml = new XmlEmit();
        xml.forHtml = true;
        return xml;
    }

    public void setProperty(String name, String val) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty(name, val);
    }

    public String getProperty(String name) {
        if (this.props == null) {
            return null;
        }
        return this.props.getProperty(name);
    }

    public void startEmit(Writer wtr) {
        this.wtr = wtr;
    }

    public void startEmit(Writer wtr, String dtd) {
        this.wtr = wtr;
        this.dtd = dtd;
    }

    public void setNotifier(Notifier n) {
        this.notifier = n;
    }

    public void openTag(QName tag) {
        this.blanks();
        this.openTagSameLine(tag);
        this.newline();
        this.indent += 2;
    }

    public void openTag(QName tag, String attrName, String attrVal) {
        this.blanks();
        this.openTagSameLine(tag, attrName, attrVal);
        this.newline();
        this.indent += 2;
    }

    public void openTagNoNewline(QName tag) {
        this.blanks();
        this.openTagSameLine(tag);
        this.indent += 2;
    }

    public void openTagNoNewline(QName tag, String attrName, String attrVal) {
        this.blanks();
        this.openTagSameLine(tag, attrName, attrVal);
        this.indent += 2;
    }

    public void openTagSameLine(QName tag) {
        this.lb();
        this.emitQName(tag);
        this.endOpeningTag();
    }

    public void openTagSameLine(QName tag, String attrName, String attrVal) {
        this.lb();
        this.emitQName(tag);
        this.attribute(attrName, attrVal);
        this.endOpeningTag();
    }

    public void startTag(QName tag) {
        this.blanks();
        this.startTagSameLine(tag);
    }

    public void startTagIndent(QName tag) {
        this.blanks();
        this.startTagSameLine(tag);
        this.indent += 2;
    }

    public void startTagSameLine(QName tag) {
        this.lb();
        this.emitQName(tag);
    }

    public void endOpeningTag() {
        this.scopeIn();
        this.rb();
    }

    public void attribute(String attrName, String attrVal) {
        this.out(" ");
        this.out(attrName);
        this.out("=");
        this.quote(attrVal);
    }

    public void attribute(QName attr, String attrVal) {
        this.out(" ");
        this.emitQName(attr);
        this.out("=");
        this.quote(attrVal);
        this.emitNs();
    }

    public void closeTag(QName tag) {
        this.indent -= 2;
        if (this.indent < 0) {
            this.indent = 0;
        }
        this.blanks();
        this.closeTagSameLine(tag);
        this.newline();
    }

    public void closeTagNoblanks(QName tag) {
        this.indent -= 2;
        if (this.indent < 0) {
            this.indent = 0;
        }
        this.closeTagSameLine(tag);
        this.newline();
    }

    public void closeTagSameLine(QName tag) {
        this.lb();
        this.out("/");
        this.emitQName(tag);
        this.rb();
        this.scopeOut();
    }

    public void endEmptyTag() {
        this.out(" /");
        this.rb();
    }

    public void emptyTag(QName tag) {
        this.blanks();
        this.emptyTagSameLine(tag);
        this.newline();
    }

    public void emptyTag(QName tag, String attrName, String attrVal) {
        this.blanks();
        this.lb();
        this.emitQName(tag);
        this.attribute(attrName, attrVal);
        this.out("/");
        this.rb();
        this.newline();
    }

    public void emptyTagSameLine(QName tag) {
        this.lb();
        this.emitQName(tag);
        this.out("/");
        this.rb();
    }

    public void property(QName tag, String val) {
        this.blanks();
        this.openTagSameLine(tag);
        this.value(val);
        this.closeTagSameLine(tag);
        this.newline();
    }

    public void cdataProperty(QName tag, String val) {
        this.blanks();
        this.openTagSameLine(tag);
        this.cdataValue(val);
        this.closeTagSameLine(tag);
        this.newline();
    }

    public void property(QName tag, Reader val) {
        this.blanks();
        this.openTagSameLine(tag);
        this.writeContent(val, this.wtr);
        this.closeTagSameLine(tag);
        this.newline();
    }

    public void propertyTagVal(QName tag, QName tagVal) {
        this.blanks();
        this.openTagSameLine(tag);
        this.emptyTagSameLine(tagVal);
        this.closeTagSameLine(tag);
        this.newline();
    }

    public void cdataValue(String val) {
        if (val == null) {
            return;
        }
        int start = 0;
        while (start < val.length()) {
            int end = val.indexOf("]]", start);
            boolean lastSeg = end < 0;
            String seg = lastSeg ? val.substring(start) : val.substring(start, end);
            this.out("<![CDATA[");
            this.out(seg);
            this.out("]]>");
            if (lastSeg) break;
            this.out("]]");
            start = end + 2;
        }
    }

    public void value(String val) {
        this.value(val, null);
    }

    private void value(String val, String quoteChar) {
        if (val == null) {
            return;
        }
        String q = quoteChar;
        if (q == null) {
            q = "";
        }
        if (val.indexOf(38) >= 0 || val.indexOf(60) >= 0) {
            this.out("<![CDATA[");
            this.out(q);
            this.out(val);
            this.out(q);
            this.out("]]>");
        } else {
            this.out(q);
            this.out(val);
            this.out(q);
        }
    }

    public Writer getWriter() {
        return this.wtr;
    }

    public void flush() {
        try {
            this.wtr.flush();
        }
        catch (IOException ie) {
            throw new XmlUtilException(ie);
        }
    }

    public void addNs(NameSpace val, boolean makeDefaultNs) {
        this.nameSpaces.addNs(val, makeDefaultNs);
    }

    public NameSpace getNameSpace(String ns) {
        return this.nameSpaces.getNameSpace(ns);
    }

    public String getNsAbbrev(String ns) {
        return this.nameSpaces.getNsAbbrev(ns);
    }

    public void newline() {
        this.out("\n");
    }

    private void quote(String val) {
        if (!val.contains("\"")) {
            this.value(val, "\"");
        } else {
            this.value(val, "'");
        }
    }

    private void emitQName(QName tag) {
        this.nameSpaces.emitNsAbbr(tag.getNamespaceURI(), this.wtr);
        this.out(tag.getLocalPart());
        this.emitNs();
    }

    private void emitNs() {
        if (this.forHtml) {
            return;
        }
        this.nameSpaces.emitNs(this.wtr);
    }

    private void blanks() {
        if (this.indent >= this.blankLen) {
            this.out("                                                                              ");
        } else {
            this.out("                                                                              ".substring(0, this.indent));
        }
    }

    private void lb() {
        this.out("<");
    }

    private void rb() {
        this.out(">");
    }

    private void writeContent(Reader in, Writer out) {
        try (Reader reader = in;
             Writer writer = out;){
            int len;
            char[] buff = new char[4096];
            while ((len = in.read(buff)) >= 0) {
                out.write(buff, 0, len);
            }
        }
        catch (IOException ie) {
            throw new XmlUtilException(ie);
        }
    }

    private void scopeIn() {
        this.nameSpaces.startScope();
    }

    private void scopeOut() {
        this.nameSpaces.endScope();
    }

    private void out(String val) {
        if (this.notifier != null && this.notifier.isEnabled()) {
            this.notifier.doNotification();
        }
        try {
            if (!this.started) {
                this.started = true;
                if (!this.noHeaders) {
                    this.writeHeader(this.dtd);
                    this.wtr.write("\n");
                }
            }
            this.wtr.write(val);
        }
        catch (IOException ie) {
            throw new XmlUtilException(ie);
        }
    }

    private void writeHeader(String dtd) {
        try {
            if (this.forHtml) {
                this.wtr.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
                return;
            }
            this.wtr.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            if (dtd == null) {
                return;
            }
            this.wtr.write("<!DOCTYPE properties SYSTEM \"");
            this.wtr.write(dtd);
            this.wtr.write("\">\n");
        }
        catch (IOException ie) {
            throw new XmlUtilException(ie);
        }
    }

    public static class NameSpace {
        String ns;
        String abbrev;
        int level;
        boolean defaultNs;

        public NameSpace(String ns, String abbrev) {
            this.ns = ns;
            this.abbrev = abbrev;
        }

        public int hashCode() {
            return this.ns.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof NameSpace)) {
                return false;
            }
            NameSpace that = (NameSpace)o;
            return this.ns.equals(that.ns);
        }
    }

    public static abstract class Notifier {
        public abstract void doNotification();

        public abstract boolean isEnabled();
    }

    public static class XmlUtilException
    extends RuntimeException {
        public XmlUtilException(Throwable t) {
            super(t);
        }

        public XmlUtilException(String msg) {
            super(msg);
        }
    }
}

