/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.xml.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.diff.NodeWrapper;
import org.w3c.dom.Node;

public class NodeDiff {
    public static List<DiffNode> diff(Node left, Node right) {
        return NodeDiff.diff(new ArrayList<Node>(0), left, right);
    }

    public static List<DiffNode> diff(List<Node> pathTo, Node left, Node right) {
        if (left == null) {
            if (right != null) {
                return Collections.singletonList(new DiffNode(pathTo, null, new NodeWrapper(right)));
            }
            return Collections.emptyList();
        }
        if (right == null) {
            return Collections.singletonList(new DiffNode(pathTo, new NodeWrapper(left), null));
        }
        return NodeDiff.diff(Collections.emptyList(), new NodeWrapper(left), new NodeWrapper(right));
    }

    public static List<DiffNode> diff(List<Node> pathTo, NodeWrapper leftNw, NodeWrapper rightNw) {
        ArrayList<DiffNode> result = new ArrayList<DiffNode>();
        if (leftNw.compareTo(rightNw) == 0) {
            return result;
        }
        if (leftNw.shallowCompare(rightNw) != 0) {
            result.add(new DiffNode(pathTo, leftNw, rightNw));
            return result;
        }
        ArrayList<Node> npathTo = new ArrayList<Node>(pathTo);
        npathTo.add(leftNw.getNode());
        List<NodeWrapper> leftChildren = leftNw.getChildWrappers();
        List<NodeWrapper> rightChildren = rightNw.getChildWrappers();
        if (Util.isEmpty(leftChildren)) {
            if (!Util.isEmpty(rightChildren)) {
                for (NodeWrapper nw : rightChildren) {
                    result.add(new DiffNode(npathTo, null, nw));
                }
            }
            return result;
        }
        if (Util.isEmpty(rightChildren)) {
            for (NodeWrapper nw : leftChildren) {
                result.add(new DiffNode(npathTo, nw, null));
            }
            return result;
        }
        int lefti = 0;
        int righti = 0;
        block2: do {
            int cmp;
            NodeWrapper testnw;
            int testi;
            NodeWrapper rnw;
            NodeWrapper lnw;
            if ((lnw = leftChildren.get(lefti)).equals(rnw = rightChildren.get(righti))) {
                ++lefti;
                ++righti;
                continue;
            }
            ArrayList<DiffNode> skipped = new ArrayList<DiffNode>();
            for (testi = righti + 1; testi < rightChildren.size(); ++testi) {
                testnw = rightChildren.get(testi);
                cmp = lnw.compareTo(testnw);
                if (cmp == 0) {
                    result.addAll(skipped);
                    righti = testi;
                    continue block2;
                }
                if (cmp > 0) break;
                skipped.addAll(NodeDiff.diff(npathTo, lnw, testnw));
            }
            skipped.clear();
            for (testi = lefti + 1; testi < leftChildren.size(); ++testi) {
                testnw = leftChildren.get(testi);
                cmp = rnw.compareTo(testnw);
                if (cmp == 0) {
                    result.addAll(skipped);
                    lefti = testi;
                    continue block2;
                }
                if (cmp > 0) break;
                skipped.addAll(NodeDiff.diff(npathTo, testnw, rnw));
            }
            if (lnw.shallowCompare(rnw) != 0) {
                result.add(new DiffNode(npathTo, lnw, rnw));
            } else {
                skipped.addAll(NodeDiff.diff(npathTo, lnw, rnw));
            }
            ++lefti;
            ++righti;
        } while (lefti < leftChildren.size() && righti < rightChildren.size());
        return result;
    }

    public static class DiffNode {
        final List<Node> pathTo;
        final NodeWrapper left;
        final NodeWrapper right;

        public DiffNode(List<Node> pathTo, NodeWrapper left, NodeWrapper right) {
            this.pathTo = pathTo;
            this.left = left;
            this.right = right;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Path: ");
            if (Util.isEmpty(this.pathTo)) {
                sb.append("<empty>");
            } else {
                String delim = "";
                for (Node n : this.pathTo) {
                    sb.append(delim);
                    delim = " -> ";
                    sb.append(new QName(n.getNamespaceURI(), n.getLocalName()));
                }
            }
            sb.append("\n");
            sb.append("left: ");
            this.outNw(sb, this.left);
            sb.append("right: ");
            this.outNw(sb, this.right);
            return sb.toString();
        }

        private void outNw(StringBuilder sb, NodeWrapper nw) {
            if (this.left == null) {
                sb.append("null ");
                return;
            }
            sb.append(nw.getName());
            sb.append(" ");
            if (nw.hasContent()) {
                sb.append(nw.getContent());
                sb.append(" ");
            }
        }
    }
}

