/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.xml.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.XmlUtil;
import org.w3c.dom.Node;

public class NodeWrapper
implements Comparable<NodeWrapper> {
    private final Node theNode;
    private List<NodeWrapper> children;

    public NodeWrapper(Node theNode) {
        this.theNode = theNode;
    }

    public Node getNode() {
        return this.theNode;
    }

    public boolean hasChildren() {
        return XmlUtil.hasChildren(this.theNode);
    }

    public boolean hasContent() {
        return XmlUtil.hasContent(this.theNode);
    }

    public String getContent() {
        return XmlUtil.getElementContent(this.theNode);
    }

    public QName getName() {
        return new QName(this.theNode.getNamespaceURI(), this.theNode.getLocalName());
    }

    public List<NodeWrapper> getChildWrappers() {
        if (this.children != null) {
            return this.children;
        }
        if (!XmlUtil.hasChildren(this.theNode)) {
            this.children = Collections.emptyList();
            return this.children;
        }
        this.children = new ArrayList<NodeWrapper>();
        for (Node nd : XmlUtil.getNodes(this.theNode)) {
            this.children.add(new NodeWrapper(nd));
        }
        Collections.sort(this.children);
        return this.children;
    }

    public int shallowCompare(NodeWrapper o) {
        int res = this.theNode.getNamespaceURI().compareTo(o.theNode.getNamespaceURI());
        if (res != 0) {
            return res;
        }
        res = this.theNode.getLocalName().compareTo(o.theNode.getLocalName());
        if (res != 0) {
            return res;
        }
        if (!this.hasChildren()) {
            if (o.hasChildren()) {
                return -1;
            }
            return Util.compareStrings((String)this.getContent(), (String)o.getContent());
        }
        return 0;
    }

    @Override
    public int compareTo(NodeWrapper o) {
        int res = this.shallowCompare(o);
        if (res != 0) {
            return res;
        }
        List<NodeWrapper> theirChildren = this.getChildWrappers();
        int index = 0;
        for (NodeWrapper nw : this.getChildWrappers()) {
            if (index == theirChildren.size()) {
                return 1;
            }
            res = this.compareTo(theirChildren.get(index));
            if (res != 0) {
                return res;
            }
            ++index;
        }
        if (index < theirChildren.size()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.theNode.getNamespaceURI().hashCode() ^ this.theNode.getLocalName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof NodeWrapper) {
            return this.compareTo((NodeWrapper)o) == 0;
        }
        return false;
    }
}

