/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.bedework.util.args.Args;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.timezones.model.aliases.AliasInfoType;
import org.bedework.util.timezones.model.aliases.TimezoneAliasInfoType;
import org.bedework.util.timezones.model.aliases.TimezonesAliasInfoType;

public class TzAliasesUtil
implements Logged {
    private String infileName;
    private String outfileName;
    private String propsfileName;
    private URI currentURI;
    private String currentURIStr;
    private final BwLogger logger = new BwLogger();

    private TzAliasesUtil() {
    }

    public TimezonesAliasInfoType mergeProperties(TimezonesAliasInfoType tzsai, Properties p, URI source) {
        ArrayList<TimezoneAliasInfoType> atai;
        if (source == null) {
            this.currentURIStr = null;
        } else {
            this.currentURI = source;
            this.currentURIStr = this.currentURI.toString();
        }
        TimezonesAliasInfoType tzsaires = tzsai;
        if (tzsaires == null) {
            tzsaires = new TimezonesAliasInfoType();
        }
        if ((atai = tzsaires.getTimezoneAliasInfo()) == null) {
            atai = new ArrayList<TimezoneAliasInfoType>();
            tzsaires.setTimezoneAliasInfo(atai);
        }
        Map<String, TimezoneAliasInfoType> tzmap = this.getTzMap((List<TimezoneAliasInfoType>)atai);
        for (Object o : p.keySet()) {
            String alias = (String)o;
            String tzid = p.getProperty(alias);
            TimezoneAliasInfoType tai = tzmap.get(tzid);
            if (tai == null) {
                tai = new TimezoneAliasInfoType();
                tai.setTzid(tzid);
                tzmap.put(tzid, tai);
                atai.add(tai);
            }
            this.addAlias(tai, tzid, alias);
        }
        return tzsaires;
    }

    public boolean process() throws Throwable {
        TimezonesAliasInfoType tai = null;
        if (this.infileName != null) {
            FileInputStream in = new FileInputStream(this.infileName);
            tai = (TimezonesAliasInfoType)this.unmarshal(in);
        }
        if (this.propsfileName == null) {
            this.error("Must provide properties file");
            this.usage();
            return false;
        }
        FileInputStream propStream = new FileInputStream(this.propsfileName);
        Properties props = new Properties();
        props.load(propStream);
        OutputStream out = this.outfileName == null ? System.out : new FileOutputStream(this.outfileName);
        tai = this.mergeProperties(tai, props, null);
        this.marshal(tai, out);
        out.close();
        return true;
    }

    public static void main(String[] args) {
        try {
            TzAliasesUtil tzau = new TzAliasesUtil();
            if (!tzau.processArgs(new Args(args))) {
                return;
            }
            tzau.process();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void marshal(TimezonesAliasInfoType tai, OutputStream out) throws Throwable {
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{tai.getClass()});
        Marshaller marshaller = contextObj.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)new JAXBElement(new QName("urn:ietf:params:xml:ns:timezone-service-aliases", "TimezonesAliasInfoType"), tai.getClass(), (Object)tai), out);
    }

    protected Object unmarshal(InputStream in) throws Throwable {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{TimezonesAliasInfoType.class});
        Unmarshaller u = jc.createUnmarshaller();
        return u.unmarshal(in);
    }

    private boolean processArgs(Args args) throws Throwable {
        if (args == null) {
            return true;
        }
        while (args.more()) {
            if (args.ifMatch("")) continue;
            if (args.ifMatch("-f")) {
                this.infileName = args.next();
                continue;
            }
            if (args.ifMatch("-o")) {
                this.outfileName = args.next();
                continue;
            }
            if (args.ifMatch("-p")) {
                this.propsfileName = args.next();
                continue;
            }
            this.error("Illegal argument: " + args.current());
            this.usage();
            return false;
        }
        return true;
    }

    private void usage() {
        System.out.println("Usage:");
        System.out.println("args   -f <filename>");
        System.out.println("            specify file containing xml data");
        System.out.println("       -p <filename>");
        System.out.println("            specify file containing properties");
        System.out.println("       -o <filename>");
        System.out.println("            specify file for XML output");
        System.out.println();
    }

    private Map<String, TimezoneAliasInfoType> getTzMap(List<TimezoneAliasInfoType> atai) {
        HashMap<String, TimezoneAliasInfoType> tzmap = new HashMap<String, TimezoneAliasInfoType>();
        if (atai == null) {
            return tzmap;
        }
        for (TimezoneAliasInfoType tai : atai) {
            tzmap.put(tai.getTzid(), tai);
        }
        return tzmap;
    }

    private void addAlias(TimezoneAliasInfoType tai, String tzid, String alias) {
        ArrayList<AliasInfoType> aai = tai.getAliases();
        if (aai == null) {
            aai = new ArrayList<AliasInfoType>();
            tai.setAliases(aai);
        }
        for (AliasInfoType ai : aai) {
            if (!ai.getAlias().equals(alias)) continue;
            return;
        }
        AliasInfoType ai = new AliasInfoType();
        aai.add(ai);
        ai.setAlias(alias);
        ai.setSource(this.currentURIStr);
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

