/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.util.Date;
import net.fortuna.ical4j.model.DateTime;

public class Onset
implements Comparable<Onset> {
    final String observanceName;
    final boolean standard;
    DateTime onset;
    long offsetSeconds;

    public Onset(String observanceName, boolean standard, DateTime onset, long offsetSeconds) {
        this.observanceName = observanceName;
        this.standard = standard;
        this.onset = onset;
        this.offsetSeconds = this.offsetSeconds;
        onset.setUtc(true);
    }

    public boolean equals(Object o) {
        Onset on = (Onset)o;
        return this.onset.equals((Object)on.onset) && this.offsetSeconds == on.offsetSeconds;
    }

    @Override
    public int compareTo(Onset o) {
        int res = this.observanceName.compareTo(o.observanceName);
        if (res != 0) {
            return res;
        }
        if (this.standard != o.standard) {
            if (this.standard) {
                return 1;
            }
            return -1;
        }
        res = this.onset.compareTo((Date)o.onset);
        if (res != 0) {
            return res;
        }
        if (this.offsetSeconds > o.offsetSeconds) {
            return 1;
        }
        if (this.offsetSeconds < o.offsetSeconds) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        String type = this.standard ? "standard" : "daylight";
        return this.observanceName + "(" + type + "): " + this.onset.toString() + " " + this.offsetSeconds;
    }
}

