/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.UtcOffset;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.TzName;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import org.bedework.timezones.convert.DateTime;
import org.bedework.timezones.convert.Recurrence;
import org.bedework.timezones.convert.Utils;
import org.bedework.timezones.convert.ZoneRule;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

class Rule {
    String name;
    private String fromYear;
    private String toYear;
    private String type = "-";
    private String inMonth;
    private String onDay;
    private String atTime;
    private String saveTime;
    private String letter;
    static final Map<String, Integer> LASTDAY_NAME_TO_DAY = new HashMap<String, Integer>();
    static final Map<String, Integer> DAY_NAME_TO_DAY;
    static final Map<String, Integer> LASTDAY_NAME_TO_RDAY;
    static final Map<String, Integer> MONTH_NAME_TO_POS;
    static final int[] daysBackStartOfMonth;
    private List<Utils.DateTimeWrapper> dtCache;

    Rule() {
    }

    void parse(String line) {
        List<String> splits = Utils.untab(line);
        Utils.assertion(splits.size() >= 10, "Wrong number of fields in Rule: '%s'", line);
        this.name = splits.get(1);
        this.fromYear = splits.get(2);
        this.toYear = splits.get(3);
        this.type = splits.get(4);
        this.inMonth = splits.get(5);
        this.onDay = splits.get(6);
        this.atTime = splits.get(7);
        this.saveTime = splits.get(8);
        this.letter = splits.get(9);
    }

    String generate() {
        return "Rule\t" + this.name + "\t" + this.fromYear + "\t" + this.toYear + "\t" + this.type + "\t" + this.inMonth + "\t" + this.onDay + "\t" + this.atTime + "\t" + this.saveTime + "\t" + this.letter;
    }

    private int getOffset() {
        boolean negative;
        String[] splits = this.saveTime.split(":");
        int hours = Integer.valueOf(splits[0]);
        int minutes = splits.length == 2 ? Integer.valueOf(splits[1]) : 0;
        boolean bl = negative = hours < 0;
        if (negative) {
            return -(-hours * 60 + minutes) * 60;
        }
        return (hours * 60 + minutes) * 60;
    }

    public boolean isStandard() {
        return this.getOffset() == 0;
    }

    private int startYear() {
        return new Integer(this.fromYear);
    }

    private int endYear() {
        if (this.toYear.equals("only")) {
            return this.startYear();
        }
        if (this.toYear.equals("max")) {
            return 9999;
        }
        return Integer.valueOf(this.toYear);
    }

    private Utils.DateTimeWrapper datetimeForYear(int year) {
        String special;
        int minutes;
        String minval;
        DateTime dt = new DateTime();
        dt.setYear(year);
        dt.setMonth(MONTH_NAME_TO_POS.get(this.inMonth));
        dt.setDay(1);
        String[] splits = this.atTime.split(":");
        if (splits.length == 1) {
            minval = "0";
        } else {
            Utils.assertion(splits.length == 2, "atTime format is wrong: %s, %s", this.atTime, this);
            minval = splits[1];
        }
        int hours = Integer.valueOf(splits[0]);
        if (minval.length() > 2) {
            minutes = Integer.valueOf(minval.substring(0, 2));
            special = minval.substring(2);
        } else {
            minutes = Integer.valueOf(minval);
            special = null;
        }
        boolean advanceDay = false;
        if (hours == 24 & minutes == 0) {
            dt.setHours(0);
            dt.setMinutes(0);
            advanceDay = true;
        } else {
            dt.setHours(hours);
            dt.setMinutes(minutes);
        }
        if (LASTDAY_NAME_TO_DAY.containsKey(this.onDay)) {
            dt.setDayOfWeekInMonth(-1, LASTDAY_NAME_TO_DAY.get(this.onDay));
        } else if (this.onDay.contains(">=")) {
            splits = this.onDay.split(">=");
            dt.setNextDayOfWeek(Integer.valueOf(splits[1]), DAY_NAME_TO_DAY.get(splits[0]));
        } else {
            try {
                int day = Integer.valueOf(this.onDay);
                dt.setDay(day);
            }
            catch (Throwable t) {
                Utils.assertion(false, "onDay value is not recognized: %s", this.onDay);
            }
        }
        if (advanceDay) {
            dt.setDay(dt.getDay() + 1);
            dt.normalise();
        }
        return new Utils.DateTimeWrapper(dt, special);
    }

    private OnDayDetails getOnDayDetails(DateTime start, int indicatedDay, int indicatedOffset) {
        int dayOfWeek;
        OnDayDetails res = new OnDayDetails();
        int month = start.getMonth();
        int year = start.getYear();
        res.day = dayOfWeek = start.getDayOfWeek();
        int offset = indicatedOffset;
        if (indicatedDay != dayOfWeek) {
            int difference = dayOfWeek - indicatedDay;
            if (difference == 1 || difference == -6) {
                ++offset;
                if (start.getDay() == 1 && --month < 1) {
                    month = 12;
                }
            } else if (difference == -1 || difference == 6) {
                Utils.assertion(offset != 1, "Bad RRULE adjustment", new Object[0]);
                --offset;
            } else {
                Utils.assertion(false, "Unknown RRULE adjustment", new Object[0]);
            }
        }
        try {
            if (offset == 1) {
                offset = 1;
            } else if (offset == 8) {
                offset = 2;
            } else if (offset == 15) {
                offset = 3;
            } else if (offset == 22) {
                offset = 4;
            } else {
                int days_in_month = Utils.daysInMonth(month, year);
                if (days_in_month - offset == 6) {
                    offset = -1;
                } else if (days_in_month - offset == 13) {
                    offset = -2;
                } else if (days_in_month - offset == 20) {
                    offset = -3;
                } else {
                    res.bymday = new ArrayList<Integer>();
                    for (int i = 0; i < 7; ++i) {
                        if (offset + i > days_in_month) continue;
                        res.bymday.add(offset + i);
                    }
                    offset = 0;
                }
            }
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
            Utils.assertion(false, "onDay value is not recognized: %s", this.onDay);
        }
        res.offset = offset;
        return res;
    }

    public void expand(List<DateOffset> results, ZoneRule zoneinfo, int maxYear) {
        if (this.startYear() >= maxYear) {
            return;
        }
        int zoneoffset = zoneinfo.getUTCOffset();
        Utils.DateTimeWrapper lastForZI = zoneinfo.getUntilDate();
        int offset = this.getOffset();
        for (Utils.DateTimeWrapper dt : this.fullExpand(maxYear)) {
            if (dt.compareTo(lastForZI) > 0) continue;
            results.add(new DateOffset(dt.duplicate(), zoneoffset + offset, this));
        }
    }

    private List<Utils.DateTimeWrapper> fullExpand(int maxYear) {
        if (this.dtCache != null) {
            return this.dtCache;
        }
        int start = this.startYear();
        int end = this.endYear();
        if (end > maxYear) {
            end = maxYear - 1;
        }
        this.dtCache = new ArrayList<Utils.DateTimeWrapper>();
        for (int year = start; year <= end; ++year) {
            this.dtCache.add(this.datetimeForYear(year));
        }
        return this.dtCache;
    }

    void vtimezone(VTimeZone vtz, ZoneRule zonerule, DateTime start, DateTime end, int offsetfrom, int offsetto, int instanceCount) {
        boolean standard = this.isStandard();
        Object comp = standard ? new Standard() : new Daylight();
        String tzname = Utils.formatTzname(zonerule.getFormat(), this.letter, standard);
        comp.getProperties().add((Property)new TzName(tzname));
        UtcOffset tzoffsetfrom = new UtcOffset((long)(offsetfrom * 1000));
        UtcOffset tzoffsetto = new UtcOffset((long)(offsetto * 1000));
        comp.getProperties().add((Property)new TzOffsetFrom(null, tzoffsetfrom));
        comp.getProperties().add((Property)new TzOffsetTo(null, tzoffsetto));
        try {
            comp.getProperties().add((Property)new DtStart(start.localTime()));
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        if (!this.toYear.equals("only") && instanceCount != 1) {
            Recurrence rrule = new Recurrence();
            rrule.setByMonth(MONTH_NAME_TO_POS.get(this.inMonth));
            if (LASTDAY_NAME_TO_RDAY.containsKey(this.onDay)) {
                int indicatedDay;
                int dayOfWeek = start.getDayOfWeek();
                if (dayOfWeek == (indicatedDay = LASTDAY_NAME_TO_DAY.get(this.onDay).intValue())) {
                    rrule.addByDay(-1, LASTDAY_NAME_TO_RDAY.get(this.onDay));
                } else if (dayOfWeek < indicatedDay || dayOfWeek == 6 && indicatedDay == 0) {
                    int fakeOffset = Utils.daysInMonth(start.getMonth(), start.getYear()) - 6;
                    OnDayDetails odd = this.getOnDayDetails(start, indicatedDay, fakeOffset);
                    if (odd.bymday != null) {
                        rrule.setByMonthDay(odd.bymday);
                    }
                    rrule.addByDay(odd.offset, odd.day);
                } else {
                    rrule.setByMonth(null);
                    for (int i = 0; i < 7; ++i) {
                        rrule.addByYearDay(-(daysBackStartOfMonth[MONTH_NAME_TO_POS.get(this.inMonth)] + i));
                    }
                    rrule.addByDay(0, (LASTDAY_NAME_TO_DAY.get(this.onDay) + 1) % 7);
                }
            } else if (this.onDay.contains(">=")) {
                int indicatedDay;
                String[] split = this.onDay.split(">=");
                int dayoffset = Integer.valueOf(split[1]);
                int dayOfWeek = start.getDayOfWeek();
                if (dayOfWeek == (indicatedDay = DAY_NAME_TO_DAY.get(split[0]).intValue())) {
                    OnDayDetails odd = this.getOnDayDetails(start, indicatedDay, dayoffset);
                    if (odd.bymday != null) {
                        rrule.setByMonthDay(odd.bymday);
                    }
                    rrule.addByDay(odd.offset, odd.day);
                } else if (dayoffset == 1 && (dayoffset - indicatedDay) % 7 == 6) {
                    rrule.setByMonth(null);
                    for (int i = 0; i < 7; ++i) {
                        rrule.addByYearDay(-(daysBackStartOfMonth[MONTH_NAME_TO_POS.get(this.inMonth)] + i));
                    }
                    rrule.addByDay(0, indicatedDay + 1);
                } else {
                    OnDayDetails odd = this.getOnDayDetails(start, indicatedDay, dayoffset);
                    if (odd.bymday != null) {
                        rrule.setByMonthDay(odd.bymday);
                    }
                    rrule.addByDay(odd.offset, odd.day);
                }
            } else {
                try {
                    Integer.valueOf(this.onDay);
                }
                catch (Throwable t) {
                    Utils.assertion(false, "onDay value is not recognized: %s", this.onDay);
                }
            }
            if (zonerule.getUntilDate().getDt().getYear() < 9999 || this.endYear() < 9999) {
                DateTime until = end.duplicate();
                until.offsetSeconds(-offsetfrom);
                until.setTimezoneUTC(true);
                rrule.setUseUntil(true);
                rrule.setUntil(until);
            }
            comp.getProperties().add((Property)new RRule(rrule.getRecur()));
        } else {
            try {
                comp.getProperties().add((Property)new RDate(new ParameterList(), start.localTime()));
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe);
            }
        }
        vtz.getObservances().add((Object)((Observance)comp));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Rule other = (Rule)o;
        return this.name.equals(other.name) && this.fromYear.equals(other.fromYear) && this.toYear.equals(other.toYear) && this.type.equals(other.type) && this.inMonth.equals(other.inMonth) && this.onDay.equals(other.onDay) && this.atTime.equals(other.atTime) && this.saveTime.equals(other.saveTime) && Util.equalsString((String)this.letter, (String)other.letter);
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("name", (Object)this.name);
        ts.append("fromYear", (Object)this.fromYear);
        ts.append("toYear", (Object)this.toYear);
        ts.append("type", (Object)this.type);
        ts.append("inMonth", (Object)this.inMonth);
        ts.append("onDay", (Object)this.onDay);
        ts.append("atTime", (Object)this.atTime);
        ts.append("saveTime", (Object)this.saveTime);
        ts.append("letter", (Object)this.letter);
        return ts.toString();
    }

    static {
        LASTDAY_NAME_TO_DAY.put("lastSun", 0);
        LASTDAY_NAME_TO_DAY.put("lastMon", 1);
        LASTDAY_NAME_TO_DAY.put("lastTue", 2);
        LASTDAY_NAME_TO_DAY.put("lastWed", 3);
        LASTDAY_NAME_TO_DAY.put("lastThu", 4);
        LASTDAY_NAME_TO_DAY.put("lastFri", 5);
        LASTDAY_NAME_TO_DAY.put("lastSat", 6);
        DAY_NAME_TO_DAY = new HashMap<String, Integer>();
        DAY_NAME_TO_DAY.put("Sun", 0);
        DAY_NAME_TO_DAY.put("Mon", 1);
        DAY_NAME_TO_DAY.put("Tue", 2);
        DAY_NAME_TO_DAY.put("Wed", 3);
        DAY_NAME_TO_DAY.put("Thu", 4);
        DAY_NAME_TO_DAY.put("Fri", 5);
        DAY_NAME_TO_DAY.put("Sat", 6);
        LASTDAY_NAME_TO_RDAY = new HashMap<String, Integer>();
        LASTDAY_NAME_TO_RDAY.put("lastSun", 0);
        LASTDAY_NAME_TO_RDAY.put("lastMon", 1);
        LASTDAY_NAME_TO_RDAY.put("lastTue", 2);
        LASTDAY_NAME_TO_RDAY.put("lastWed", 3);
        LASTDAY_NAME_TO_RDAY.put("lastThu", 4);
        LASTDAY_NAME_TO_RDAY.put("lastFri", 5);
        LASTDAY_NAME_TO_RDAY.put("lastSat", 6);
        MONTH_NAME_TO_POS = new HashMap<String, Integer>();
        MONTH_NAME_TO_POS.put("Jan", 1);
        MONTH_NAME_TO_POS.put("Feb", 2);
        MONTH_NAME_TO_POS.put("Mar", 3);
        MONTH_NAME_TO_POS.put("Apr", 4);
        MONTH_NAME_TO_POS.put("May", 5);
        MONTH_NAME_TO_POS.put("Jun", 6);
        MONTH_NAME_TO_POS.put("Jul", 7);
        MONTH_NAME_TO_POS.put("Aug", 8);
        MONTH_NAME_TO_POS.put("Sep", 9);
        MONTH_NAME_TO_POS.put("Oct", 10);
        MONTH_NAME_TO_POS.put("Nov", 11);
        MONTH_NAME_TO_POS.put("Dec", 12);
        daysBackStartOfMonth = new int[]{365, 334, 306, 275, 245, 214, 184, 153, 122, 92, 61, 31, 0};
    }

    static class DateOffset
    implements Comparable<DateOffset> {
        Utils.DateTimeWrapper dt;
        int offset;
        Rule rule;

        DateOffset(Utils.DateTimeWrapper dt, int offset, Rule rule) {
            this.dt = dt;
            this.offset = offset;
            this.rule = rule;
        }

        @Override
        public int compareTo(DateOffset o) {
            return this.dt.compareTo(o.dt);
        }
    }

    static class OnDayDetails {
        int day;
        int offset;
        List<Integer> bymday;

        OnDayDetails() {
        }
    }
}

