/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.TzName;
import net.fortuna.ical4j.util.Dates;
import org.bedework.timezones.convert.Onset;
import org.bedework.util.jmx.InfoLines;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.timezones.TzFetcher;

class Compare
implements Logged {
    private static final String UTC_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final DateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private final BwLogger logger = new BwLogger();

    Compare() {
    }

    List<String> compare(Map<String, VTimeZone> vtzs, TzFetcher tzFetcher, InfoLines msgs, String verboseId) {
        try {
            DateTime endDate = new DateTime("20200101T000000Z");
            ArrayList<String> tzids = new ArrayList<String>();
            for (String tzid : vtzs.keySet()) {
                VTimeZone ourVtz = vtzs.get(tzid);
                VTimeZone otherTz = tzFetcher.getTz(tzid);
                if (otherTz == null || this.compareTz(ourVtz, otherTz, (Date)endDate, msgs, verboseId)) continue;
                tzids.add(tzid);
            }
            return tzids;
        }
        catch (Throwable t) {
            msgs.exceptionMsg(t);
            return null;
        }
    }

    boolean compareTz(VTimeZone tz, VTimeZone thatTz, Date endDate, InfoLines msgs, String verboseId) {
        Set<Onset> onsets = this.getOnsets(tz, endDate, msgs);
        Set<Onset> thatOnsets = this.getOnsets(thatTz, endDate, msgs);
        String tzid = tz.getTimeZoneId().getValue();
        boolean matches = Compare.missing(onsets, thatOnsets, "For " + tzid + " in this but not that", msgs);
        if (!Compare.missing(thatOnsets, onsets, "For " + tzid + " in that but not this", msgs)) {
            matches = false;
        }
        if (this.debug()) {
            this.debug("Timezone " + tzid + " match=" + matches);
        }
        if (!matches) {
            msgs.addLn("Timezone " + tzid + " does not match");
        }
        return matches;
    }

    private static boolean missing(Set<Onset> a, Set<Onset> b, String msgPrefix, InfoLines msgs) {
        TreeSet<Onset> notInThat = new TreeSet<Onset>(a);
        notInThat.removeAll(b);
        if (notInThat.isEmpty()) {
            return true;
        }
        for (Onset o : notInThat) {
            msgs.addLn(msgPrefix + " " + o);
        }
        return false;
    }

    private Set<Onset> getOnsets(VTimeZone tz, Date endDate, InfoLines msgs) {
        ComponentList observances = tz.getObservances();
        TreeSet<Onset> onsets = new TreeSet<Onset>();
        for (Observance obs : observances) {
            Set<Onset> dl = this.getOnsets(obs, endDate, msgs);
            if (dl == null) continue;
            onsets.addAll(dl);
        }
        return onsets;
    }

    private Set<Onset> getOnsets(Observance o, Date endDate, InfoLines msgs) {
        DateTime initialOnsetUTC;
        DateTime initialOnset;
        TreeSet<Onset> onsets = new TreeSet<Onset>();
        long offsetSeconds = o.getOffsetTo().getOffset().getTotalSeconds();
        try {
            initialOnset = this.applyOffsetFrom(o, Compare.calculateOnset(((DtStart)o.getProperty("DTSTART")).getDate().toString()));
        }
        catch (ParseException e) {
            msgs.add((Object)("Unexpected error calculating initial onset " + e));
            return null;
        }
        TzName tznameP = (TzName)o.getProperty("TZNAME");
        String tzname = tznameP == null ? "unknown" : tznameP.getValue();
        onsets.add(new Onset(tzname, o instanceof Standard, initialOnset, offsetSeconds));
        try {
            initialOnsetUTC = Compare.calculateOnset(((DtStart)o.getProperty("DTSTART")).getDate().toString());
        }
        catch (ParseException e) {
            msgs.add((Object)("Unexpected error calculating initial onset " + e));
            return null;
        }
        PropertyList rdates = o.getProperties("RDATE");
        for (Property rdate1 : rdates) {
            RDate rdate = (RDate)rdate1;
            for (Object o1 : rdate.getDates()) {
                try {
                    DateTime rdateOnset = this.applyOffsetFrom(o, Compare.calculateOnset(o1.toString()));
                    if (rdateOnset.after((java.util.Date)endDate)) continue;
                    onsets.add(new Onset(tzname, o instanceof Standard, rdateOnset, offsetSeconds));
                }
                catch (ParseException e) {
                    msgs.add((Object)("Unexpected error calculating onset" + e));
                }
            }
        }
        PropertyList rrules = o.getProperties("RRULE");
        for (Property rrule1 : rrules) {
            RRule rrule = (RRule)rrule1;
            Calendar cal = Dates.getCalendarInstance((Date)endDate);
            cal.setTime((java.util.Date)endDate);
            cal.add(1, 10);
            Date onsetLimit = Dates.getInstance((java.util.Date)cal.getTime(), (Value)Value.DATE_TIME);
            DateList recurrenceDates = rrule.getRecur().getDates((Date)initialOnsetUTC, onsetLimit, Value.DATE_TIME);
            for (Object recurrenceDate : recurrenceDates) {
                DateTime rruleOnset = this.applyOffsetFrom(o, (DateTime)recurrenceDate);
                if (rruleOnset.after((java.util.Date)endDate)) continue;
                onsets.add(new Onset(tzname, o instanceof Standard, rruleOnset, offsetSeconds));
            }
        }
        return onsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateTime calculateOnset(String dateStr) throws ParseException {
        long utcOnset;
        DateFormat dateFormat = UTC_FORMAT;
        synchronized (dateFormat) {
            utcOnset = UTC_FORMAT.parse(dateStr).getTime();
        }
        DateTime onset = new DateTime(true);
        onset.setTime(utcOnset);
        return onset;
    }

    private DateTime applyOffsetFrom(Observance o, DateTime orig) {
        DateTime withOffset = new DateTime(true);
        withOffset.setTime(orig.getTime() - (long)o.getOffsetFrom().getOffset().getTotalSeconds() * 1000L);
        withOffset.setUtc(true);
        return withOffset;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone((String)"Etc/UTC"));
        UTC_FORMAT.setLenient(false);
    }
}

