/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.bedework.util.args.Args;

public class FixCdTestTzs {
    String dirName;
    int changed;
    private static ArrayList<String> skipList = new ArrayList();
    private static final String tzMarker = "--Put tzdef here--";
    private static Map<String, Syms> tzidMap;

    boolean process() throws Throwable {
        File d = new File(this.dirName);
        if (!d.isDirectory()) {
            this.error("Not a directory: " + this.dirName);
            return false;
        }
        if (!this.processDir(d, "")) {
            this.error("Failed?");
            return false;
        }
        this.info("\n\nChanged: " + this.changed);
        return true;
    }

    boolean processDir(File d, String indent) throws Throwable {
        String path = d.getPath();
        for (String p : skipList) {
            if (!path.endsWith(p)) continue;
            this.info(indent + path + "  *** Skipped ***");
            return true;
        }
        this.info(indent + path);
        String[] l = d.list();
        TreeSet<CallSite> sorted = new TreeSet<CallSite>();
        if (l != null && l.length > 0) {
            for (String s : l) {
                if (s.equals(".svn")) continue;
                sorted.add((CallSite)((Object)(d.getPath() + "/" + s)));
            }
        }
        for (String string : sorted) {
            File f = new File(string);
            if (f.isDirectory()) {
                if (this.processDir(f, indent + "  ")) continue;
                return false;
            }
            if (!f.isFile()) continue;
            this.processFile(f, indent + "  ");
        }
        return true;
    }

    void processFile(File f, String indent) throws Throwable {
        Syms syms;
        FileReader fr = new FileReader(f);
        LineNumberReader lnr = new LineNumberReader(fr);
        String ln = lnr.readLine();
        if (ln == null | !"BEGIN:VCALENDAR".equals(ln)) {
            if (ln.startsWith("BEGIN:VCALENDAR")) {
                this.error("Starts with BEGIN:VCALENDAR");
            }
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ln);
        boolean rewrite = false;
        boolean inTz = false;
        boolean defUsed = false;
        String tzName = null;
        while ((ln = lnr.readLine()) != null) {
            if (inTz) {
                if (tzName != null) {
                    if (!ln.equals("END:VTIMEZONE")) continue;
                    inTz = false;
                    continue;
                }
                if (!ln.startsWith("TZID:")) continue;
                tzName = ln.substring(5);
                continue;
            }
            if (ln.equals("BEGIN:VTIMEZONE")) {
                if (tzName != null) {
                    this.error("Multiple timezones for " + f.getPath());
                    break;
                }
                inTz = true;
                rewrite = true;
                lines.add(tzMarker);
                continue;
            }
            if (tzName == null) {
                lines.add(ln);
                continue;
            }
            int pos = ln.indexOf(";TZID=" + tzName + ":");
            if (pos < 0) {
                lines.add(ln);
                continue;
            }
            syms = tzidMap.get(tzName);
            if (syms == null) {
                this.error("Unmapped timezone " + tzName + " for " + f.getPath());
                break;
            }
            lines.add(ln.replace(";TZID=" + tzName + ":", ";TZID=" + syms.idSym + ":"));
            defUsed = true;
        }
        lnr.close();
        fr.close();
        if (!rewrite) {
            return;
        }
        ++this.changed;
        FileWriter fw = new FileWriter(f);
        syms = tzidMap.get(tzName);
        for (String s : lines) {
            if (s.equals(tzMarker)) {
                if (syms == null) {
                    this.error("Unmapped timezone " + tzName + " for " + f.getPath());
                    continue;
                }
                if (defUsed) {
                    s = syms.defSym;
                } else if (syms.spuriousSym == null) {
                    this.error("No spurious sym for " + tzName + " for " + f.getPath());
                    s = syms.defSym;
                } else {
                    s = syms.spuriousSym;
                }
            }
            if (s == null) {
                this.error("No def for timezone " + tzName + " for " + f.getPath());
                continue;
            }
            fw.write(s);
            fw.write("\n");
        }
        fw.close();
    }

    boolean processArgs(Args args) throws Throwable {
        if (args == null) {
            return true;
        }
        while (args.more()) {
            if (args.ifMatch("")) continue;
            if (args.ifMatch("-d")) {
                this.dirName = args.next();
                continue;
            }
            this.error("Illegal argument: " + args.current());
            this.usage();
            return false;
        }
        return true;
    }

    protected void info(String msg) {
        System.out.println(msg);
    }

    protected void error(String msg) {
        System.err.println(msg);
    }

    void usage() {
        this.info("Usage:");
        this.info("args   -d <dirname>");
        this.info("            specify directory containing files");
        this.info("");
    }

    public static void main(String[] args) {
        FixCdTestTzs fx = null;
        try {
            fx = new FixCdTestTzs();
            if (!fx.processArgs(new Args(args))) {
                return;
            }
            fx.process();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        skipList.add("CalDAV/timezones");
        tzidMap = new HashMap<String, Syms>();
        tzidMap.put("US/Eastern", new Syms("$tzidUSE:", "$tzspecUSE:", "$tzspecUSEspurious:"));
        tzidMap.put("US/Mountain", new Syms("$tzidUSMountain:", "$tzspecUSMountain:", null));
        tzidMap.put("US/Pacific", new Syms("$tzidUSPacific:", "$tzspecUSPacific:", null));
        tzidMap.put("America/Vancouver", new Syms("$tzidVancouver:", "$tzspecVancouver:", null));
        tzidMap.put("America/Montreal", new Syms("$tzidMontreal:", "$tzspecMontreal:", null));
        tzidMap.put("America/New_York", new Syms("$tzidNew_York:", "$tzspecNew_York:", null));
        tzidMap.put("America/St_Johns", new Syms("$tzidSt_Johns:", "$tzspecSt_Johns:", null));
        tzidMap.put("Brazil/East", new Syms("$tzidBrazilEast:", "$tzspecBrazilEast:", null));
        tzidMap.put("Etc/GMT+5", new Syms("$tzidEtcGMT5:", "$tzspecEtcGMT5:", null));
        tzidMap.put("Etc/GMT+8", new Syms("$tzidEtcGMT8:", "$tzspecEtcGMT8:", null));
    }

    private static class Syms {
        String idSym;
        String defSym;
        String spuriousSym;

        Syms(String idSym, String defSym, String spuriousSym) {
            this.idSym = idSym;
            this.defSym = defSym;
            this.spuriousSym = spuriousSym;
        }
    }
}

