/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.Recur;
import org.bedework.timezones.convert.DateTime;
import org.bedework.util.misc.Util;

public class Recurrence {
    private Integer byMonth;
    private List<Integer> byMonthDay;
    private List<Integer> byYearDay;
    private final List<ByDay> byDay = new ArrayList<ByDay>();
    private static final String[] byDayVals = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA"};
    private DateTime until;
    private boolean useUntil;

    public void setByMonth(Integer val) {
        this.byMonth = val;
    }

    public void setByMonthDay(List<Integer> val) {
        this.byMonthDay = val;
    }

    public void addByDay(int offset, int dayNum) {
        this.byDay.add(new ByDay(offset, dayNum));
    }

    public void addByYearDay(int dayNum) {
        if (this.byYearDay == null) {
            this.byYearDay = new ArrayList<Integer>();
        }
        this.byYearDay.add(dayNum);
    }

    void setUseUntil(boolean val) {
        this.useUntil = val;
    }

    void setUntil(DateTime val) {
        this.until = val;
    }

    Recur getRecur() {
        boolean comma;
        StringBuilder sb = new StringBuilder("FREQ=");
        sb.append("YEARLY");
        if (this.useUntil) {
            sb.append(';');
            sb.append("UNTIL=");
            sb.append(this.until.utcTime());
        }
        if (!Util.isEmpty(this.byDay)) {
            sb.append(';');
            sb.append("BYDAY=");
            comma = false;
            for (ByDay bd : this.byDay) {
                if (comma) {
                    sb.append(',');
                }
                comma = true;
                if (bd.byDayOffset != 0) {
                    sb.append(bd.byDayOffset);
                }
                sb.append(byDayVals[bd.byDay]);
            }
        }
        if (!Util.isEmpty(this.byMonthDay)) {
            sb.append(';');
            sb.append("BYMONTHDAY=");
            comma = false;
            for (Integer i : this.byMonthDay) {
                if (comma) {
                    sb.append(',');
                }
                comma = true;
                sb.append(i);
            }
        }
        if (!Util.isEmpty(this.byYearDay)) {
            sb.append(';');
            sb.append("BYYEARDAY=");
            comma = false;
            for (Integer i : this.byYearDay) {
                if (comma) {
                    sb.append(',');
                }
                comma = true;
                sb.append(i);
            }
        }
        if (this.byMonth != null) {
            sb.append(';');
            sb.append("BYMONTH=");
            sb.append(this.byMonth);
        }
        try {
            return new Recur(sb.toString());
        }
        catch (ParseException pe) {
            System.err.println(sb.toString());
            throw new RuntimeException(pe);
        }
    }

    static class ByDay {
        int byDayOffset;
        int byDay;

        ByDay(int byDayOffset, int byDay) {
            this.byDayOffset = byDayOffset;
            this.byDay = byDay;
        }
    }
}

