/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.util.ArrayList;
import java.util.List;
import org.bedework.timezones.convert.Rule;
import org.bedework.timezones.convert.Utils;
import org.bedework.timezones.convert.ZoneRule;

public class RuleSet
extends ArrayList<Rule> {
    private String name;

    void parse(String lines) {
        String[] splitlines;
        for (String line : splitlines = lines.split("\n")) {
            String[] splits = line.replace("\t", " ").split(" ");
            String nm = splits[1];
            if (nm == null) {
                Utils.print("Must have a zone name: '%s'", lines);
            }
            if (this.name == null) {
                this.name = nm;
            }
            if (!nm.equals(this.name)) {
                Utils.print("Different zone names %s and %s: %s", this.name, nm);
            }
            Rule rule = new Rule();
            rule.parse(line);
            this.add(rule);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (Rule rl : this) {
            sb.append(delim);
            sb.append(rl.generate());
            delim = "\n";
        }
        return sb.toString();
    }

    List<Rule.DateOffset> expand(ZoneRule zoneinfo, int maxYear) {
        ArrayList<Rule.DateOffset> results = new ArrayList<Rule.DateOffset>();
        for (Rule rule : this) {
            rule.expand(results, zoneinfo, maxYear);
        }
        return results;
    }

    @Override
    public boolean equals(Object o) {
        RuleSet other = (RuleSet)o;
        return this.name.equals(other.name) && super.equals(other);
    }
}

