/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import org.bedework.timezones.convert.Processor;
import org.bedework.timezones.convert.TzCnvSvcMBean;
import org.bedework.timezones.convert.TzConvertParams;
import org.bedework.util.jmx.ConfBase;
import org.bedework.util.jmx.InfoLines;
import org.bedework.util.misc.Util;

public class TzCnvSvc
extends ConfBase<TzConvertParams>
implements TzCnvSvcMBean {
    private static final String confuriPname = "org.bedework.tzs.confuri";
    private Processor proc;

    public TzCnvSvc() {
        super("org.bedework.timezones:service=Convert");
        this.setConfigPname(confuriPname);
        this.setPathSuffix("cnvconfig");
    }

    @Override
    public void setTzServerUri(String val) {
        ((TzConvertParams)this.getConfig()).setTzServerUri(val);
    }

    @Override
    public String getTzServerUri() {
        return ((TzConvertParams)this.getConfig()).getTzServerUri();
    }

    @Override
    public void setCompare(boolean val) {
        ((TzConvertParams)this.getConfig()).setCompare(val);
    }

    @Override
    public boolean getCompare() {
        return ((TzConvertParams)this.getConfig()).getCompare();
    }

    @Override
    public void setEndYear(int val) {
        ((TzConvertParams)this.getConfig()).setEndYear(val);
    }

    @Override
    public int getEndYear() {
        return ((TzConvertParams)this.getConfig()).getEndYear();
    }

    @Override
    public void setStartYear(int val) {
        ((TzConvertParams)this.getConfig()).setStartYear(val);
    }

    @Override
    public int getStartYear() {
        return ((TzConvertParams)this.getConfig()).getStartYear();
    }

    @Override
    public void setRootdir(String val) {
        ((TzConvertParams)this.getConfig()).setRootdir(val);
    }

    @Override
    public String getRootdir() {
        return ((TzConvertParams)this.getConfig()).getRootdir();
    }

    @Override
    public void setProdid(String val) {
        ((TzConvertParams)this.getConfig()).setProdid(val);
    }

    @Override
    public String getProdid() {
        return ((TzConvertParams)this.getConfig()).getProdid();
    }

    @Override
    public void setSource(String val) {
        ((TzConvertParams)this.getConfig()).setSource(val);
    }

    @Override
    public String getSource() {
        return ((TzConvertParams)this.getConfig()).getSource();
    }

    @Override
    public void setGenerate(boolean val) {
        ((TzConvertParams)this.getConfig()).setGenerate(val);
    }

    @Override
    public boolean getGenerate() {
        return ((TzConvertParams)this.getConfig()).getGenerate();
    }

    @Override
    public void setCompareWithPath(String val) {
        ((TzConvertParams)this.getConfig()).setCompareWithPath(val);
    }

    @Override
    public String getCompareWithPath() {
        return ((TzConvertParams)this.getConfig()).getCompareWithPath();
    }

    @Override
    public void setVerboseId(String val) {
        ((TzConvertParams)this.getConfig()).setVerboseId(val);
    }

    @Override
    public String getVerboseId() {
        return ((TzConvertParams)this.getConfig()).getVerboseId();
    }

    @Override
    public void setAliasesPath(String val) {
        ((TzConvertParams)this.getConfig()).setAliasesPath(val);
    }

    @Override
    public String getAliasesPath() {
        return ((TzConvertParams)this.getConfig()).getAliasesPath();
    }

    @Override
    public String doConvert() {
        InfoLines msgs = new InfoLines();
        try {
            Processor proc = this.getProc();
            proc.parse();
            if (this.getGenerate()) {
                proc.generateZoneinfoFiles(Util.buildPath((boolean)true, (String[])new String[]{this.getRootdir(), "/", "zoneinfo"}), true);
            }
            if (this.getCompare()) {
                proc.compare(msgs);
            }
            for (String msg : msgs) {
                System.out.print(msg);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            msgs.exceptionMsg(t);
        }
        return msgs.toString();
    }

    @Override
    public String loadConfig() {
        return this.loadOnlyConfig(TzConvertParams.class);
    }

    private Processor getProc() {
        if (this.proc != null) {
            return this.proc;
        }
        this.proc = new Processor(this);
        return this.proc;
    }
}

