/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import org.bedework.timezones.convert.Processor;
import org.bedework.timezones.convert.TzConvertParams;
import org.bedework.timezones.convert.TzConvertParamsI;
import org.bedework.timezones.convert.Utils;
import org.bedework.util.args.Args;
import org.bedework.util.jmx.InfoLines;
import org.bedework.util.misc.Util;

class Tzconvert {
    Tzconvert() {
    }

    static void usage(String error_msg) {
        if (error_msg != null) {
            Utils.print(error_msg, new Object[0]);
        }
        Utils.print("Usage: tzconvert [options] [DIR]\nOptions:\n    -h            Print this help and exit\n    --prodid      PROD-ID string to use\n    --start       Start year\n    --end         End year\n    --root        Directory containing an Olson tzdata directory to read, also\n             where zoneinfo data will be written\n    --generate    true/false\n    --comparewith Directory containing an \" +\n Olson tzdata directory to  compare with\n    --tzserver    Server providing tz data to compare with\" +\n    --aliases     Path to property file defining extra aliases\n    --source      Value to be supplied in info.properties e.g. IANA 2014d\n\nDescription:\n    This utility convert Olson-style timezone data in iCalendar.\n    VTIMEZONE objects, one .ics file per-timezone.\n", new Object[0]);
        if (error_msg != null) {
            throw new RuntimeException(error_msg);
        }
        System.exit(0);
    }

    static boolean processArgs(Args args, TzConvertParamsI params) throws Throwable {
        if (args == null) {
            return true;
        }
        while (args.more()) {
            if (args.ifMatch("")) continue;
            if (args.ifMatch("-h")) {
                Tzconvert.usage(null);
                continue;
            }
            if (args.ifMatch("--prodid")) {
                params.setProdid(args.next());
                continue;
            }
            if (args.ifMatch("--root")) {
                params.setRootdir(args.next());
                continue;
            }
            if (args.ifMatch("--start")) {
                params.setStartYear(Integer.valueOf(args.next()));
                continue;
            }
            if (args.ifMatch("--end")) {
                params.setEndYear(Integer.valueOf(args.next()));
                continue;
            }
            if (args.ifMatch("--generate")) {
                params.setGenerate(Boolean.valueOf(args.next()));
                continue;
            }
            if (args.ifMatch("--tzserver")) {
                params.setTzServerUri(args.next());
                params.setCompare(true);
                continue;
            }
            if (args.ifMatch("--comparewith")) {
                params.setCompareWithPath(args.next());
                params.setCompare(true);
                continue;
            }
            if (args.ifMatch("--verboseid")) {
                params.setVerboseId(args.next());
                continue;
            }
            if (args.ifMatch("--aliases")) {
                params.setAliasesPath(args.next());
                continue;
            }
            if (args.ifMatch("--source")) {
                params.setSource(args.next());
                continue;
            }
            Tzconvert.usage("Unrecognized option: " + args.current());
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        TzConvertParams params = new TzConvertParams();
        try {
            if (!Tzconvert.processArgs(new Args(args), params)) {
                return;
            }
            Processor proc = new Processor(params);
            proc.parse();
            if (params.getGenerate()) {
                proc.generateZoneinfoFiles(Util.buildPath((boolean)true, (String[])new String[]{params.getRootdir(), "/", "zoneinfo"}), true);
            }
            InfoLines msgs = new InfoLines();
            if (params.getCompare()) {
                proc.compare(msgs);
            }
            for (String msg : msgs) {
                System.out.print(msg);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

