/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.XProperty;
import org.bedework.timezones.convert.DateTime;
import org.bedework.timezones.convert.LineReader;
import org.bedework.timezones.convert.Rule;
import org.bedework.timezones.convert.RuleMapEntry;
import org.bedework.timezones.convert.RuleSet;
import org.bedework.timezones.convert.TzConvertParamsI;
import org.bedework.timezones.convert.Utils;
import org.bedework.timezones.convert.ZoneRule;
import org.bedework.util.misc.ToString;

class Zone {
    String name;
    private final List<ZoneRule> rules = new ArrayList<ZoneRule>();

    Zone() {
    }

    void parse(String line, LineReader.LineReaderIterator lri) {
        boolean first = true;
        String nextLine = line;
        while (nextLine != null) {
            List<String> splits;
            if (nextLine.length() == 0) {
                nextLine = lri.next();
                continue;
            }
            if (first) {
                this.name = Utils.untab(nextLine).get(1);
            }
            if ((splits = Utils.untab(nextLine)).size() == 0) {
                nextLine = lri.next();
                continue;
            }
            ZoneRule rule = new ZoneRule(this);
            boolean hasUntil = rule.parse(splits, nextLine, first);
            if (!rule.gmtoff.equals("#")) {
                this.rules.add(rule);
            }
            first = false;
            if (!hasUntil) {
                return;
            }
            nextLine = lri.next();
        }
    }

    List<ZoneExpandResult> expand(Map<String, RuleSet> ruleSets, TzConvertParamsI params) {
        DateTime start = new DateTime(params.getStartYear(), 1, 1, 0, 0, 0);
        int start_offset = this.rules.get(0).getUTCOffset();
        int start_stdoffset = this.rules.get(0).getUTCOffset();
        DateTime startdt = start.duplicate();
        ArrayList<ZoneRule.ExpandResult> transitions = new ArrayList<ZoneRule.ExpandResult>();
        DateTime lastUntilDateUTC = start.duplicate();
        Utils.Offsets lastOffsets = new Utils.Offsets(start_offset, start_stdoffset);
        boolean first = true;
        if (this.name.equals(params.getVerboseId())) {
            Utils.print("In %s", this.name);
        }
        ZoneRule lastZoneRule = null;
        for (ZoneRule zonerule : this.rules) {
            lastOffsets = zonerule.expand(ruleSets, transitions, lastUntilDateUTC, lastOffsets, lastZoneRule, params);
            lastZoneRule = zonerule;
            Utils.DateTimeWrapper lastUntilDate = zonerule.getUntilDate();
            lastUntilDateUTC = lastUntilDate.getUTC(lastOffsets);
            if (!first || this.rules.size() <= 1) continue;
            transitions.clear();
            first = false;
        }
        Collections.sort(transitions);
        ArrayList<ZoneExpandResult> results = new ArrayList<ZoneExpandResult>();
        ZoneExpandResult lastTransition = new ZoneExpandResult(startdt, start_offset, start_offset, null, null);
        for (ZoneRule.ExpandResult transition : transitions) {
            DateTime dtutc = transition.utc.getDt();
            DateTime dt = dtutc.duplicate();
            dt.offsetSeconds(lastTransition.offsetFrom);
            if (dtutc.getYear() >= params.getStartYear()) {
                if (dt.compareTo(lastTransition.transition) > 0) {
                    results.add(new ZoneExpandResult(dt, lastTransition.offsetFrom, transition.offset, transition.zonerule, transition.rule));
                } else if (results.size() > 0) {
                    ZoneExpandResult lastOne = results.get(results.size() - 1);
                    lastOne.offsetTo = transition.offset;
                    lastOne.zonerule = transition.zonerule;
                } else {
                    results.add(new ZoneExpandResult(lastTransition.transition, lastTransition.offsetFrom, lastTransition.offsetTo, transition.zonerule, null));
                }
            }
            lastTransition = new ZoneExpandResult(dt, transition.offset, lastTransition.offsetTo, lastTransition.zonerule, transition.rule);
        }
        return results;
    }

    VTimeZone vtimezone(Map<String, RuleSet> rules, TzConvertParamsI params) {
        VTimeZone vtz = new VTimeZone();
        PropertyList pl = vtz.getProperties();
        pl.add((Property)new TzId(this.name));
        pl.add((Property)new XProperty("X-LIC-LOCATION", this.name));
        List<ZoneExpandResult> transitions = this.expand(rules, params);
        ZoneRule lastZoneRule = null;
        ArrayList<Rule> ruleorder = new ArrayList<Rule>();
        HashMap<Rule, List<RuleMapEntry>> rulemap = new HashMap<Rule, List<RuleMapEntry>>();
        for (ZoneExpandResult expr : transitions) {
            if (!expr.zonerule.getFormat().equals("LMT")) {
                ArrayList<RuleMapEntry> lrme;
                if (lastZoneRule != null && !lastZoneRule.equals(expr.zonerule)) {
                    this.generateRuleData(vtz, lastZoneRule, ruleorder, rulemap);
                }
                if (!ruleorder.contains(expr.rule)) {
                    ruleorder.add(expr.rule);
                }
                if ((lrme = (ArrayList<RuleMapEntry>)rulemap.get(expr.rule)) == null) {
                    lrme = new ArrayList<RuleMapEntry>();
                    rulemap.put(expr.rule, lrme);
                }
                boolean standard = expr.rule == null ? true : expr.rule.isStandard();
                lrme.add(new RuleMapEntry(expr.transition, expr.offsetFrom, expr.offsetTo, standard));
            }
            lastZoneRule = expr.zonerule;
        }
        this.generateRuleData(vtz, lastZoneRule, ruleorder, rulemap);
        this.compressRDateComponents(vtz);
        return vtz;
    }

    private void generateRuleData(VTimeZone vtz, ZoneRule zonerule, List<Rule> ruleorder, Map<Rule, List<RuleMapEntry>> rulemap) {
        for (Rule rule : ruleorder) {
            List<RuleMapEntry> rme;
            if (rule != null) {
                rme = rulemap.get(rule);
                RuleMapEntry lastOffsetPair = rme.get(0);
                int startIndex = 0;
                for (int index = 1; index < rme.size(); ++index) {
                    RuleMapEntry offsetPair = rme.get(index);
                    if (offsetPair.offsetsEqual(lastOffsetPair)) continue;
                    RuleMapEntry startRme = rme.get(startIndex);
                    rule.vtimezone(vtz, zonerule, startRme.dt, rme.get((int)(index - 1)).dt, startRme.offsetFrom, startRme.offsetTo, index - startIndex);
                    lastOffsetPair = rme.get(index);
                    startIndex = index;
                }
                RuleMapEntry startRme = rme.get(startIndex);
                rule.vtimezone(vtz, zonerule, startRme.dt, rme.get((int)(rme.size() - 1)).dt, startRme.offsetFrom, startRme.offsetTo, rme.size());
                continue;
            }
            rme = rulemap.get(null);
            RuleMapEntry rme0 = rme.get(0);
            zonerule.vtimezone(vtz, rme0.dt, rme.get((int)(rme.size() - 1)).dt, rme0.offsetFrom, rme0.offsetTo, rme0.standard);
        }
        ruleorder.clear();
        rulemap.clear();
    }

    void compressRDateComponents(VTimeZone vtz) {
        HashMap<SimilarMapKey, ArrayList<Component>> similarMap = new HashMap<SimilarMapKey, ArrayList<Component>>();
        for (Object o : vtz.getObservances()) {
            Component comp = (Component)o;
            SimilarMapKey key = new SimilarMapKey(comp);
            if (comp.getProperty("RDATE") == null) continue;
            ArrayList<Component> comps = (ArrayList<Component>)similarMap.get(key);
            if (comps == null) {
                comps = new ArrayList<Component>();
                similarMap.put(key, comps);
            }
            comps.add(comp);
        }
        for (List values : similarMap.values()) {
            if (values.size() <= 1) continue;
            Component mergeTo = null;
            for (Component mergeFrom : values) {
                if (mergeTo == null) {
                    mergeTo = mergeFrom;
                    continue;
                }
                Property prop = mergeFrom.getProperty("RDATE");
                mergeTo.getProperties().add(prop);
                vtz.getObservances().remove((Object)mergeFrom);
            }
        }
    }

    public boolean equals(Object o) {
        Zone other = (Zone)o;
        return this.name.equals(other.name) && this.rules.equals(other.rules);
    }

    private class SimilarMapKey {
        private final Component comp;

        private SimilarMapKey(Component comp) {
            this.comp = comp;
        }

        public int hashCode() {
            int res = 1;
            if (this.comp instanceof Standard) {
                res = 2;
            }
            res *= this.propHash("TZNAME");
            res *= this.propHash("TZOFFSETTO");
            return res *= this.propHash("TZOFFSETFROM");
        }

        private int propHash(String name) {
            Property p = this.comp.getProperty(name);
            if (p == null) {
                return 1;
            }
            return p.getValue().hashCode();
        }

        public boolean equals(Object o) {
            Component that = ((SimilarMapKey)o).comp;
            return this.comp.getClass().equals(that.getClass()) && this.cmpProps(that, "TZNAME") && this.cmpProps(that, "TZOFFSETTO") && this.cmpProps(that, "TZOFFSETFROM");
        }

        private boolean cmpProps(Component that, String propName) {
            Property p = this.comp.getProperty(propName);
            Property thatp = that.getProperty(propName);
            return p.getValue().equals(thatp.getValue());
        }
    }

    static class ZoneExpandResult {
        DateTime transition;
        int offsetFrom;
        int offsetTo;
        ZoneRule zonerule;
        Rule rule;

        ZoneExpandResult(DateTime transition, int offsetFrom, int offsetTo, ZoneRule zonerule, Rule rule) {
            this.transition = transition;
            this.offsetFrom = offsetFrom;
            this.offsetTo = offsetTo;
            this.zonerule = zonerule;
            this.rule = rule;
        }

        public String toString() {
            ToString ts = new ToString((Object)this);
            ts.append("transition", (Object)this.transition);
            ts.append("offsetTo", this.offsetTo);
            ts.append("offsetFrom", this.offsetFrom);
            return ts.toString();
        }
    }
}

