/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import org.bedework.timezones.convert.Utils;
import org.bedework.util.misc.ToString;

public class DateTime
implements Comparable<DateTime> {
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    private int year = 1970;
    private int month;
    private int day;
    private boolean dateOnly = false;
    private int hours;
    private int minutes;
    private int seconds;
    private boolean isUtc;

    DateTime() {
    }

    public DateTime(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.dateOnly = true;
    }

    public DateTime(int year, int month, int day, int hours, int minutes, int seconds) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    void offsetSeconds(int val) {
        this.seconds += val;
        this.normalise();
    }

    void setTimezoneUTC(boolean val) {
        this.isUtc = val;
    }

    int getDayOfWeek() {
        int result = 4 + this.daysSince1970();
        if ((result %= 7) < 0) {
            result += 7;
        }
        return result;
    }

    void setDay(int val) {
        this.day = val;
    }

    int getDay() {
        return this.day;
    }

    void setMonth(int val) {
        this.month = val;
    }

    int getMonth() {
        return this.month;
    }

    void setYear(int val) {
        this.year = val;
    }

    int getYear() {
        return this.year;
    }

    void setHours(int val) {
        this.hours = val;
    }

    void setMinutes(int val) {
        this.minutes = val;
    }

    void setSeconds(int val) {
        this.seconds = val;
    }

    void setDayOfWeekInMonth(int offset, int dayNum) {
        this.day = 1;
        int firstDay = this.getDayOfWeek();
        if (offset > 0) {
            int cycle = (offset - 1) * 7 + dayNum;
            cycle -= firstDay;
            if (firstDay > dayNum) {
                cycle += 7;
            }
            this.day = cycle + 1;
        } else if (offset < 0) {
            int days_in_month = Utils.daysInMonth(this.month, this.year);
            firstDay += days_in_month - 1;
            int cycle = (-offset - 1) * 7 - dayNum;
            cycle += (firstDay %= 7);
            if (dayNum > firstDay) {
                cycle += 7;
            }
            this.day = days_in_month - cycle;
        }
        this.normalise();
    }

    void setNextDayOfWeek(int start, int dayNum) {
        if (this.year == 1944) {
            int n = this.year;
        }
        this.day = start;
        int first_day = this.getDayOfWeek();
        if (first_day > dayNum) {
            this.day += 7;
        }
        this.day += dayNum - first_day;
        this.normalise();
    }

    void normalise() {
        int normalised_secs = this.seconds % 60;
        int adjustment_mins = this.seconds / 60;
        if (normalised_secs < 0) {
            normalised_secs += 60;
            --adjustment_mins;
        }
        this.seconds = normalised_secs;
        this.minutes += adjustment_mins;
        int normalised_mins = this.minutes % 60;
        int adjustment_hours = this.minutes / 60;
        if (normalised_mins < 0) {
            normalised_mins += 60;
            --adjustment_hours;
        }
        this.minutes = normalised_mins;
        this.hours += adjustment_hours;
        int normalised_hours = this.hours % 24;
        int adjustment_days = this.hours / 24;
        if (normalised_hours < 0) {
            normalised_hours += 24;
            --adjustment_days;
        }
        this.hours = normalised_hours;
        this.day += adjustment_days;
        if (this.dateOnly) {
            this.hours = 0;
            this.minutes = 0;
            this.seconds = 0;
        }
        int normalised_month = (this.month - 1) % 12 + 1;
        int adjustment_year = (this.month - 1) / 12;
        if (normalised_month - 1 < 0) {
            normalised_month += 12;
            --adjustment_year;
        }
        this.month = normalised_month;
        this.year += adjustment_year;
        if (this.day > 0) {
            while (this.day > Utils.daysInMonth(this.month, this.year)) {
                this.day -= Utils.daysInMonth(this.month, this.year);
                ++this.month;
                if (this.month <= 12) continue;
                this.month = 1;
                ++this.year;
            }
        } else {
            while (this.day <= 0) {
                --this.month;
                if (this.month < 1) {
                    this.month = 12;
                    --this.year;
                }
                this.day += Utils.daysInMonth(this.month, this.year);
            }
        }
    }

    @Override
    public int compareTo(DateTime other) {
        int res = this.cmp(this.year, other.year);
        if (res != 0) {
            return res;
        }
        res = this.cmp(this.month, other.month);
        if (res != 0) {
            return res;
        }
        res = this.cmp(this.day, other.day);
        if (res != 0) {
            return res;
        }
        res = this.cmp(this.dateOnly, other.dateOnly);
        if (res != 0) {
            return res;
        }
        if (this.dateOnly) {
            return 0;
        }
        res = this.cmp(this.hours, other.hours);
        if (res != 0) {
            return res;
        }
        res = this.cmp(this.minutes, other.minutes);
        if (res != 0) {
            return res;
        }
        res = this.cmp(this.seconds, other.seconds);
        if (res != 0) {
            return res;
        }
        return this.cmp(this.isUtc, other.isUtc);
    }

    private int cmp(int a, int b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    private int cmp(boolean a, boolean b) {
        if (a) {
            if (!b) {
                return -1;
            }
            return 0;
        }
        if (b) {
            return 1;
        }
        return 0;
    }

    String localTime() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.year);
        sb.append(this.digits2(this.month));
        sb.append(this.digits2(this.day));
        if (!this.dateOnly) {
            sb.append("T");
            sb.append(this.digits2(this.hours));
            sb.append(this.digits2(this.minutes));
            sb.append(this.digits2(this.seconds));
        }
        return sb.toString();
    }

    String utcTime() {
        if (this.dateOnly) {
            return this.localTime();
        }
        return this.localTime() + "Z";
    }

    private String digits2(int value) {
        String s = String.valueOf(value);
        if (value < 10) {
            return "0" + s;
        }
        return s;
    }

    private int daysSince1970() {
        int result = (this.year - 1970) * 365;
        result += Utils.leapDaysSince1970(this.year - 1970);
        result += Utils.daysUptoMonth(this.month, this.year);
        return result += this.day - 1;
    }

    DateTime duplicate() {
        DateTime ndt = new DateTime();
        ndt.year = this.year;
        ndt.month = this.month;
        ndt.day = this.day;
        ndt.dateOnly = this.dateOnly;
        if (this.dateOnly) {
            return ndt;
        }
        ndt.hours = this.hours;
        ndt.minutes = this.minutes;
        ndt.seconds = this.seconds;
        ndt.isUtc = this.isUtc;
        return ndt;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        ts.append("year", this.year);
        ts.append("month", this.month);
        ts.append("day", this.day);
        ts.append("dayOfWeek", this.getDayOfWeek());
        ts.append("dateOnly", this.dateOnly);
        if (!this.dateOnly) {
            ts.append("hours", this.hours);
            ts.append("minutes", this.minutes);
            ts.append("seconds", this.seconds);
            ts.append("isUtc", this.isUtc);
        }
        return ts.toString();
    }
}

