/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import org.bedework.timezones.convert.Compare;
import org.bedework.timezones.convert.LineReader;
import org.bedework.timezones.convert.Rule;
import org.bedework.timezones.convert.RuleSet;
import org.bedework.timezones.convert.TzConvertParamsI;
import org.bedework.timezones.convert.Utils;
import org.bedework.timezones.convert.Zone;
import org.bedework.util.jmx.InfoLines;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.FileTzFetcher;
import org.bedework.util.timezones.ServerTzFetcher;
import org.bedework.util.timezones.TzFetcher;

class Processor {
    private final TzConvertParamsI params;
    private final Map<String, RuleSet> rules = new HashMap<String, RuleSet>();
    private final Map<String, Zone> zones = new HashMap<String, Zone>();
    private final Map<String, String> links = new HashMap<String, String>();
    private final Map<String, VTimeZone> vtzs = new HashMap<String, VTimeZone>();
    private boolean vtzsBuilt;
    private boolean verbose;
    private List<String> filterzones;
    private static final String[] zonefiles = new String[]{"northamerica", "southamerica", "europe", "africa", "asia", "australasia", "antarctica", "etcetera", "backward"};

    public Processor(TzConvertParamsI params) {
        this.params = params;
    }

    Set<String> getZoneNames() {
        return this.zones.keySet();
    }

    public void parse() {
        String zonedir = Util.buildPath((boolean)true, (String[])new String[]{this.params.getRootdir(), "/", "tzdata"});
        for (String file : zonefiles) {
            this.parseFile(Util.buildPath((boolean)true, (String[])new String[]{zonedir, "/", file}));
        }
    }

    List<Zone.ZoneExpandResult> expandZone(String zonename, TzConvertParamsI params) {
        Zone zone = this.zones.get(zonename);
        return zone.expand(this.rules, params);
    }

    public String vtimezones(TzConvertParamsI params) {
        Calendar cal = new Calendar();
        for (Zone zone : this.zones.values()) {
            if (this.filterzones != null && !this.filterzones.contains(zone.name)) continue;
            VTimeZone vtz = zone.vtimezone(this.rules, params);
            cal.getComponents().add((Object)vtz);
        }
        return cal.toString();
    }

    public void generateZoneinfoFiles(String outputdir, boolean doLinks) throws Throwable {
        this.buildVtzs();
        Utils.empty(outputdir);
        for (String zoneName : this.vtzs.keySet()) {
            Calendar cal = new Calendar();
            ComponentList cl = cal.getComponents();
            PropertyList pl = cal.getProperties();
            pl.add((Property)Version.VERSION_2_0);
            pl.add((Property)new ProdId(this.params.getProdid()));
            cl.add((Object)this.vtzs.get(zoneName));
            String icsdata = cal.toString();
            Path fpath = Utils.createFile(Util.buildPath((boolean)false, (String[])new String[]{outputdir, "/", zoneName, ".ics"}));
            OutputStream os = Files.newOutputStream(fpath, new OpenOption[0]);
            os.write(icsdata.getBytes());
            os.close();
            if (!this.verbose) continue;
            Utils.print("Write path: %s", fpath);
        }
        this.generateInfo(outputdir);
        if (!doLinks) {
            return;
        }
        this.generateLinks(outputdir);
    }

    public void compare(InfoLines msgs) {
        try {
            if (this.params.getTzServerUri() != null) {
                ServerTzFetcher tzFetcher = new ServerTzFetcher(this.params.getTzServerUri());
                this.compare((TzFetcher)tzFetcher, msgs);
                return;
            }
            if (this.params.getCompareWithPath() != null) {
                FileTzFetcher tzFetcher = new FileTzFetcher(this.params.getCompareWithPath());
                this.compare((TzFetcher)tzFetcher, msgs);
                return;
            }
        }
        catch (Throwable t) {
            msgs.exceptionMsg(t);
            return;
        }
        msgs.addLn("No comparison data source");
    }

    public void compare(TzFetcher tzFetcher, InfoLines msgs) {
        this.buildVtzs();
        new Compare().compare(this.vtzs, tzFetcher, msgs, this.params.getVerboseId());
    }

    private void buildVtzs() {
        if (this.vtzsBuilt) {
            return;
        }
        for (Zone zone : this.zones.values()) {
            if (this.filterzones != null && !this.filterzones.contains(zone.name)) continue;
            VTimeZone vtz = zone.vtimezone(this.rules, this.params);
            this.vtzs.put(zone.name, vtz);
        }
        this.vtzsBuilt = true;
    }

    private void parseFile(String file) {
        try {
            String line;
            LineReader f = new LineReader(file);
            LineReader.LineReaderIterator lri = (LineReader.LineReaderIterator)f.iterator();
            while (lri.hasNext() && (line = lri.next()) != null) {
                if (line.startsWith("#") || line.length() == 0) continue;
                if (line.startsWith("Rule")) {
                    this.parseRule(line);
                    continue;
                }
                if (line.startsWith("Zone")) {
                    this.parseZone(line, lri);
                    continue;
                }
                if (line.startsWith("Link")) {
                    this.parseLink(line);
                    continue;
                }
                if (line.trim().length() == 0) continue;
                Utils.assertion(false, "Could not parse line %d from file %s: '%s'", f.lineNbr, file, line);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Utils.assertion(false, "Failed to parse file %s", file);
        }
    }

    private void parseRule(String line) {
        Rule ruleitem = new Rule();
        ruleitem.parse(line);
        RuleSet rs = this.rules.get(ruleitem.name);
        if (rs == null) {
            rs = new RuleSet();
            this.rules.put(ruleitem.name, rs);
        }
        rs.add(ruleitem);
    }

    private void parseZone(String line, LineReader.LineReaderIterator lri) {
        Zone zoneitem = new Zone();
        zoneitem.parse(line, lri);
        this.zones.put(zoneitem.name, zoneitem);
    }

    private void parseLink(String line) {
        List<String> fields = Utils.untab(line);
        this.links.put(fields.get(2), fields.get(1));
    }

    private void generateLinks(String outputdir) throws Throwable {
        Properties aliases = new Properties();
        aliases.load(this.getFileRdr(this.params.getAliasesPath()));
        for (Object object : aliases.keySet()) {
            this.links.put((String)object, aliases.getProperty((String)object));
        }
        ArrayList<CallSite> linkList = new ArrayList<CallSite>();
        for (String linkTo : this.links.keySet()) {
            String linkFrom = this.links.get(linkTo);
            String fromPath = Util.buildPath((boolean)false, (String[])new String[]{outputdir, "/", linkFrom, ".ics"});
            if (!new File(fromPath).exists()) {
                Utils.print("Missing link from: %s to %s", linkFrom, linkTo);
                continue;
            }
            ArrayList<String> contents = new ArrayList<String>();
            LineReader lr = new LineReader(fromPath);
            for (String s : lr) {
                contents.add(s.replace(linkFrom, linkTo));
            }
            String toPath = Util.buildPath((boolean)false, (String[])new String[]{outputdir, "/", linkTo, ".ics"});
            Path outPath = Utils.createFile(toPath);
            OutputStream os = Files.newOutputStream(outPath, new OpenOption[0]);
            for (String s : contents) {
                os.write(s.getBytes());
                os.write(10);
            }
            os.close();
            if (this.verbose) {
                Utils.print("Write link: %s", linkTo);
            }
            linkList.add((CallSite)((Object)(linkTo + "\t" + linkFrom)));
        }
        Collections.sort(linkList);
        String string = Util.buildPath((boolean)false, (String[])new String[]{outputdir, "/", "aliases.properties"});
        Path outPath = Utils.createFile(string);
        OutputStream os = Files.newOutputStream(outPath, new OpenOption[0]);
        aliases.store(os, "# Timezone aliases file");
        os.close();
    }

    private void generateInfo(String outputdir) throws Throwable {
        Properties info = new Properties();
        DtStamp dtStamp = new DtStamp();
        info.setProperty("buildTime", dtStamp.getValue());
        info.setProperty("prodid", this.params.getProdid());
        info.setProperty("source", this.params.getSource());
        String toPath = Util.buildPath((boolean)false, (String[])new String[]{outputdir, "/", "info.properties"});
        Path outPath = Utils.createFile(toPath);
        OutputStream os = Files.newOutputStream(outPath, new OpenOption[0]);
        info.store(os, "# Timezone server info file");
        os.close();
    }

    private FileReader getFileRdr(String path) throws Throwable {
        File theFile = new File(path);
        if (!theFile.exists() || !theFile.isFile()) {
            throw new Exception(path + " does not exist or is not a file");
        }
        return new FileReader(theFile);
    }
}

