/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.timezones.convert.DateTime;
import org.bedework.util.logging.BwLogger;

class Utils {
    private static BwLogger logger = new BwLogger().setLoggedClass(Utils.class);
    static final Map<Integer, Integer> leapDaysMap = new HashMap<Integer, Integer>();
    static final int[] daysUptoMonth = new int[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    static final int[] daysUptoMonthLeap = new int[]{0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final Map<Integer, Boolean> leapYears = new HashMap<Integer, Boolean>();

    Utils() {
    }

    static int daysInMonth(int month, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        return calendar.getActualMaximum(5);
    }

    static List<String> untab(String s) {
        String s1 = s.replaceAll("\t", " ");
        return Utils.split(s1);
    }

    static List<String> split(String s) {
        ArrayList<String> res = new ArrayList<String>();
        int len1 = s.length();
        String s1 = s;
        while (true) {
            String s2 = s1.replace("  ", " ");
            int len2 = s2.length();
            s1 = s2;
            if (len2 == len1) break;
            len1 = len2;
        }
        for (String split : s1.split(" ")) {
            if (split.length() <= 0) continue;
            if (split.startsWith("#")) break;
            res.add(split);
        }
        return res;
    }

    public static Path createFile(String path) throws Throwable {
        Path pathToFile = Paths.get(path, new String[0]);
        Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
        return Files.createFile(pathToFile, new FileAttribute[0]);
    }

    public static boolean empty(String path) {
        return Utils.delete(new File(path), false);
    }

    public static boolean delete(File file, boolean deleteThis) {
        if (file == null) {
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] flist = file.listFiles();
        if (flist != null && flist.length > 0) {
            for (File f : flist) {
                if (Utils.delete(f, true)) continue;
                return false;
            }
        }
        if (!deleteThis) {
            return true;
        }
        return file.delete();
    }

    static String formatTzname(String format, String letter, boolean standard) {
        if (format.contains("/")) {
            String[] splitTzname = format.split("/");
            if (standard) {
                return splitTzname[0];
            }
            return splitTzname[1];
        }
        if (!format.contains("%")) {
            return format;
        }
        Formatter f = new Formatter();
        String param = letter.equals("-") ? "" : letter;
        return f.format(format, param).toString();
    }

    static void print(String fmt, Object ... params) {
        Formatter f = new Formatter();
        logger.info(f.format(fmt, params).toString());
    }

    static void assertion(boolean test, String fmt, Object ... params) {
        if (test) {
            return;
        }
        Formatter f = new Formatter();
        throw new RuntimeException(f.format(fmt, params).toString());
    }

    static int getInt(String val) {
        try {
            return Integer.valueOf(val);
        }
        catch (Throwable ignored) {
            throw new RuntimeException("Failed to parse as Integer " + val);
        }
    }

    static int leapDaysSince1970(int yearOffset) {
        Integer r = leapDaysMap.get(yearOffset);
        if (r != null) {
            return r;
        }
        int result = yearOffset > 2 ? (yearOffset + 1) / 4 : (yearOffset < -1 ? (yearOffset - 2) / 4 : 0);
        leapDaysMap.put(yearOffset, result);
        return result;
    }

    static int daysUptoMonth(int month, int year) {
        if (Utils.isLeapYear(year)) {
            return daysUptoMonthLeap[month];
        }
        return daysUptoMonth[month];
    }

    static boolean isLeapYear(int year) {
        Boolean b = leapYears.get(year);
        if (b != null) {
            return b;
        }
        boolean result = year <= 1752 ? year % 4 == 0 : year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        leapYears.put(year, result);
        return result;
    }

    static class DateTimeWrapper
    implements Comparable<DateTimeWrapper> {
        private final DateTime dt;
        private final String mode;

        DateTimeWrapper(DateTime dt, String mode) {
            this.dt = dt;
            this.mode = mode;
        }

        DateTime getDt() {
            return this.dt;
        }

        DateTimeWrapper duplicate() {
            return new DateTimeWrapper(this.dt.duplicate(), this.mode);
        }

        DateTime getLocaltime(Offsets offsets) {
            DateTime newDt = this.dt.duplicate();
            if (this.mode == null) {
                return newDt;
            }
            switch (this.mode) {
                case "u": {
                    newDt.offsetSeconds(offsets.offset);
                    break;
                }
                case "s": {
                    newDt.offsetSeconds(-offsets.stdoffset + offsets.offset);
                    break;
                }
                default: {
                    throw new RuntimeException("Bad mode");
                }
            }
            return newDt;
        }

        DateTime getUTC(Offsets offsets) {
            DateTime newDt = this.dt.duplicate();
            if (this.mode == null) {
                newDt.offsetSeconds(-offsets.offset);
            } else {
                if (this.mode.equals("u")) {
                    return newDt;
                }
                if (this.mode.equals("s")) {
                    newDt.offsetSeconds(-offsets.stdoffset);
                } else {
                    throw new RuntimeException("Bad mode");
                }
            }
            return newDt;
        }

        @Override
        public int compareTo(DateTimeWrapper o) {
            return this.dt.compareTo(o.dt);
        }
    }

    static class Offsets {
        int offset;
        int stdoffset;

        Offsets(int offset, int stdoffset) {
            this.offset = offset;
            this.stdoffset = stdoffset;
        }
    }
}

