/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.convert;

import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.UtcOffset;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.TzName;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import org.bedework.timezones.convert.DateTime;
import org.bedework.timezones.convert.Rule;
import org.bedework.timezones.convert.RuleSet;
import org.bedework.timezones.convert.TzConvertParamsI;
import org.bedework.timezones.convert.Utils;
import org.bedework.timezones.convert.Zone;
import org.bedework.util.misc.ToString;
import org.bedework.util.misc.Util;

class ZoneRule {
    private Zone zone;
    String gmtoff;
    private String rule;
    private String format;
    private String until;
    private Utils.DateTimeWrapper cached_until;
    private Integer cached_utc_offset;

    ZoneRule(Zone zone) {
        this.zone = zone;
    }

    boolean parse(List<String> splits, String line, boolean zoneLine) {
        int offset = zoneLine ? 2 : 0;
        Utils.assertion(splits.size() - offset >= 3, "Help: %s", line);
        this.gmtoff = splits.get(0 + offset);
        this.rule = splits.get(1 + offset);
        this.format = splits.get(2 + offset);
        if (splits.size() - offset < 4) {
            return false;
        }
        this.until = "";
        String delim = " ";
        for (int i = 3 + offset; i < splits.size(); ++i) {
            this.until = this.until + splits.get(i) + delim;
            delim = " ";
        }
        return true;
    }

    public String getFormat() {
        return this.format;
    }

    String generate() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gmtoff);
        sb.append("t");
        sb.append(this.rule);
        sb.append("t");
        sb.append(this.format);
        if (this.until != null) {
            sb.append("t");
            sb.append(this.until);
        }
        return sb.toString();
    }

    Utils.DateTimeWrapper getUntilDate() {
        if (this.cached_until != null) {
            return this.cached_until;
        }
        int year = 9999;
        int month = 12;
        int day = 1;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        String mode = null;
        if (this.until != null && !this.until.startsWith("#")) {
            List<String> splits = Utils.split(this.until);
            year = Utils.getInt(splits.get(0));
            month = 1;
            day = 1;
            hours = 0;
            minutes = 0;
            seconds = 0;
            mode = null;
            if (splits.size() > 1 && !splits.get(1).startsWith("#")) {
                month = Rule.MONTH_NAME_TO_POS.get(splits.get(1));
                if (splits.size() > 2 && !splits.get(2).startsWith("#")) {
                    switch (splits.get(2)) {
                        case "lastSun": {
                            DateTime dt = new DateTime(year, month, 1);
                            dt.setDayOfWeekInMonth(-1, 0);
                            day = dt.getDay();
                            break;
                        }
                        case "lastSat": {
                            DateTime dt = new DateTime(year, month, 1);
                            dt.setDayOfWeekInMonth(-1, 6);
                            day = dt.getDay();
                            break;
                        }
                        case "Sun>=1": {
                            DateTime dt = new DateTime(year, month, 1);
                            dt.setDayOfWeekInMonth(1, 0);
                            day = dt.getDay();
                            break;
                        }
                        default: {
                            day = Integer.valueOf(splits.get(2));
                        }
                    }
                    if (splits.size() > 3 && !splits.get(3).startsWith("#")) {
                        String[] splits2 = splits.get(3).split(":");
                        hours = Integer.valueOf(splits2[0]);
                        minutes = Integer.valueOf(splits2[1].substring(0, 2));
                        if (splits2[1].length() > 2) {
                            mode = splits2[1].substring(2);
                        }
                        if (splits2.length > 2) {
                            seconds = Integer.valueOf(splits2[2]);
                        }
                    }
                }
            }
        }
        DateTime dt = new DateTime(year, month, day, hours, minutes, seconds);
        this.cached_until = new Utils.DateTimeWrapper(dt, mode);
        return this.cached_until;
    }

    Integer getUTCOffset() {
        if (this.cached_utc_offset != null) {
            return this.cached_utc_offset;
        }
        String[] splits = this.gmtoff.split(":");
        int hours = this.posint(splits, 0);
        int minutes = this.posint(splits, 1);
        int seconds = this.posint(splits, 2);
        boolean negative = splits[0].startsWith("-");
        this.cached_utc_offset = (hours * 60 + minutes) * 60 + seconds;
        if (negative) {
            this.cached_utc_offset = -this.cached_utc_offset.intValue();
        }
        return this.cached_utc_offset;
    }

    private int posint(String[] splits, int i) {
        if (splits.length <= i) {
            return 0;
        }
        return Math.abs(Integer.valueOf(splits[i]));
    }

    Utils.Offsets expand(Map<String, RuleSet> rules, List<ExpandResult> results, DateTime lastUntilUTC, Utils.Offsets lastOffsets, ZoneRule lastZoneRule, TzConvertParamsI params) {
        boolean isTime;
        boolean bl = isTime = Character.getType(this.rule.charAt(0)) == 9 || this.rule.length() > 1 && this.rule.charAt(0) == '-' && Character.getType(this.rule.charAt(1)) == 9;
        if (this.rule.equals("-") || isTime) {
            return this.expandNorule(results, lastUntilUTC);
        }
        RuleSet ruleset = rules.get(this.rule);
        Utils.assertion(ruleset != null, "No rule '%s' found in cache. %s for %s", this.rule, this, this.zone);
        assert (ruleset != null);
        List<Rule.DateOffset> tempresults = ruleset.expand(this, params.getEndYear());
        Collections.sort(tempresults);
        boolean found_one = false;
        boolean foundStart = false;
        Utils.Offsets resOffsets = new Utils.Offsets(lastOffsets.offset, lastOffsets.stdoffset);
        Utils.DateTimeWrapper finalUntil = this.getUntilDate();
        for (Rule.DateOffset doffset : tempresults) {
            DateTime dtutc = doffset.dt.getUTC(resOffsets);
            int cmp = dtutc.compareTo(lastUntilUTC);
            if (cmp >= 0) {
                if (!foundStart && cmp != 0) {
                    if (!found_one) {
                        resOffsets.offset = this.getUTCOffset();
                        resOffsets.stdoffset = this.getUTCOffset();
                        dtutc = doffset.dt.getUTC(resOffsets);
                    }
                    ZoneRule inForce = lastZoneRule == null ? this : lastZoneRule;
                    results.add(new ExpandResult(new Utils.DateTimeWrapper(lastUntilUTC, null), resOffsets.offset, inForce, null));
                }
                foundStart = true;
                if (dtutc.compareTo(finalUntil.getUTC(resOffsets)) >= 0) break;
                results.add(new ExpandResult(new Utils.DateTimeWrapper(dtutc, null), doffset.offset, this, doffset.rule));
            }
            resOffsets.offset = doffset.offset;
            resOffsets.stdoffset = this.getUTCOffset();
            found_one = true;
        }
        if (!foundStart) {
            results.add(new ExpandResult(new Utils.DateTimeWrapper(lastUntilUTC, null), resOffsets.offset, this, null));
        }
        return resOffsets;
    }

    Utils.Offsets expandNorule(List<ExpandResult> results, DateTime lastUntil) {
        int to_offset = 0;
        if (!this.rule.equals("-")) {
            String ruleNoMinus;
            boolean neg;
            if (this.rule.startsWith("-")) {
                neg = true;
                ruleNoMinus = this.rule.substring(1);
            } else {
                neg = false;
                ruleNoMinus = this.rule;
            }
            String[] splits = ruleNoMinus.split(":");
            to_offset = 3600 * Integer.valueOf(splits[0]);
            if (splits.length > 1) {
                to_offset += 60 * Integer.valueOf(splits[1]);
            }
            if (neg) {
                to_offset = -to_offset;
            }
        }
        results.add(new ExpandResult(new Utils.DateTimeWrapper(lastUntil, null), this.getUTCOffset() + to_offset, this, null));
        return new Utils.Offsets(this.getUTCOffset() + to_offset, this.getUTCOffset());
    }

    void vtimezone(VTimeZone vtz, DateTime start, DateTime end, int offsetfrom, int offsetto, boolean standard) {
        String tzname;
        Object comp = standard ? new Standard() : new Daylight();
        PropertyList pl = comp.getProperties();
        if (this.format.contains("%s")) {
            tzname = this.format.replace("%s", "S");
        } else if (this.format.contains("/")) {
            String[] splitTzname = this.format.split("/");
            tzname = standard ? splitTzname[0] : splitTzname[1];
        } else {
            tzname = this.format;
        }
        pl.add((Property)new TzName(tzname));
        pl.add((Property)new TzOffsetFrom(new UtcOffset((long)(offsetfrom * 1000))));
        pl.add((Property)new TzOffsetTo(new UtcOffset((long)(offsetto * 1000))));
        try {
            pl.add((Property)new DtStart(start.localTime()));
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        vtz.getObservances().add((Object)((Observance)comp));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        ZoneRule other = (ZoneRule)o;
        return Util.equalsString((String)this.gmtoff, (String)other.gmtoff) && Util.equalsString((String)this.rule, (String)other.rule) && Util.equalsString((String)this.format, (String)other.format) && Util.equalsString((String)this.until, (String)other.until);
    }

    static class ExpandResult
    implements Comparable<ExpandResult> {
        Utils.DateTimeWrapper utc;
        int offset;
        ZoneRule zonerule;
        Rule rule;

        ExpandResult(Utils.DateTimeWrapper utc, int offset, ZoneRule zonerule, Rule rule) {
            this.utc = utc;
            this.offset = offset;
            this.zonerule = zonerule;
            this.rule = rule;
        }

        @Override
        public int compareTo(ExpandResult o) {
            return this.utc.compareTo(o.utc);
        }

        public String toString() {
            ToString ts = new ToString((Object)this);
            ts.append("utc", (Object)this.utc);
            ts.append("offset", this.offset);
            return ts.toString();
        }
    }
}

