/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.timezones.server;

import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bedework.timezones.common.ExpandedMapEntry;
import org.bedework.timezones.common.Stat;
import org.bedework.timezones.common.TzServerUtil;
import org.bedework.timezones.server.CapabilitiesHandler;
import org.bedework.timezones.server.ListHandler;
import org.bedework.timezones.server.MethodBase;
import org.bedework.timezones.server.TzidHandler;

public class GetMethod
extends MethodBase {
    private static final CapabilitiesHandler capabilities;
    private static final ListHandler lists;
    private static final TzidHandler tzids;
    private static final String tzsEl = "timezones";
    private static final String capabilitiesEl = "capabilities";
    private static final String zonesEl = "zones";
    private static final String observancesEl = "observances";
    private static final String namesReqPar = "names";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doMethod(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        MethodBase.ResourceUri ruri = this.getResourceUri(req);
        long start = System.currentTimeMillis();
        if (this.debug()) {
            this.debug("GetMethod: doMethod  path=" + ruri.uri);
        }
        try {
            if (req.getParameter(namesReqPar) != null) {
                if (this.ifNoneMatchTest(req, resp)) {
                    return;
                }
                this.doNames(resp);
                return;
            }
            if (ruri.uriElements.size() == 0) {
                return;
            }
            String el0 = ruri.getPathElement(0);
            if (el0.equals(capabilitiesEl)) {
                capabilities.doMethod(req, resp);
                return;
            }
            int dataPrefixElements = this.dataPrefixElements(ruri);
            String el = ruri.getPathElement(dataPrefixElements);
            if (el == null) {
                return;
            }
            if (el.equals(zonesEl)) {
                this.doZones(req, resp, ruri, dataPrefixElements);
                return;
            }
            if (el.equals(observancesEl)) {
                this.doExpand(req, resp, ruri, dataPrefixElements);
            }
        }
        finally {
            if (this.debug()) {
                this.debug("GET exit. Took " + TzServerUtil.printableTime((long)(System.currentTimeMillis() - start)));
            }
        }
    }

    private int dataPrefixElements(MethodBase.ResourceUri ruri) {
        return 0;
    }

    private void doAction(HttpServletRequest req, HttpServletResponse resp, String action) throws ServletException {
        if (capabilitiesEl.equals(action)) {
            capabilities.doMethod(req, resp);
            return;
        }
        if ("list".equals(action)) {
            lists.doMethod(req, resp);
            return;
        }
        if ("expand".equals(action)) {
            this.doExpand(req, resp, null, 0);
            return;
        }
        if ("get".equals(action)) {
            tzids.doMethod(req, resp);
            return;
        }
        if ("find".equals(action)) {
            this.doFind(req, resp, req.getParameter("name"));
        }
    }

    private void doZones(HttpServletRequest req, HttpServletResponse resp, MethodBase.ResourceUri ruri, int dataPrefixSize) throws ServletException {
        if (req.getParameter("pattern") != null) {
            this.doFind(req, resp, req.getParameter("pattern"));
            return;
        }
        String tzid = ruri.getElements(dataPrefixSize + 1);
        if (tzid == null) {
            lists.doMethod(req, resp);
            return;
        }
        if (!tzid.endsWith("/observances")) {
            tzids.doTzid(resp, tzid);
            return;
        }
        int len = tzid.lastIndexOf("/");
        this.doExpand(req, resp, tzid.substring(0, len));
    }

    private void doFind(HttpServletRequest req, HttpServletResponse resp, String pattern) throws ServletException {
        try {
            if (pattern == null) {
                resp.setStatus(404);
                return;
            }
            this.listResponse(resp, this.util.findTimezones(pattern));
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void doExpand(HttpServletRequest req, HttpServletResponse resp, MethodBase.ResourceUri ruri, int dataPrefixSize) throws ServletException {
        try {
            resp.setContentType("application/json; charset=UTF-8");
            String tzid = ruri == null ? req.getParameter("tzid") : ruri.getElements(dataPrefixSize + 1);
            if (tzid == null) {
                this.errorResponse(resp, 400, missingTzid);
                return;
            }
            String start = req.getParameter("start");
            String end = req.getParameter("end");
            String changedsince = req.getParameter("changedsince");
            ExpandedMapEntry tzs = this.util.getExpanded(tzid, start, end, ruri == null);
            if (tzs == null) {
                this.errorResponse(resp, 404, missingTzid);
                return;
            }
            resp.setHeader("ETag", tzs.getEtag());
            this.writeJson(resp, tzs.getTzs());
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void doExpand(HttpServletRequest req, HttpServletResponse resp, String tzid) throws ServletException {
        try {
            String end;
            resp.setContentType("application/json; charset=UTF-8");
            if (tzid == null) {
                this.errorResponse(resp, 400, missingTzid);
                return;
            }
            String start = req.getParameter("start");
            ExpandedMapEntry tzs = this.util.getExpanded(tzid, start, end = req.getParameter("end"), false);
            if (tzs == null) {
                this.errorResponse(resp, 404, missingTzid);
                return;
            }
            resp.setHeader("ETag", tzs.getEtag());
            this.writeJson(resp, tzs.getTzs());
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void doNames(HttpServletResponse resp) throws ServletException {
        try {
            resp.setContentType("text/plain; charset=UTF-8");
            resp.setHeader("ETag", this.util.getEtag());
            PrintWriter wtr = resp.getWriter();
            for (String s : this.util.getNames()) {
                ((Writer)wtr).write(s);
                ((Writer)wtr).write("\n");
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void doStats(HttpServletResponse resp) throws ServletException {
        try {
            resp.setContentType("text/html; charset=UTF-8");
            PrintWriter wtr = resp.getWriter();
            ((Writer)wtr).write("<html>\r\n");
            ((Writer)wtr).write("  <head>\r\n");
            ((Writer)wtr).write("    <title>Timezone server statistics</title>\r\n");
            ((Writer)wtr).write("</head>\r\n");
            ((Writer)wtr).write("<body>\r\n");
            ((Writer)wtr).write("    <h1>Timezone server statistics</title></h1>\r\n");
            ((Writer)wtr).write("  <hr/>\r\n");
            ((Writer)wtr).write("  <table width=\"30%\" cellspacing=\"0\" cellpadding=\"4\">\r\n");
            for (Stat s : TzServerUtil.getStats()) {
                this.statLine(wtr, s.getName(), s.getValue1(), s.getValue2());
            }
            ((Writer)wtr).write("</table>\r\n");
            ((Writer)wtr).write("</body>\r\n");
            ((Writer)wtr).write("</html>\r\n");
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void doAliases(HttpServletResponse resp) throws ServletException {
        try {
            resp.setHeader("ETag", this.util.getEtag());
            resp.setContentType("text/plain; charset=UTF-8");
            PrintWriter wtr = resp.getWriter();
            ((Writer)wtr).write(this.util.getAliasesStr());
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void doInfo(HttpServletResponse resp) throws ServletException {
        try {
            resp.setHeader("ETag", this.util.getEtag());
            resp.setContentType("text/html; charset=UTF-8");
            PrintWriter wtr = resp.getWriter();
            ((Writer)wtr).write("<html>\r\n");
            ((Writer)wtr).write("  <head>\r\n");
            ((Writer)wtr).write("    <title>Timezone server information</title>\r\n");
            ((Writer)wtr).write("</head>\r\n");
            ((Writer)wtr).write("<body>\r\n");
            ((Writer)wtr).write("    <h1>Timezone server information</title></h1>\r\n");
            ((Writer)wtr).write("  <hr/>\r\n");
            ((Writer)wtr).write("  <table width=\"30%\" cellspacing=\"0\" cellpadding=\"4\">\r\n");
            this.infoLine(wtr, "dtstamp", this.util.getDtstamp());
            ((Writer)wtr).write("</table>\r\n");
            ((Writer)wtr).write("</body>\r\n");
            ((Writer)wtr).write("</html>\r\n");
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void infoLine(Writer wtr, String name, String val) throws Throwable {
        wtr.write("<tr>\r\n");
        wtr.write("  <td align=\"right\">");
        wtr.write(name);
        wtr.write("</td>");
        wtr.write("  <td align=\"right\">");
        wtr.write(val);
        wtr.write("</td>");
        wtr.write("</tr>\r\n");
    }

    private void statLine(Writer wtr, String name, String val, String millis) throws Throwable {
        wtr.write("<tr>\r\n");
        wtr.write("  <td align=\"right\">");
        wtr.write(name);
        wtr.write("</td>");
        wtr.write("  <td align=\"right\">");
        wtr.write(String.valueOf(val));
        wtr.write("</td>");
        wtr.write("<td>");
        if (millis == null) {
            wtr.write("&nbsp;");
        } else {
            Object s = millis;
            while (((String)s).length() < 4) {
                s = "0" + (String)s;
            }
            wtr.write(((String)s).substring(0, ((String)s).length() - 3));
            wtr.write(".");
            wtr.write(((String)s).substring(((String)s).length() - 3));
            wtr.write(" seconds");
        }
        wtr.write("</td>");
        wtr.write("</td>\r\n");
        wtr.write("</tr>\r\n");
    }

    private void doConvert(HttpServletResponse resp, String dateTime, String fromTzid, String toTzid) throws ServletException {
        try {
            PrintWriter wtr = resp.getWriter();
            String cnvDdateTime = this.util.convertDateTime(dateTime, fromTzid, toTzid);
            if (cnvDdateTime != null) {
                ((Writer)wtr).write(cnvDdateTime);
            } else {
                resp.setStatus(404);
            }
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private void doToUtc(HttpServletResponse resp, String dateTime, String fromTzid) throws ServletException {
        try {
            PrintWriter wtr = resp.getWriter();
            String cnvDdateTime = this.util.getUtc(dateTime, fromTzid);
            if (cnvDdateTime != null) {
                ((Writer)wtr).write(cnvDdateTime);
            } else {
                resp.setStatus(404);
            }
        }
        catch (ServletException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private boolean ifNoneMatchTest(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            String inEtag = req.getHeader("If-None-Match");
            if (inEtag == null) {
                return false;
            }
            if (!inEtag.equals(this.util.getEtag())) {
                return false;
            }
            resp.setStatus(304);
            return true;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    static {
        try {
            capabilities = new CapabilitiesHandler();
            lists = new ListHandler();
            tzids = new TzidHandler();
        }
        catch (ServletException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

