/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.directory.common;

import java.io.Serializable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;

public abstract class DirRecord
implements Serializable {
    private String name;
    private String dn;
    private boolean isContentRec = true;
    private int changeType = 0;
    public static final int changeTypeInvalid = 0;
    public static final int changeTypeAdd = 1;
    public static final int changeTypeDelete = 2;
    public static final int changeTypeModify = 3;
    public static final int changeTypeModdn = 4;

    public abstract Attributes getAttributes() throws NamingException;

    public Attribute findAttr(String attr) throws NamingException {
        return this.getAttributes().get(attr);
    }

    public void setAttr(String attr, Object val) throws NamingException {
        this.getAttributes().put(attr, val);
    }

    public void clear() {
        this.dn = null;
        this.isContentRec = true;
        this.changeType = 0;
    }

    public void setName(String val) throws NamingException {
        this.name = val;
    }

    public String getName() throws Throwable {
        return this.name;
    }

    public void setDn(String val) throws NamingException {
        this.dn = val;
    }

    public String getDn() throws NamingException {
        return this.dn;
    }

    public boolean equals(DirRecord that) throws NamingException {
        if (!this.dnEquals(that)) {
            return false;
        }
        Attributes thisAttrs = this.getAttributes();
        Attributes thatAttrs = that.getAttributes();
        if (thisAttrs == null) {
            return thatAttrs == null;
        }
        if (thatAttrs == null) {
            return false;
        }
        return thisAttrs.equals(thatAttrs);
    }

    public boolean equals(DirRecord that, String[] thisAttrIDs, String[] thatAttrIDs) throws NamingException {
        if (thisAttrIDs == null || thatAttrIDs == null) {
            throw new NamingException("DirectoryRecord: null attrID list");
        }
        if (thisAttrIDs.length != thatAttrIDs.length) {
            throw new NamingException("DirectoryRecord: unequal length attrID lists");
        }
        if (!this.dnEquals(that)) {
            return false;
        }
        int n = thisAttrIDs.length;
        if (n == 0) {
            return true;
        }
        Attributes thisAttrs = this.getAttributes();
        Attributes thatAttrs = that.getAttributes();
        if (thisAttrs == null) {
            return thatAttrs == null;
        }
        if (thatAttrs == null) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Attribute thisAttr = thisAttrs.get(thisAttrIDs[i]);
            Attribute thatAttr = thatAttrs.get(thatAttrIDs[i]);
            if (thisAttr == null) {
                return thatAttr == null;
            }
            if (thatAttr == null) {
                return false;
            }
            if (this.attrEquals(thisAttr, thatAttr)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(DirRecord that, String[] attrIDs) throws NamingException {
        return this.equals(that, attrIDs, attrIDs);
    }

    public boolean equalsAllBut(DirRecord that, String[] attrIDs) throws NamingException {
        int sz;
        if (attrIDs == null) {
            throw new NamingException("DirectoryRecord: null attrID list");
        }
        if (!this.dnEquals(that)) {
            return false;
        }
        int n = attrIDs.length;
        if (n == 0) {
            return true;
        }
        Attributes thisAttrs = this.getAttributes();
        Attributes thatAttrs = that.getAttributes();
        if (thisAttrs == null) {
            return thatAttrs == null;
        }
        if (thatAttrs == null) {
            return false;
        }
        int thatLeft = sz = thisAttrs.size();
        if (sz == 0 && thatAttrs.size() == 0) {
            return true;
        }
        NamingEnumeration<? extends Attribute> ne = thisAttrs.getAll();
        if (ne == null) {
            return false;
        }
        while (ne.hasMore()) {
            Attribute attr = ne.next();
            String id = attr.getID();
            boolean present = false;
            for (int i = 0; i < attrIDs.length; ++i) {
                if (!id.equalsIgnoreCase(attrIDs[i])) continue;
                present = true;
                break;
            }
            if (present) {
                if (thatAttrs.get(id) == null) continue;
                --thatLeft;
                continue;
            }
            Attribute thatAttr = thatAttrs.get(id);
            if (thatAttr == null) {
                return false;
            }
            if (!thatAttr.contains(attr)) {
                return false;
            }
            --thatLeft;
        }
        return thatLeft == 0;
    }

    public boolean attrEquals(Attribute thisA, Attribute that) throws NamingException {
        int sz = thisA.size();
        if (sz != that.size()) {
            return false;
        }
        if (sz == 0) {
            return true;
        }
        NamingEnumeration<?> ne = thisA.getAll();
        if (ne == null) {
            return false;
        }
        while (ne.hasMore()) {
            if (that.contains(ne.next())) continue;
            return false;
        }
        return true;
    }

    public int attrValCompare(Object val, Attribute that, boolean ignoreCase) throws NamingException {
        if (that.size() != 1) {
            NamingEnumeration<?> ne = that.getAll();
            if (ne == null) {
                return -2;
            }
            while (ne.hasMore()) {
                Object o = ne.next();
                if (!(val instanceof String ? this.compareVal(o, (String)val, ignoreCase) == 0 : o.equals(val))) continue;
                return 2;
            }
            return -2;
        }
        Object o = that.get();
        if (val instanceof String) {
            return this.compareVal(o, (String)val, ignoreCase);
        }
        if (o.equals(val)) {
            return 0;
        }
        return -2;
    }

    public int attrValCompare(Object val, String attrName, boolean ignoreCase) throws NamingException {
        Attribute a = this.findAttr(attrName);
        if (a == null) {
            return -2;
        }
        return this.attrValCompare(val, a, ignoreCase);
    }

    private int compareVal(Object o, String s, boolean ignoreCase) {
        if (!(o instanceof String)) {
            return -2;
        }
        int c = ignoreCase ? s.compareToIgnoreCase((String)o) : s.compareTo((String)o);
        if (c < 0) {
            c = -1;
        }
        if (c > 0) {
            c = 1;
        }
        return c;
    }

    public boolean dnEquals(DirRecord that) throws NamingException {
        if (that == null) {
            throw new NamingException("Null record for dnEquals");
        }
        String thisDn = this.getDn();
        if (thisDn == null) {
            throw new NamingException("No dn for this record");
        }
        String thatDn = that.getDn();
        if (thatDn == null) {
            throw new NamingException("That record has no dn");
        }
        return thisDn.equals(thatDn);
    }

    public void addAttr(String attr, Object val) throws NamingException {
        Attribute a = this.findAttr(attr);
        if (a == null) {
            this.setAttr(attr, val);
        } else {
            a.add(val);
        }
    }

    public Object getAttrVal(String attr) throws NamingException {
        if (attr.equalsIgnoreCase("dn")) {
            return this.getDn();
        }
        Attribute a = this.findAttr(attr);
        if (a == null) {
            return null;
        }
        return a.get();
    }

    public boolean contains(Attribute attr) throws NamingException {
        if (attr == null) {
            return false;
        }
        Attribute recAttr = this.getAttributes().get(attr.getID());
        if (recAttr == null) {
            return false;
        }
        NamingEnumeration<?> ne = attr.getAll();
        while (ne.hasMore()) {
            if (recAttr.contains(ne.next())) continue;
            return false;
        }
        return true;
    }

    public NamingEnumeration attrElements(String attr) throws NamingException {
        Attribute a = this.findAttr(attr);
        if (a == null) {
            return null;
        }
        return a.getAll();
    }

    public String getAttrStr(String attr) throws NamingException {
        Object o = this.getAttrVal(attr);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public boolean getIsContent() {
        return this.isContentRec;
    }

    public int getChangeType() {
        return this.changeType;
    }

    public ModificationItem[] getMods() throws NamingException {
        throw new NamingException("Not a change record");
    }

    public void setIsContent(boolean val) {
        this.isContentRec = val;
    }

    public void setChangeType(int val) {
        this.changeType = val;
    }
}

