/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.directory.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.bedework.util.directory.common.BasicDirRecord;
import org.bedework.util.directory.common.DirRecord;
import org.bedework.util.directory.common.Directory;
import org.bedework.util.logging.BwLogger;

public class LdapDirectory
extends Directory {
    private static final String defaultCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String defaultLdapURL = "ldap://localhost";
    private static final String defaultURL = "ldap://localhost";
    private String mngrDN;
    private String pw;
    private DirContext ctx;
    private SearchControls constraints;
    private NamingEnumeration recs;
    private String base;
    private Properties pr;
    private BwLogger logger = new BwLogger();

    public LdapDirectory() throws Exception {
    }

    public LdapDirectory(Properties pr, String mngrDN, String pw) throws NamingException {
        this.init(pr, mngrDN, pw);
    }

    public void init(Properties pr, String mngrDN, String pw) throws NamingException {
        if (pr == null) {
            throw new NamingException("No properties supplied");
        }
        this.pr = pr;
        this.mngrDN = mngrDN;
        this.pw = pw;
        this.reInit();
    }

    @Override
    public void reInit() throws NamingException {
        try {
            if (this.pr == null) {
                throw new Exception("No properties supplied (again)");
            }
            this.checkProp(this.pr, "java.naming.provider.url", "ldap://localhost");
            this.checkProp(this.pr, "java.naming.factory.initial", defaultCTX);
            if (this.mngrDN != null && this.pw != null) {
                this.checkProp(this.pr, "java.naming.security.authentication", "simple");
                this.pr.put("java.naming.security.principal", this.mngrDN);
                this.pr.put("java.naming.security.credentials", this.pw);
            }
            this.checkProp(this.pr, "java.naming.security.authentication", "simple");
            if (this.debug()) {
                this.debug("Directory: get new context for " + this.pr.get("java.naming.provider.url"));
            }
            this.ctx = new InitialDirContext(this.pr);
            this.constraints = new SearchControls();
            if (this.debug()) {
                this.debug("Directory: init OK " + this.pr.get("java.naming.provider.url"));
            }
        }
        catch (Throwable t) {
            throw new NamingException(t.getMessage());
        }
    }

    @Override
    public void destroy(String dn) throws NamingException {
        try {
            this.ctx.destroySubcontext(dn);
        }
        catch (Throwable t) {
            throw new NamingException(t.getMessage());
        }
    }

    @Override
    public boolean search(String base, String filter, int scope) throws NamingException {
        if (this.debug()) {
            this.debug("About to search: base=" + base + " filter=" + filter + " scope=" + scope);
        }
        this.base = base;
        this.constraints.setSearchScope(scope);
        this.constraints.setCountLimit(1000L);
        try {
            if (filter == null) {
                filter = "(objectClass=*)";
            }
            this.recs = this.ctx.search(base, filter, this.constraints);
            if (this.recs == null || !this.recs.hasMore()) {
                this.recs = null;
            }
        }
        catch (NameNotFoundException e) {
            if (this.debug()) {
                this.debug("NameNotFoundException: return with null");
            }
            this.recs = null;
        }
        catch (Throwable t) {
            throw new NamingException(t.getMessage());
        }
        return this.recs != null;
    }

    @Override
    public DirRecord nextRecord() throws NamingException {
        try {
            SearchResult s = null;
            if (this.recs == null) {
                throw new NamingException("null search result");
            }
            if (!this.recs.hasMore()) {
                this.recs = null;
                return null;
            }
            try {
                s = (SearchResult)this.recs.next();
            }
            finally {
                if (s == null) {
                    try {
                        this.recs.close();
                    }
                    catch (Exception exception) {}
                    this.recs = null;
                }
            }
            if (s == null) {
                return null;
            }
            BasicDirRecord rec = new BasicDirRecord(s.getAttributes());
            rec.setName(s.getName());
            return rec;
        }
        catch (Throwable t) {
            throw new NamingException(t.getMessage());
        }
    }

    @Override
    public boolean create(DirRecord rec) throws NamingException {
        try {
            this.ctx.createSubcontext(rec.getDn(), rec.getAttributes());
            return true;
        }
        catch (NameAlreadyBoundException nabe) {
            return false;
        }
        catch (Throwable t) {
            throw new NamingException(t.getMessage());
        }
    }

    @Override
    public void replace(String dn, String attrName, Object val) throws NamingException {
        BasicAttributes attrs = new BasicAttributes(attrName, val);
        this.ctx.modifyAttributes(dn, 2, (Attributes)attrs);
    }

    @Override
    public void replace(String dn, String attrName, Object[] val) throws NamingException {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute attr = new BasicAttribute(attrName);
        for (Object o : val) {
            attr.add(o);
        }
        this.ctx.modifyAttributes(dn, 2, (Attributes)attrs);
    }

    @Override
    public void replace(String dn, String attrName, Object oldval, Object newval) throws NamingException {
        throw new NamingException("ldap replace(old, new) not implemented");
    }

    @Override
    public void modify(String dn, ModificationItem[] mods) throws NamingException {
        this.ctx.modifyAttributes(dn, mods);
    }

    public Properties getEnvironment() throws NamingException {
        Properties pr = new Properties();
        Hashtable<?, ?> tbl = this.ctx.getEnvironment();
        Enumeration<?> e = tbl.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String val = (String)tbl.get(name);
            pr.put(name, val);
        }
        return pr;
    }

    @Override
    public void close() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ctx = null;
        }
    }

    public String checkProp(Properties pr, String name, String defaultVal) {
        String val = pr.getProperty(name);
        if (val == null) {
            pr.put(name, defaultVal);
            val = defaultVal;
        }
        return val;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

