/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.directory.ldif;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import org.bedework.util.directory.common.DirRecord;
import org.bedework.util.directory.common.Directory;
import org.bedework.util.directory.ldif.LdifRecord;
import org.bedework.util.logging.BwLogger;

public class Ldif
extends Directory {
    private InputStream in;
    private LdifRecord.Input inp;
    private final BwLogger logger = new BwLogger();

    public Ldif() throws Exception {
    }

    public Ldif(String fileName) throws Exception {
        this(new FileInputStream(fileName));
    }

    public Ldif(File f) throws Exception {
        this(new FileInputStream(f));
    }

    public Ldif(InputStream in) throws Exception {
        super(null, null);
        this.in = in;
    }

    @Override
    public void reInit() {
    }

    @Override
    public void destroy(String dn) throws NamingException {
        throw new NamingException("Cannot delete an ldif stream record");
    }

    @Override
    public boolean search(String dn, String filter, int scope) throws NamingException {
        if (this.debug()) {
            this.debug("Ldif: About to open " + dn);
        }
        this.inp = null;
        try {
            this.in = new FileInputStream(dn);
        }
        catch (Throwable t) {
            throw new NamingException(t.getMessage());
        }
        return true;
    }

    @Override
    public DirRecord nextRecord() throws NamingException {
        if (this.inp == null) {
            if (this.in == null) {
                throw new NamingException("No ldif input stream");
            }
            this.inp = new LdifRecord.Input();
            this.inp.init(new InputStreamReader(this.in));
        } else if (this.inp.eof) {
            return null;
        }
        LdifRecord ldr = new LdifRecord();
        if (!ldr.read(this.inp)) {
            return null;
        }
        return ldr;
    }

    @Override
    public boolean create(DirRecord rec) throws NamingException {
        throw new NamingException("ldif create not implemented");
    }

    @Override
    public void replace(String dn, String attrName, Object val) throws NamingException {
        throw new NamingException("ldif replace not implemented");
    }

    @Override
    public void replace(String dn, String attrName, Object[] val) throws NamingException {
        throw new NamingException("ldif replace not implemented");
    }

    @Override
    public void replace(String dn, String attrName, Object oldval, Object newval) throws NamingException {
        throw new NamingException("ldif replace not implemented");
    }

    @Override
    public void modify(String dn, ModificationItem[] mods) throws NamingException {
        throw new NamingException("ldif modify not implemented");
    }

    public static void dumpLdif(LdifOut lo, DirRecord rec) throws NamingException {
        if (rec == null) {
            throw new NamingException("dumpLdif: No record supplied");
        }
        String dn = rec.getDn();
        if (dn == null) {
            throw new NamingException("Unable to get dn");
        }
        lo.out("dn: " + dn);
        int ctype = rec.getChangeType();
        if (!rec.getIsContent()) {
            lo.out("changeType: " + LdifRecord.changeTypes[ctype]);
        }
        if (rec.getIsContent() || ctype == 1) {
            Attributes as = rec.getAttributes();
            if (as == null) {
                throw new NamingException("No attributes");
            }
            NamingEnumeration<? extends Attribute> e = as.getAll();
            while (e.hasMoreElements()) {
                Ldif.dumpAttr(lo, (Attribute)e.nextElement());
            }
        } else if (ctype == 2) {
            lo.out("changetype: delete");
        } else {
            lo.out("changetype: modify");
            ModificationItem[] mods = rec.getMods();
            if (mods == null) {
                lo.out("# Invalid record - no mods");
            } else {
                for (ModificationItem m : mods) {
                    int op = m.getModificationOp();
                    Attribute a = m.getAttribute();
                    String aid = a.getID();
                    if (op == 1) {
                        lo.out("add: " + aid);
                    } else if (op == 2) {
                        lo.out("replace: " + aid);
                    } else if (op == 3) {
                        lo.out("delete: " + aid);
                    } else {
                        lo.out("# Invalid record - bad mod op " + op);
                    }
                    Ldif.dumpAttr(lo, a);
                }
            }
            lo.out("-");
        }
        lo.out("");
    }

    public static void dumpAttr(LdifOut lo, Attribute a) throws NamingException {
        String aid = a.getID();
        NamingEnumeration<?> av = a.getAll();
        while (av != null && av.hasMoreElements()) {
            int len;
            Object o = av.nextElement();
            StringBuilder sb = new StringBuilder(aid);
            sb.append(':');
            if (o instanceof char[]) {
                sb.append(": ");
                sb.append((char[])o);
            } else {
                sb.append(' ');
                sb.append(o);
            }
            int seglen = 80;
            for (int pos = 0; pos < sb.length(); pos += len) {
                len = Math.min(seglen, sb.length() - pos);
                if (pos == 0) {
                    lo.out(sb.substring(pos, pos + len));
                } else {
                    lo.out(" " + sb.substring(pos, pos + len));
                }
                seglen = 79;
            }
        }
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.in = null;
            this.inp = null;
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    public static abstract class LdifOut {
        public abstract void out(String var1) throws NamingException;
    }
}

