/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.directory.ldif;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.bedework.util.directory.common.BasicDirRecord;
import org.bedework.util.misc.Util;

public class LdifRecord
extends BasicDirRecord {
    private Vector ldifData;
    private transient boolean somedata = false;
    private transient int state = 1;
    private static final int stateNeedDn = 1;
    private static final int stateHadDn = 2;
    private static final int stateHadChangeType = 3;
    private static final int stateDeleteRec = 4;
    private static final int stateNotModRec = 5;
    private static final int stateModrdn = 6;
    private static final int stateModify = 7;
    private static final int stateModSpec = 8;
    private static final int stateNeedAttrChangeType = 9;
    private static final int stateAttrChanges = 10;
    private static String version = null;
    private transient boolean haveControls = false;
    public static final String[] changeTypes = new String[]{"Invalid", "add", "delete", "modify", "moddn", "modrdn"};
    private Vector changes;
    private Change curChange;
    private ModificationItem[] mods = null;
    private transient Input in;
    private transient String crec;

    @Override
    public void clear() {
        super.clear();
        this.ldifData = new Vector();
        this.somedata = false;
        this.haveControls = false;
        this.state = 1;
        version = null;
        this.changes = null;
        this.mods = null;
    }

    public boolean read(Input in) throws NamingException {
        this.clear();
        this.in = in;
        this.haveControls = false;
        this.crec = null;
        while (true) {
            int alen = -1;
            try {
                this.crec = in.readFullLine();
            }
            catch (Exception e) {
                this.throwmsg(e.getMessage());
            }
            int inLen = 0;
            if (this.crec != null) {
                inLen = this.crec.length();
            }
            if (this.crec != null) {
                this.ldifData.addElement(this.crec);
                alen = this.crec.indexOf(58);
            }
            if (inLen == 0) {
                if (this.state != 8) break;
                this.invalid();
                break;
            }
            if (inLen > 0 && this.crec.startsWith("#")) continue;
            if (alen > 0) {
                String attr = null;
                StringBuffer val = null;
                boolean encoded = false;
                boolean url = false;
                int valStart = alen + 1;
                if (valStart == inLen) {
                    throw new NamingException("Bad input value \"" + this.crec + "\"");
                }
                if (alen < inLen && this.crec.charAt(valStart) == ':') {
                    ++valStart;
                    encoded = true;
                } else if (alen < inLen && this.crec.charAt(valStart) == '<') {
                    ++valStart;
                    url = true;
                }
                while (valStart < inLen && this.crec.charAt(valStart) == ' ') {
                    ++valStart;
                }
                attr = this.crec.substring(0, alen).toLowerCase();
                val = new StringBuffer(this.crec.substring(valStart));
                this.addAttrVal(attr, val.toString(), encoded, url);
                continue;
            }
            if (this.state == 8 && inLen == 1 && this.crec.equals("-")) {
                if (this.changes == null) {
                    this.changes = new Vector();
                }
                this.changes.addElement(this.curChange);
                this.curChange = null;
                this.state = 7;
                continue;
            }
            if (inLen <= 0) continue;
            this.invalid();
        }
        return this.somedata;
    }

    public void setMods(ModificationItem[] val) {
        this.mods = val;
    }

    @Override
    public ModificationItem[] getMods() throws NamingException {
        if (this.changes == null) {
            return super.getMods();
        }
        if (this.mods != null) {
            return this.mods;
        }
        this.mods = new ModificationItem[this.changes.size()];
        int modsi = 0;
        Enumeration e = this.changes.elements();
        while (e.hasMoreElements()) {
            Change c = (Change)e.nextElement();
            BasicAttribute attr = new BasicAttribute(c.name, true);
            if (c.vals != null) {
                Enumeration ve = c.vals.elements();
                while (ve.hasMoreElements()) {
                    attr.add((String)ve.nextElement());
                }
            }
            this.mods[modsi] = new ModificationItem(c.changeType, attr);
            ++modsi;
        }
        return this.mods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeInputData(Writer wtr) throws Throwable {
        if (this.ldifData == null || this.ldifData.size() == 0) {
            return false;
        }
        Writer writer = wtr;
        synchronized (writer) {
            for (int i = 0; i < this.ldifData.size(); ++i) {
                String str = (String)this.ldifData.elementAt(i);
                wtr.write(str);
                wtr.write(10);
            }
            wtr.write(10);
            wtr.flush();
        }
        return true;
    }

    public void write(Writer wtr) throws Throwable {
        wtr.write(this.getDn());
        wtr.write(10);
        throw new Exception("Incomplete");
    }

    private void throwmsg(String m) throws NamingException {
        String msg = m + " at line " + this.in.pos + " record=" + this.crec;
        this.in.skip();
        throw new NamingException(msg);
    }

    private void invalid() throws NamingException {
        this.throwmsg("Invalid LDIF data");
    }

    private void addAttrVal(String attr, String val, boolean encoded, boolean url) throws NamingException {
        if (this.state == 1) {
            if (attr.equals("version")) {
                if (version != null) {
                    this.throwmsg("Repeated version record");
                }
                if (!val.equals("1")) {
                    this.throwmsg("Invalid LDIF version " + val.toString());
                }
                version = val;
            } else if (attr.equals("dn")) {
                this.setDn(this.makeVal(val, encoded, url));
                this.state = 2;
            } else {
                this.invalid();
            }
        } else if (this.state == 2) {
            if (attr.equals("control")) {
                this.setIsContent(false);
                this.throwmsg("controls unimplemented");
            } else if (attr.equals("changetype")) {
                this.setIsContent(false);
                this.doChangeType(val);
            } else {
                if (this.haveControls) {
                    this.throwmsg("Missing changetype");
                }
                this.state = 5;
                this.addAttrVal(attr, val, encoded, url);
            }
        } else if (this.state == 4) {
            this.throwmsg("Should have no values for delete");
        } else if (this.state == 5) {
            this.addAttr(attr, this.makeVal(val, encoded, url));
        } else if (this.state == 6) {
            this.throwmsg("changetype: mod(r)dn unimplemented");
        } else if (this.state == 7) {
            if (encoded || url) {
                this.throwmsg("Invalid LDIF mod-spec");
            }
            this.curChange = new Change();
            if (attr.equals("add")) {
                this.curChange.changeType = 1;
            } else if (attr.equals("replace")) {
                this.curChange.changeType = 2;
            } else if (attr.equals("delete")) {
                this.curChange.changeType = 3;
            } else {
                this.throwmsg("Invalid LDIF mod-spec changetype");
            }
            this.curChange.name = val;
            this.state = 8;
        } else if (this.state == 8) {
            if (this.curChange == null || this.curChange.name == null) {
                this.throwmsg("LDIF software error: No current change");
            }
            if (!this.curChange.name.equalsIgnoreCase(attr)) {
                this.throwmsg("Invalid LDIF mod-spec: attribute name mismatch");
            }
            if (this.curChange.vals == null) {
                this.curChange.vals = new Vector();
            }
            this.curChange.vals.addElement(this.makeVal(val, encoded, url));
        } else {
            this.throwmsg("LDIF software error: invalid state " + this.state);
        }
        this.somedata = true;
    }

    private String makeVal(String val, boolean encoded, boolean url) throws NamingException {
        if (encoded) {
            return Util.fromBase64((String)val);
        }
        if (url) {
            this.throwmsg("url value unimplemented");
        }
        return val;
    }

    private void doChangeType(String val) throws NamingException {
        if (val.equalsIgnoreCase("add")) {
            this.setChangeType(1);
            this.state = 5;
        } else if (val.equalsIgnoreCase("delete")) {
            this.setChangeType(2);
            this.state = 4;
        } else if (val.equalsIgnoreCase("modrdn")) {
            this.setChangeType(4);
            this.state = 6;
        } else if (val.equalsIgnoreCase("moddn")) {
            this.setChangeType(4);
            this.state = 6;
        } else if (val.equalsIgnoreCase("modify")) {
            this.setChangeType(3);
            this.state = 7;
        } else {
            this.throwmsg("invalid changetype " + val);
        }
    }

    public static class Input {
        public Reader in;
        int pos = 0;
        public boolean eof = false;
        private BufferedReader rdr = null;
        private String nextLine = null;

        public Input() {
        }

        public Input(Reader in) {
            this.init(in);
        }

        public void init(Reader in) {
            this.in = in;
            this.eof = false;
            this.rdr = null;
            this.pos = 0;
            this.nextLine = null;
        }

        public String readLine() throws NamingException {
            String s = null;
            if (this.eof) {
                return null;
            }
            if (this.rdr == null) {
                this.rdr = new BufferedReader(this.in);
            }
            try {
                s = this.rdr.readLine();
                if (s == null) {
                    this.eof = true;
                    return null;
                }
                ++this.pos;
            }
            catch (EOFException e) {
                this.eof = true;
                s = null;
            }
            catch (Throwable t) {
                throw new NamingException(t.getMessage());
            }
            return s;
        }

        public String readFullLine() throws Exception {
            Object s;
            if (this.nextLine == null) {
                this.nextLine = this.readLine();
            }
            if ((s = this.nextLine) != null && ((String)s).length() > 0 && ((String)s).startsWith(" ")) {
                throw new Exception("Invalid LDIF data");
            }
            while (true) {
                this.nextLine = this.readLine();
                if (this.eof || this.nextLine.length() == 0 || !this.nextLine.startsWith(" ")) break;
                s = (String)s + this.nextLine.substring(1);
            }
            return s;
        }

        public void skip() throws NamingException {
            while (!this.eof) {
                String s = this.readLine();
                if (s != null) continue;
                return;
            }
        }

        public int getPos() {
            return this.pos;
        }
    }

    private class Change {
        int changeType;
        String name;
        Vector vals;

        private Change() {
        }
    }
}

