/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.jms;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.bedework.util.jms.NotificationException;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;

public class JmsConnectionHandler
implements Logged {
    public static int ackMode = 1;
    public static final boolean useTransactions = false;
    private final Properties pr;
    private Connection connection;
    private Queue ourQueue;
    private Session session;
    private MessageConsumer consumer;
    private final BwLogger logger = new BwLogger();

    public JmsConnectionHandler(Properties pr) {
        this.pr = pr;
    }

    public void open(String queueName) throws NotificationException {
        try {
            InitialContext ctx = new InitialContext(this.pr);
            try {
                ConnectionFactory connFactory = (ConnectionFactory)ctx.lookup(this.pr.getProperty("org.bedework.connection.factory.name"));
                this.connection = connFactory.createConnection();
            }
            catch (Throwable t) {
                if (this.debug()) {
                    this.error(t);
                }
                throw new NotificationException(t);
            }
            try {
                this.session = this.connection.createSession(false, ackMode);
                if (this.session == null) {
                    throw new NotificationException("No session created");
                }
                String qn = this.pr.getProperty("org.bedework.jms.queue.prefix") + queueName;
                try {
                    this.ourQueue = (Queue)new InitialContext().lookup(qn);
                }
                catch (NamingException ne) {
                    this.ourQueue = (Queue)ctx.lookup(qn);
                }
            }
            catch (Throwable t) {
                if (this.debug()) {
                    this.error(t);
                }
                throw new NotificationException(t);
            }
        }
        catch (NotificationException ne) {
            throw ne;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new NotificationException(t);
        }
    }

    public void close() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Throwable t) {
            this.warn(t.getMessage());
        }
    }

    public Session getSession() {
        return this.session;
    }

    public MessageProducer getProducer() throws NotificationException {
        try {
            MessageProducer sender = this.session.createProducer((Destination)this.ourQueue);
            this.connection.start();
            return sender;
        }
        catch (JMSException je) {
            throw new NotificationException(je);
        }
    }

    public MessageConsumer getConsumer() throws NotificationException {
        try {
            this.consumer = this.session.createConsumer((Destination)this.ourQueue);
            this.connection.start();
            return this.consumer;
        }
        catch (JMSException je) {
            throw new NotificationException(je);
        }
    }

    public Message receive() throws NotificationException {
        try {
            return this.consumer.receive();
        }
        catch (JMSException je) {
            if (Util.causeIs((Throwable)je, InterruptedException.class)) {
                this.warn("Received interrupted exception");
                return null;
            }
            throw new NotificationException(je);
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

