/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.jms;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import org.bedework.util.jms.JmsConnectionHandler;
import org.bedework.util.jms.NotificationException;
import org.bedework.util.jms.NotificationsHandler;
import org.bedework.util.jms.events.SysEvent;
import org.bedework.util.jms.listeners.SysEventListener;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class JmsNotificationsHandlerImpl
extends NotificationsHandler
implements Logged {
    private final JmsConnectionHandler conn;
    private final MessageProducer sender;
    private static long sends = 0L;
    private static long sendTime = 0L;
    private final BwLogger logger = new BwLogger();

    public JmsNotificationsHandlerImpl(String queueName, Properties pr) throws NotificationException {
        this.conn = new JmsConnectionHandler(pr);
        this.conn.open(queueName);
        this.sender = this.conn.getProducer();
    }

    @Override
    public void post(SysEvent ev) throws NotificationException {
        if (this.debug()) {
            this.debug(ev.toString());
        }
        try {
            ObjectMessage msg = this.conn.getSession().createObjectMessage();
            msg.setObject((Serializable)ev);
            for (SysEvent.Attribute attr : ev.getMessageAttributes()) {
                msg.setStringProperty(attr.name, attr.value);
            }
            long start = System.currentTimeMillis();
            this.sender.send((Message)msg);
            ++sends;
            sendTime += System.currentTimeMillis() - start;
        }
        catch (JMSException je) {
            throw new NotificationException(je);
        }
    }

    @Override
    public void registerListener(SysEventListener l, boolean persistent) {
    }

    @Override
    public void removeListener(SysEventListener l) {
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

